/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.fasterxml.aalto.in;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import ksp.com.fasterxml.aalto.impl.LocationImpl;
import ksp.com.fasterxml.aalto.in.ByteBasedPNameTable;
import ksp.com.fasterxml.aalto.in.PName;
import ksp.com.fasterxml.aalto.in.ReaderConfig;
import ksp.com.fasterxml.aalto.in.XmlScanner;
import ksp.com.fasterxml.aalto.util.DataUtil;
import ksp.com.fasterxml.aalto.util.XmlCharTypes;
import ksp.com.fasterxml.aalto.util.XmlChars;
import ksp.org.codehaus.stax2.XMLStreamLocation2;

public abstract class ByteBasedScanner
extends XmlScanner {
    protected static final byte BYTE_NULL = 0;
    protected static final byte BYTE_SPACE = 32;
    protected static final byte BYTE_LF = 10;
    protected static final byte BYTE_CR = 13;
    protected static final byte BYTE_TAB = 9;
    protected static final byte BYTE_LT = 60;
    protected static final byte BYTE_GT = 62;
    protected static final byte BYTE_AMP = 38;
    protected static final byte BYTE_HASH = 35;
    protected static final byte BYTE_EXCL = 33;
    protected static final byte BYTE_HYPHEN = 45;
    protected static final byte BYTE_QMARK = 63;
    protected static final byte BYTE_SLASH = 47;
    protected static final byte BYTE_EQ = 61;
    protected static final byte BYTE_QUOT = 34;
    protected static final byte BYTE_APOS = 39;
    protected static final byte BYTE_LBRACKET = 91;
    protected static final byte BYTE_RBRACKET = 93;
    protected static final byte BYTE_SEMICOLON = 59;
    protected static final byte BYTE_a = 97;
    protected static final byte BYTE_g = 103;
    protected static final byte BYTE_l = 108;
    protected static final byte BYTE_m = 109;
    protected static final byte BYTE_o = 111;
    protected static final byte BYTE_p = 112;
    protected static final byte BYTE_q = 113;
    protected static final byte BYTE_s = 115;
    protected static final byte BYTE_t = 116;
    protected static final byte BYTE_u = 117;
    protected static final byte BYTE_x = 120;
    protected static final byte BYTE_A = 65;
    protected static final byte BYTE_C = 67;
    protected static final byte BYTE_D = 68;
    protected static final byte BYTE_P = 80;
    protected static final byte BYTE_S = 83;
    protected static final byte BYTE_T = 84;
    protected int _inputPtr;
    protected int _inputEnd;
    protected int _tmpChar = 0;

    protected ByteBasedScanner(ReaderConfig cfg) {
        super(cfg);
        this._pastBytesOrChars = 0L;
        this._rowStartOffset = 0;
    }

    @Override
    protected abstract void _closeSource() throws IOException;

    @Override
    public XMLStreamLocation2 getCurrentLocation() {
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), this._pastBytesOrChars + (long)this._inputPtr, this._currRow, this._inputPtr - this._rowStartOffset);
    }

    @Override
    public int getCurrentColumnNr() {
        return this._inputPtr - this._rowStartOffset;
    }

    @Override
    public long getStartingByteOffset() {
        return this._startRawOffset;
    }

    @Override
    public long getStartingCharOffset() {
        return -1L;
    }

    @Override
    public long getEndingByteOffset() throws XMLStreamException {
        if (this._tokenIncomplete) {
            this.finishToken();
        }
        return this._pastBytesOrChars + (long)this._inputPtr;
    }

    @Override
    public long getEndingCharOffset() throws XMLStreamException {
        return -1L;
    }

    protected final void markLF(int offset) {
        this._rowStartOffset = offset;
        ++this._currRow;
    }

    protected final void markLF() {
        this._rowStartOffset = this._inputPtr;
        ++this._currRow;
    }

    protected final void setStartLocation() {
        this._startRawOffset = this._pastBytesOrChars + (long)this._inputPtr;
        this._startRow = this._currRow;
        this._startColumn = this._inputPtr - this._rowStartOffset;
    }

    protected abstract int decodeCharForError(byte var1) throws XMLStreamException;

    protected final PName addUTFPName(ByteBasedPNameTable symbols, XmlCharTypes charTypes, int hash, int[] quads, int qlen, int lastQuadBytes) throws XMLStreamException {
        boolean ok;
        int lastQuad;
        int byteLen = (qlen << 2) - 4 + lastQuadBytes;
        if (lastQuadBytes < 4) {
            lastQuad = quads[qlen - 1];
            quads[qlen - 1] = lastQuad << (4 - lastQuadBytes << 3);
        } else {
            lastQuad = 0;
        }
        int ch = quads[0] >>> 24;
        int ix = 1;
        char[] cbuf = this._nameBuffer;
        int cix = 0;
        int[] TYPES = charTypes.NAME_CHARS;
        switch (TYPES[ch]) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                ok = false;
                break;
            }
            case 3: {
                ok = true;
                break;
            }
            default: {
                int needed;
                if ((ch & 0xE0) == 192) {
                    ch &= 0x1F;
                    needed = 1;
                } else if ((ch & 0xF0) == 224) {
                    ch &= 0xF;
                    needed = 2;
                } else if ((ch & 0xF8) == 240) {
                    ch &= 7;
                    needed = 3;
                } else {
                    this.reportInvalidInitial(ch);
                    ch = 1;
                    needed = 1;
                }
                if (ix + needed > byteLen) {
                    this.reportEofInName(cbuf, 0);
                }
                ix += needed;
                int q2 = quads[0];
                int ch2 = q2 >> 16 & 0xFF;
                if ((ch2 & 0xC0) != 128) {
                    this.reportInvalidOther(ch2);
                }
                ch = ch << 6 | ch2 & 0x3F;
                if (needed > 1) {
                    ch2 = q2 >> 8 & 0xFF;
                    if ((ch2 & 0xC0) != 128) {
                        this.reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 2) {
                        ch2 = q2 & 0xFF;
                        if ((ch2 & 0xC0) != 128) {
                            this.reportInvalidOther(ch2 & 0xFF);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                    }
                }
                ok = XmlChars.is10NameStartChar(ch);
                if (needed <= 2) break;
                cbuf[cix++] = (char)(55296 + ((ch -= 65536) >> 10));
                ch = 0xDC00 | ch & 0x3FF;
            }
        }
        if (!ok) {
            this.reportInvalidNameChar(ch, 0);
        }
        cbuf[cix++] = (char)ch;
        int last_colon = -1;
        while (ix < byteLen) {
            ch = quads[ix >> 2];
            int byteIx = ix & 3;
            ch = ch >> (3 - byteIx << 3) & 0xFF;
            ++ix;
            switch (TYPES[ch]) {
                case 0: 
                case 4: {
                    ok = false;
                    break;
                }
                case 1: {
                    if (last_colon >= 0) {
                        this.reportMultipleColonsInName();
                    }
                    last_colon = cix;
                    ok = true;
                    break;
                }
                case 2: 
                case 3: {
                    ok = true;
                    break;
                }
                default: {
                    int needed;
                    if ((ch & 0xE0) == 192) {
                        ch &= 0x1F;
                        needed = 1;
                    } else if ((ch & 0xF0) == 224) {
                        ch &= 0xF;
                        needed = 2;
                    } else if ((ch & 0xF8) == 240) {
                        ch &= 7;
                        needed = 3;
                    } else {
                        this.reportInvalidInitial(ch);
                        ch = 1;
                        needed = 1;
                    }
                    if (ix + needed > byteLen) {
                        this.reportEofInName(cbuf, cix);
                    }
                    int ch2 = quads[ix >> 2];
                    byteIx = ix & 3;
                    ++ix;
                    if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                        this.reportInvalidOther(ch2);
                    }
                    ch = ch << 6 | ch2 & 0x3F;
                    if (needed > 1) {
                        ch2 = quads[ix >> 2];
                        byteIx = ix & 3;
                        ++ix;
                        if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                            this.reportInvalidOther(ch2);
                        }
                        ch = ch << 6 | ch2 & 0x3F;
                        if (needed > 2) {
                            ch2 = quads[ix >> 2];
                            byteIx = ix & 3;
                            ++ix;
                            if (((ch2 >>= 3 - byteIx << 3) & 0xC0) != 128) {
                                this.reportInvalidOther(ch2 & 0xFF);
                            }
                            ch = ch << 6 | ch2 & 0x3F;
                        }
                    }
                    ok = XmlChars.is10NameChar(ch);
                    if (needed <= 2) break;
                    ch -= 65536;
                    if (cix >= cbuf.length) {
                        this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
                    }
                    cbuf[cix++] = (char)(55296 + (ch >> 10));
                    ch = 0xDC00 | ch & 0x3FF;
                }
            }
            if (!ok) {
                this.reportInvalidNameChar(ch, cix);
            }
            if (cix >= cbuf.length) {
                this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
            }
            cbuf[cix++] = (char)ch;
        }
        String baseName = new String(cbuf, 0, cix);
        if (lastQuadBytes < 4) {
            quads[qlen - 1] = lastQuad;
        }
        return symbols.addSymbol(hash, baseName, last_colon, quads, qlen);
    }

    protected void reportInvalidInitial(int mask) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 start byte 0x" + Integer.toHexString(mask));
    }

    protected void reportInvalidOther(int mask) throws XMLStreamException {
        this.reportInputProblem("Invalid UTF-8 middle byte 0x" + Integer.toHexString(mask));
    }
}

