/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.type;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeAnnotationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lksp/org/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/type/FirResolvedTypeRefChecker;", "<init>", "()V", "check", "", "typeRef", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirTypeAnnotationChecker
extends FirTypeChecker<FirResolvedTypeRef> {
    @NotNull
    public static final FirTypeAnnotationChecker INSTANCE = new FirTypeAnnotationChecker();

    private FirTypeAnnotationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirResolvedTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirAnnotation annotation : typeRef.getAnnotations()) {
            if (annotation.getSource() == null) continue;
            AnnotationUseSiteTarget useSiteTarget2 = annotation.getUseSiteTarget();
            Set<KotlinTarget> annotationTargets = FirAnnotationHelpersKt.getAllowedAnnotationTargets(annotation, context2.getSession());
            if (useSiteTarget2 != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET_WITH_USE_SITE_TARGET(), (Object)"type usage", (Object)useSiteTarget2.getRenderName(), annotationTargets, (DiagnosticContext)context2, null, 64, null);
            } else if (!annotationTargets.contains((Object)KotlinTarget.TYPE)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_ANNOTATION_TARGET(), (Object)"type usage", annotationTargets, (DiagnosticContext)context2, null, 32, null);
            }
            if (!Intrinsics.areEqual((Object)FirAnnotationUtilsKt.toAnnotationClassId(annotation, context2.getSession()), (Object)StandardClassIds.Annotations.INSTANCE.getExtensionFunctionType())) continue;
            if (!FunctionalTypeUtilsKt.isSomeFunctionType(typeRef.getConeType(), context2.getSession())) {
                if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ForbidExtensionFunctionTypeOnNonFunctionTypes)) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context2, null, 8, null);
                    continue;
                }
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_EXTENSION_FUNCTION_TYPE_WARNING(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if (typeRef.getConeType().getTypeArguments().length > 1) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)annotation.getSource(), FirErrors.INSTANCE.getWRONG_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

