/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirUnnamedPropertyChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirUnnamedPropertyChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirUnnamedPropertyChecker INSTANCE = new FirUnnamedPropertyChecker();

    private FirUnnamedPropertyChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!Intrinsics.areEqual((Object)declaration2.getName(), (Object)SpecialNames.UNDERSCORE_FOR_UNUSED_VAR)) {
            return;
        }
        Object object = declaration2.getInitializer();
        boolean isDesugaredComponentCall = Intrinsics.areEqual((Object)(object != null && (object = ((FirExpression)object).getSource()) != null ? ((KtSourceElement)object).getKind() : null), (Object)KtFakeSourceElementKind.DesugaredComponentFunctionCall.INSTANCE);
        if (declaration2.isVar() && !isDesugaredComponentCall) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getUNNAMED_VAR_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
        }
        if (declaration2.getDelegate() != null) {
            FirExpression firExpression = declaration2.getDelegate();
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firExpression != null ? firExpression.getSource() : null), FirErrors.INSTANCE.getUNNAMED_DELEGATED_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
        }
        if (!isDesugaredComponentCall && !Intrinsics.areEqual((Object)ClassMembersKt.isCatchParameter(declaration2), (Object)true)) {
            FirHelpersKt.requireFeatureSupport(declaration2, LanguageFeature.UnnamedLocalVariables, context2, reporter, SourceElementPositioningStrategies.INSTANCE.getNAME_IDENTIFIER());
        }
    }
}

