/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtNodeTypes;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRetentionAnnotationHelpersKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import ksp.org.jetbrains.kotlin.fir.expressions.FirConstChecksKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeErrorType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u001c"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAnnotationClassMember", "member", "Lksp/org/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isAllowedClassKind", "", "cone", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "isAllowedArray", "type", "checkCyclesInParameters", "annotation", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "CycleChecker", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirAnnotationClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,242:1\n61#2:243\n*S KotlinDebug\n*F\n+ 1 FirAnnotationClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker\n*L\n44#1:243\n*E\n"})
public final class FirAnnotationClassDeclarationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirAnnotationClassDeclarationChecker INSTANCE = new FirAnnotationClassDeclarationChecker();

    private FirAnnotationClassDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (declaration2.getClassKind() != ClassKind.ANNOTATION_CLASS) {
            return;
        }
        FirClassLikeDeclaration $this$isLocal$iv = declaration2;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getLOCAL_ANNOTATION_CLASS_ERROR(), (DiagnosticContext)context2, null, 8, null);
        }
        if (declaration2.getSuperTypeRefs().size() != 1) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirErrors.INSTANCE.getSUPERTYPES_FOR_ANNOTATION_CLASS(), (DiagnosticContext)context2, null, 8, null);
        }
        DeclarationUtilsKt.processAllDeclarations$default(declaration2, context2.getSession(), null, arg_0 -> FirAnnotationClassDeclarationChecker.check$lambda$0(context2, reporter, arg_0), 2, null);
        FirSession session = context2.getSession();
        if (FirRetentionAnnotationHelpersKt.getRetention(declaration2, session) != AnnotationRetention.SOURCE && FirAnnotationHelpersKt.getAllowedAnnotationTargets(declaration2, session).contains((Object)KotlinTarget.EXPRESSION)) {
            FirElement firElement;
            FirAnnotation firAnnotation = FirRetentionAnnotationHelpersKt.getRetentionAnnotation(declaration2, session);
            if (firAnnotation != null) {
                firElement = firAnnotation;
            } else {
                FirAnnotation firAnnotation2 = FirAnnotationHelpersKt.getTargetAnnotation(declaration2, session);
                firElement = firAnnotation2 != null ? (FirElement)firAnnotation2 : (FirElement)declaration2;
            }
            FirElement target = firElement;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)target.getSource(), FirErrors.INSTANCE.getRESTRICTED_RETENTION_FOR_EXPRESSION_ANNOTATION(), (DiagnosticContext)context2, null, 8, null);
        }
        this.checkCyclesInParameters(declaration2.getSymbol(), context2, reporter);
    }

    private final void checkAnnotationClassMember(FirBasedSymbol<?> member, CheckerContext context2, DiagnosticReporter reporter) {
        block13: {
            block14: {
                block12: {
                    if (!(member instanceof FirConstructorSymbol) || !((FirConstructorSymbol)member).isPrimary()) break block12;
                    for (FirValueParameterSymbol parameter2 : ((FirConstructorSymbol)member).getValueParameterSymbols()) {
                        KtSourceElement source;
                        if (parameter2.getSource() == null) continue;
                        if (!LightTreePositioningStrategiesKt.hasValOrVar(source)) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getMISSING_VAL_ON_ANNOTATION_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                        } else if (LightTreePositioningStrategiesKt.hasVar(source)) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getVAR_ANNOTATION_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
                        }
                        if (parameter2.getHasDefaultValue() && !FirConstChecksKt.canBeEvaluatedAtCompileTime(parameter2.getResolvedDefaultValue(), context2.getSession(), true, true)) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getDefaultValueSource(), FirErrors.INSTANCE.getANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT(), (DiagnosticContext)context2, null, 8, null);
                        }
                        FirResolvedTypeRef typeRef = parameter2.getResolvedReturnTypeRef();
                        ConeKotlinType coneType = TypeExpansionUtilsKt.fullyExpandedType$default(typeRef.getConeType(), context2.getSession(), null, 2, null);
                        ClassId classId = ConeTypeUtilsKt.getClassId(coneType);
                        if (coneType instanceof ConeErrorType) continue;
                        if (ConeTypeUtilsKt.isMarkedNullable(coneType)) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getNULLABLE_TYPE_OF_ANNOTATION_MEMBER(), (DiagnosticContext)context2, null, 8, null);
                            continue;
                        }
                        if (ConeBuiltinTypeUtilsKt.isPrimitiveOrNullablePrimitive(coneType) || ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(coneType) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getKClass()) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getString()) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getPrimitiveArrayTypeByElementType().values(), (Object)classId) || CollectionsKt.contains((Iterable)StandardClassIds.INSTANCE.getUnsignedArrayTypeByElementType().values(), (Object)classId)) continue;
                        if (Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getArray())) {
                            if (!this.isAllowedArray(coneType, context2.getSession())) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), (DiagnosticContext)context2, null, 8, null);
                                continue;
                            }
                            if (parameter2.isVararg()) continue;
                            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.firstOrNull((Object[])coneType.getTypeArguments());
                            if ((coneTypeProjection != null ? ConeTypeProjectionKt.getVariance(coneTypeProjection) : null) == Variance.INVARIANT) continue;
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getPROJECTION_IN_TYPE_OF_ANNOTATION_MEMBER(), (DiagnosticContext)context2, null, 8, null);
                            continue;
                        }
                        if (this.isAllowedClassKind(coneType, context2.getSession())) continue;
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getINVALID_TYPE_OF_ANNOTATION_MEMBER(), (DiagnosticContext)context2, null, 8, null);
                    }
                    break block13;
                }
                if (member instanceof FirRegularClassSymbol) break block13;
                if (!(member instanceof FirPropertySymbol)) break block14;
                KtSourceElement ktSourceElement = ((FirPropertySymbol)member).getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getElementType() : null), (Object)KtNodeTypes.VALUE_PARAMETER)) break block13;
            }
            if (!(member instanceof FirNamedFunctionSymbol) || !((FirNamedFunctionSymbol)member).isSynthetic()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)member.getSource(), FirErrors.INSTANCE.getANNOTATION_CLASS_MEMBER(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final boolean isAllowedClassKind(ConeKotlinType cone, FirSession session) {
        ClassKind classKind2;
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(cone, session);
        if (firRegularClassSymbol == null || (classKind2 = firRegularClassSymbol.getClassKind()) == null) {
            return false;
        }
        ClassKind typeRefClassKind = classKind2;
        return typeRefClassKind == ClassKind.ANNOTATION_CLASS || typeRefClassKind == ClassKind.ENUM_CLASS;
    }

    private final boolean isAllowedArray(ConeKotlinType type2, FirSession session) {
        ConeTypeProjection[] typeArguments2 = type2.getTypeArguments();
        if (typeArguments2.length != 1) {
            return false;
        }
        ConeTypeProjection coneTypeProjection = typeArguments2[0];
        ConeKotlinTypeProjection coneKotlinTypeProjection = coneTypeProjection instanceof ConeKotlinTypeProjection ? (ConeKotlinTypeProjection)coneTypeProjection : null;
        if (coneKotlinTypeProjection == null || (coneKotlinTypeProjection = coneKotlinTypeProjection.getType()) == null || (coneKotlinTypeProjection = TypeExpansionUtilsKt.fullyExpandedType$default((ConeKotlinType)coneKotlinTypeProjection, session, null, 2, null)) == null) {
            return false;
        }
        ConeKotlinTypeProjection arrayType2 = coneKotlinTypeProjection;
        if (ConeTypeUtilsKt.isMarkedNullable((ConeKotlinType)arrayType2)) {
            return false;
        }
        ClassId arrayTypeClassId = ConeTypeUtilsKt.getClassId((ConeKotlinType)arrayType2);
        if (Intrinsics.areEqual((Object)arrayTypeClassId, (Object)StandardClassIds.INSTANCE.getKClass())) {
            return true;
        }
        if (Intrinsics.areEqual((Object)arrayTypeClassId, (Object)StandardClassIds.INSTANCE.getString())) {
            return true;
        }
        return this.isAllowedClassKind((ConeLookupTagBasedType)arrayType2, session);
    }

    private final void checkCyclesInParameters(FirRegularClassSymbol annotation, CheckerContext context2, DiagnosticReporter reporter) {
        FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(annotation, context2.getSession());
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol primaryConstructor2 = firConstructorSymbol;
        CycleChecker checker = new CycleChecker(annotation, context2.getSession());
        for (FirValueParameterSymbol valueParameter2 : primaryConstructor2.getValueParameterSymbols()) {
            if (!checker.parameterHasCycle(annotation, valueParameter2)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)valueParameter2.getSource(), FirErrors.INSTANCE.getCYCLE_IN_ANNOTATION_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private static final Unit check$lambda$0(CheckerContext $context, DiagnosticReporter $reporter, FirBasedSymbol member) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        INSTANCE.checkAnnotationClassMember(member, $context, $reporter);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003J\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker$CycleChecker;", "", "targetAnnotation", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/FirSession;)V", "getTargetAnnotation", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "visitedAnnotations", "", "annotationsWithCycle", "annotationHasCycle", "", "annotation", "parameterHasCycle", "ownedAnnotation", "parameter", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirValueParameterSymbol;", "typeHasCycle", "type", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirAnnotationClassDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirAnnotationClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker$CycleChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 declarationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeclarationUtilsKt\n*L\n1#1,242:1\n1#2:243\n248#3:244\n239#3,11:245\n*S KotlinDebug\n*F\n+ 1 FirAnnotationClassDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirAnnotationClassDeclarationChecker$CycleChecker\n*L\n235#1:244\n235#1:245,11\n*E\n"})
    private static final class CycleChecker {
        @NotNull
        private final FirRegularClassSymbol targetAnnotation;
        @NotNull
        private final FirSession session;
        @NotNull
        private final Set<FirRegularClassSymbol> visitedAnnotations;
        @NotNull
        private final Set<FirRegularClassSymbol> annotationsWithCycle;

        public CycleChecker(@NotNull FirRegularClassSymbol targetAnnotation, @NotNull FirSession session) {
            Intrinsics.checkNotNullParameter((Object)targetAnnotation, (String)"targetAnnotation");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.targetAnnotation = targetAnnotation;
            this.session = session;
            Object[] objectArray = new FirRegularClassSymbol[]{this.targetAnnotation};
            this.visitedAnnotations = SetsKt.mutableSetOf((Object[])objectArray);
            objectArray = new FirRegularClassSymbol[]{this.targetAnnotation};
            this.annotationsWithCycle = SetsKt.mutableSetOf((Object[])objectArray);
        }

        @NotNull
        public final FirRegularClassSymbol getTargetAnnotation() {
            return this.targetAnnotation;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        public final boolean annotationHasCycle(@NotNull FirRegularClassSymbol annotation) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            FirConstructorSymbol firConstructorSymbol = DeclarationUtilsKt.primaryConstructorIfAny(annotation, this.session);
            if (firConstructorSymbol == null) {
                return false;
            }
            FirConstructorSymbol primaryConstructor2 = firConstructorSymbol;
            for (FirValueParameterSymbol valueParameter2 : primaryConstructor2.getValueParameterSymbols()) {
                if (!this.parameterHasCycle(annotation, valueParameter2)) continue;
                return true;
            }
            return false;
        }

        public final boolean parameterHasCycle(@NotNull FirRegularClassSymbol ownedAnnotation, @NotNull FirValueParameterSymbol parameter2) {
            boolean bl2;
            Intrinsics.checkNotNullParameter((Object)ownedAnnotation, (String)"ownedAnnotation");
            Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
            ConeKotlinType returnType2 = TypeExpansionUtilsKt.fullyExpandedType$default(parameter2.getResolvedReturnTypeRef().getConeType(), this.session, null, 2, null);
            if (parameter2.isVararg() || ConeBuiltinTypeUtilsKt.isNonPrimitiveArray(returnType2)) {
                bl2 = false;
            } else if (!(returnType2.getTypeArguments().length == 0)) {
                if (Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(returnType2), (Object)StandardClassIds.INSTANCE.getKClass())) {
                    return false;
                }
                for (ConeTypeProjection argument : returnType2.getTypeArguments()) {
                    ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(argument);
                    if (coneKotlinType == null || !this.typeHasCycle(ownedAnnotation, coneKotlinType)) continue;
                    return true;
                }
                bl2 = false;
            } else {
                bl2 = this.typeHasCycle(ownedAnnotation, returnType2);
            }
            return bl2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean typeHasCycle(@NotNull FirRegularClassSymbol ownedAnnotation, @NotNull ConeKotlinType type2) {
            boolean bl2;
            FirRegularClassSymbol firRegularClassSymbol;
            Intrinsics.checkNotNullParameter((Object)ownedAnnotation, (String)"ownedAnnotation");
            Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
            FirRegularClassSymbol firRegularClassSymbol2 = ToSymbolUtilsKt.toRegularClassSymbol(TypeExpansionUtilsKt.fullyExpandedType$default(type2, this.session, null, 2, null), this.session);
            if (firRegularClassSymbol2 == null) return false;
            FirRegularClassSymbol it = firRegularClassSymbol = firRegularClassSymbol2;
            boolean bl3 = false;
            if (it.getClassKind() != ClassKind.ANNOTATION_CLASS) return false;
            boolean bl4 = true;
            if (!bl4) return false;
            FirRegularClassSymbol firRegularClassSymbol3 = firRegularClassSymbol;
            FirRegularClassSymbol firRegularClassSymbol4 = firRegularClassSymbol3;
            if (firRegularClassSymbol4 == null) return false;
            FirRegularClassSymbol referencedAnnotation = firRegularClassSymbol4;
            if (!this.visitedAnnotations.add(referencedAnnotation)) {
                boolean bl5;
                boolean it2 = bl5 = this.annotationsWithCycle.contains(referencedAnnotation);
                boolean bl6 = false;
                if (!it2) return bl5;
                ((Collection)this.annotationsWithCycle).add(ownedAnnotation);
                return bl5;
            }
            if (Intrinsics.areEqual((Object)referencedAnnotation, (Object)this.targetAnnotation)) {
                ((Collection)this.annotationsWithCycle).add(ownedAnnotation);
                return true;
            }
            FirBasedSymbol $this$isJavaOrEnhancement$iv = referencedAnnotation;
            boolean $i$f$isJavaOrEnhancement = false;
            FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
            boolean $i$f$isJavaOrEnhancement2 = false;
            if ($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java) return false;
            if (Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv$iv, (Object)FirDeclarationOrigin.Enhancement.INSTANCE)) {
                return false;
            }
            boolean bl7 = false;
            if (bl7) return false;
            Object e2 = $this$isJavaOrEnhancement$iv.getFir();
            Object object = e2 instanceof FirCallableDeclaration ? (FirCallableDeclaration)e2 : null;
            if (object != null && (object = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object)) != null && (object = ((ImportedFromObjectOrStaticData)object).getOriginal()) != null) {
                if (DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) {
                    return false;
                }
                bl2 = false;
            } else {
                bl2 = false;
            }
            if (bl2) {
                return false;
            }
            boolean bl8 = false;
            if (!bl8) return this.annotationHasCycle(referencedAnnotation);
            return false;
        }
    }
}

