/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.fir;

import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import ksp.com.github.benmanes.caffeine.cache.Cache;
import ksp.com.github.benmanes.caffeine.cache.Caffeine;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.progress.ProgressManager;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.LowMemoryWatcher;
import ksp.com.intellij.openapi.util.registry.Registry;
import ksp.com.intellij.util.concurrency.AppExecutorUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.api.KaSession;
import ksp.org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import ksp.org.jetbrains.kotlin.analysis.api.fir.KaFirSessionProviderKt;
import ksp.org.jetbrains.kotlin.analysis.api.fir.utils.KaFirCacheCleaner;
import ksp.org.jetbrains.kotlin.analysis.api.fir.utils.KaFirNoOpCacheCleaner;
import ksp.org.jetbrains.kotlin.analysis.api.fir.utils.KaFirStopWorldCacheCleaner;
import ksp.org.jetbrains.kotlin.analysis.api.impl.base.sessions.KaBaseSessionProvider;
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import ksp.org.jetbrains.kotlin.analysis.api.platform.KaCachedService;
import ksp.org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import ksp.org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleKt;
import ksp.org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionInvalidationListener;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsService;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains.LLAnalysisSessionStatistics;
import ksp.org.jetbrains.kotlin.psi.KtElement;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001)B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\tH\u0016J\b\u0010&\u001a\u00020\u001bH\u0002J\b\u0010'\u001a\u00020\u001bH\u0016J\b\u0010(\u001a\u00020\u001bH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R#\u0010\u0013\u001a\u0004\u0018\u00010\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0012\u0012\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "Lksp/org/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider;", "Lksp/com/intellij/openapi/Disposable;", "project", "Lksp/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lksp/com/github/benmanes/caffeine/cache/Cache;", "Lksp/org/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "Lksp/org/jetbrains/kotlin/analysis/api/KaSession;", "scheduledCacheMaintenance", "Ljava/util/concurrent/Future;", "cacheCleaner", "Lksp/org/jetbrains/kotlin/analysis/api/fir/utils/KaFirCacheCleaner;", "getCacheCleaner", "()Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirCacheCleaner;", "cacheCleaner$delegate", "Lkotlin/Lazy;", "analysisSessionStatistics", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "getAnalysisSessionStatistics$annotations", "()V", "getAnalysisSessionStatistics", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "analysisSessionStatistics$delegate", "performCacheMaintenance", "", "getAnalysisSession", "useSiteElement", "Lksp/org/jetbrains/kotlin/psi/KtElement;", "useSiteModule", "createAnalysisSession", "Lksp/org/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "useSiteKtModule", "beforeEnteringAnalysis", "session", "afterLeavingAnalysis", "handleLowMemoryEvent", "clearCaches", "dispose", "SessionInvalidationListener", "analysis-api-fir"})
public final class KaFirSessionProvider
extends KaBaseSessionProvider
implements Disposable {
    @NotNull
    private final Cache<KaModule, KaSession> cache;
    @NotNull
    private final Future<?> scheduledCacheMaintenance;
    @NotNull
    private final Lazy cacheCleaner$delegate;
    @NotNull
    private final Lazy analysisSessionStatistics$delegate;

    public KaFirSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        Cache cache2 = Caffeine.newBuilder().weakValues().build();
        Intrinsics.checkNotNullExpressionValue(cache2, (String)"build(...)");
        this.cache = cache2;
        this.cacheCleaner$delegate = LazyKt.lazy(() -> KaFirSessionProvider.cacheCleaner_delegate$lambda$0(project));
        this.analysisSessionStatistics$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaFirSessionProvider.analysisSessionStatistics_delegate$lambda$1(project));
        LowMemoryWatcher.register(this::handleLowMemoryEvent, project);
        ScheduledFuture<?> scheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> KaFirSessionProvider._init_$lambda$2(this), 10L, 10L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
        this.scheduledCacheMaintenance = scheduledFuture;
    }

    private final KaFirCacheCleaner getCacheCleaner() {
        Lazy lazy = this.cacheCleaner$delegate;
        return (KaFirCacheCleaner)lazy.getValue();
    }

    private final LLAnalysisSessionStatistics getAnalysisSessionStatistics() {
        Lazy lazy = this.analysisSessionStatistics$delegate;
        return (LLAnalysisSessionStatistics)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getAnalysisSessionStatistics$annotations() {
    }

    private final void performCacheMaintenance() {
        this.cache.cleanUp();
    }

    @Override
    @NotNull
    public KaSession getAnalysisSession(@NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        KaModule module2 = KotlinProjectStructureProvider.Companion.getModule(this.getProject(), useSiteElement, null);
        return this.getAnalysisSession(module2);
    }

    @Override
    @NotNull
    public KaSession getAnalysisSession(@NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        ProgressManager.checkCanceled();
        this.getCacheCleaner().enterAnalysis();
        try {
            if (useSiteModule instanceof KaDanglingFileModule && !KaModuleKt.isStable((KaDanglingFileModule)useSiteModule)) {
                return this.createAnalysisSession(useSiteModule);
            }
            KClass<? extends KaLifetimeToken> identifier = this.getTokenFactory().getIdentifier();
            KaFirSessionProviderKt.access$flushPendingChanges(identifier, this.getProject());
            KaSession kaSession = this.cache.get(useSiteModule, arg_0 -> KaFirSessionProvider.getAnalysisSession$lambda$3((Function1)new Function1<KaModule, KaFirSession>((Object)this){

                public final KaFirSession invoke(KaModule p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return KaFirSessionProvider.access$createAnalysisSession((KaFirSessionProvider)this.receiver, p0);
                }
            }, arg_0));
            if (kaSession == null) {
                throw new IllegalStateException("`createAnalysisSession` must not return `null`.".toString());
            }
            return kaSession;
        }
        catch (Throwable e2) {
            this.getCacheCleaner().exitAnalysis();
            throw e2;
        }
    }

    private final KaFirSession createAnalysisSession(KaModule useSiteKtModule) {
        LLFirResolveSession firResolveSession = LowLevelFirApiFacadeKt.getFirResolveSession(useSiteKtModule, this.getProject());
        KaLifetimeToken validityToken = this.getTokenFactory().create(this.getProject(), firResolveSession.getUseSiteFirSession().createValidityTracker());
        return KaFirSession.Companion.createAnalysisSessionByFirResolveSession$analysis_api_fir(firResolveSession, validityToken);
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        try {
            Object object = this.getAnalysisSessionStatistics();
            if (object != null && (object = ((LLAnalysisSessionStatistics)object).getAnalyzeCallCounter()) != null) {
                object.add(1L);
            }
            super.beforeEnteringAnalysis(session, useSiteElement);
        }
        catch (Throwable e2) {
            this.getCacheCleaner().exitAnalysis();
            throw e2;
        }
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        try {
            Object object = this.getAnalysisSessionStatistics();
            if (object != null && (object = ((LLAnalysisSessionStatistics)object).getAnalyzeCallCounter()) != null) {
                object.add(1L);
            }
            super.beforeEnteringAnalysis(session, useSiteModule);
        }
        catch (Throwable e2) {
            this.getCacheCleaner().exitAnalysis();
            throw e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        try {
            super.afterLeavingAnalysis(session, useSiteElement);
        }
        finally {
            this.getCacheCleaner().exitAnalysis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        try {
            super.afterLeavingAnalysis(session, useSiteModule);
        }
        finally {
            this.getCacheCleaner().exitAnalysis();
        }
    }

    private final void handleLowMemoryEvent() {
        this.performCacheMaintenance();
        this.getCacheCleaner().scheduleCleanup();
    }

    @Override
    public void clearCaches() {
        this.cache.invalidateAll();
    }

    @Override
    public void dispose() {
        this.scheduledCacheMaintenance.cancel(false);
    }

    private static final KaFirCacheCleaner cacheCleaner_delegate$lambda$0(Project $project) {
        return Registry.is("kotlin.analysis.lowMemoryCacheCleanup", false) ? (KaFirCacheCleaner)new KaFirStopWorldCacheCleaner($project) : (KaFirCacheCleaner)KaFirNoOpCacheCleaner.INSTANCE;
    }

    private static final LLAnalysisSessionStatistics analysisSessionStatistics_delegate$lambda$1(Project $project) {
        LLStatisticsService lLStatisticsService = LLStatisticsService.Companion.getInstance($project);
        return lLStatisticsService != null ? lLStatisticsService.getAnalysisSessions() : null;
    }

    private static final void _init_$lambda$2(KaFirSessionProvider this$0) {
        this$0.performCacheMaintenance();
    }

    private static final KaSession getAnalysisSession$lambda$3(Function1 $tmp0, Object p0) {
        return (KaSession)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ KaFirSession access$createAnalysisSession(KaFirSessionProvider $this, KaModule useSiteKtModule) {
        return $this.createAnalysisSession(useSiteKtModule);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener;", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationListener;", "project", "Lksp/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "analysisSessionProvider", "Lksp/org/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "getAnalysisSessionProvider", "()Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "afterInvalidation", "", "modules", "", "Lksp/org/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "afterGlobalInvalidation", "analysis-api-fir"})
    @SourceDebugExtension(value={"SMAP\nKaFirSessionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFirSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1869#2,2:216\n*S KotlinDebug\n*F\n+ 1 KaFirSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener\n*L\n191#1:216,2\n*E\n"})
    public static final class SessionInvalidationListener
    implements LLFirSessionInvalidationListener {
        @NotNull
        private final Project project;

        public SessionInvalidationListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        private final KaFirSessionProvider getAnalysisSessionProvider() {
            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(this.project);
            KaFirSessionProvider kaFirSessionProvider = kaSessionProvider instanceof KaFirSessionProvider ? (KaFirSessionProvider)kaSessionProvider : null;
            if (kaFirSessionProvider == null) {
                throw new IllegalStateException(("Expected the analysis session provider to be a `" + Reflection.getOrCreateKotlinClass(KaFirSessionProvider.class).getSimpleName() + "`.").toString());
            }
            return kaFirSessionProvider;
        }

        @Override
        public void afterInvalidation(@NotNull Set<? extends KaModule> modules) {
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            Iterable $this$forEach$iv = modules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KaModule it = (KaModule)element$iv;
                boolean bl2 = false;
                this.getAnalysisSessionProvider().cache.invalidate(it);
            }
        }

        @Override
        public void afterGlobalInvalidation() {
            this.getAnalysisSessionProvider().clearCaches();
        }
    }
}

