/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.SourceElement;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import ksp.org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl;
import ksp.org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtCallableDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtClass;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtParameter;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import ksp.org.jetbrains.kotlin.psi.KtTypeConstraint;
import ksp.org.jetbrains.kotlin.psi.KtTypeElement;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameter;
import ksp.org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.ManualVariance;
import ksp.org.jetbrains.kotlin.resolve.TopDownAnalysisContext;
import ksp.org.jetbrains.kotlin.resolve.VarianceConflictDiagnosticData;
import ksp.org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import ksp.org.jetbrains.kotlin.resolve.typeBinding.TypeArgumentBinding;
import ksp.org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import ksp.org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import ksp.org.jetbrains.kotlin.types.EnrichedProjectionKind;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.Variance;
import ksp.org.jetbrains.kotlin.types.checker.TypeCheckingProcedure;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cJ \u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020$H\u0002J\u001c\u0010%\u001a\u00020\u0014*\u00020&2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u001eH\u0002J#\u0010(\u001a\u0004\u0018\u00010\u0014*\u00020)2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010+J\u001a\u0010(\u001a\u00020\u0014*\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010*\u001a\u00020\u001eH\u0002J\"\u0010(\u001a\u00020\u0014*\b\u0012\u0004\u0012\u00020-0,2\u0006\u0010.\u001a\u00020/2\u0006\u0010*\u001a\u00020\u001eH\u0002J\u0010\u00100\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020$H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lksp/org/jetbrains/kotlin/resolve/VarianceCheckerCore;", "", "context", "Lksp/org/jetbrains/kotlin/resolve/BindingContext;", "diagnosticSink", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticSink;", "manualVariance", "Lksp/org/jetbrains/kotlin/resolve/ManualVariance;", "languageVersionSettings", "Lksp/org/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Lorg/jetbrains/kotlin/resolve/ManualVariance;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "check", "", "c", "Lksp/org/jetbrains/kotlin/resolve/TopDownAnalysisContext;", "checkClasses", "checkClassHeader", "", "klass", "Lksp/org/jetbrains/kotlin/psi/KtClass;", "checkMembers", "checkMember", "member", "Lksp/org/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "varianceWithManual", "Lksp/org/jetbrains/kotlin/types/Variance;", "Lksp/org/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "recordPrivateToThisIfNeeded", "checkCallableDeclaration", "trace", "declaration", "Lksp/org/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkTypeParameters", "Lksp/org/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "typePosition", "checkTypePosition", "Lksp/org/jetbrains/kotlin/psi/KtTypeReference;", "position", "(Lorg/jetbrains/kotlin/psi/KtTypeReference;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/types/Variance;)Ljava/lang/Boolean;", "Lksp/org/jetbrains/kotlin/resolve/typeBinding/TypeBinding;", "Lksp/com/intellij/psi/PsiElement;", "containingType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "isIrrelevant", "Companion", "frontend"})
@SourceDebugExtension(value={"SMAP\nVarianceChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VarianceChecker.kt\norg/jetbrains/kotlin/resolve/VarianceCheckerCore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,215:1\n1740#2,3:216\n*S KotlinDebug\n*F\n+ 1 VarianceChecker.kt\norg/jetbrains/kotlin/resolve/VarianceCheckerCore\n*L\n194#1:216,3\n*E\n"})
public final class VarianceCheckerCore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BindingContext context;
    @NotNull
    private final DiagnosticSink diagnosticSink;
    @Nullable
    private final ManualVariance manualVariance;
    @Nullable
    private final LanguageVersionSettings languageVersionSettings;

    public VarianceCheckerCore(@NotNull BindingContext context2, @NotNull DiagnosticSink diagnosticSink, @Nullable ManualVariance manualVariance, @Nullable LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)diagnosticSink, (String)"diagnosticSink");
        this.context = context2;
        this.diagnosticSink = diagnosticSink;
        this.manualVariance = manualVariance;
        this.languageVersionSettings = languageVersionSettings;
    }

    public /* synthetic */ VarianceCheckerCore(BindingContext bindingContext, DiagnosticSink diagnosticSink, ManualVariance manualVariance, LanguageVersionSettings languageVersionSettings, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            manualVariance = null;
        }
        if ((n2 & 8) != 0) {
            languageVersionSettings = null;
        }
        this(bindingContext, diagnosticSink, manualVariance, languageVersionSettings);
    }

    @NotNull
    public final BindingContext getContext() {
        return this.context;
    }

    public final void check(@NotNull TopDownAnalysisContext c2) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        this.checkClasses(c2);
        this.checkMembers(c2);
    }

    private final void checkClasses(TopDownAnalysisContext c2) {
        Map<KtClassOrObject, ClassDescriptorWithResolutionScopes> map = c2.getDeclaredClasses();
        Intrinsics.checkNotNull(map);
        for (KtClassOrObject classOrObject : map.keySet()) {
            if (!(classOrObject instanceof KtClass)) continue;
            this.checkClassHeader((KtClass)classOrObject);
        }
    }

    public final boolean checkClassHeader(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        boolean noError = true;
        for (KtSuperTypeListEntry specifier : klass.getSuperTypeListEntries()) {
            KtTypeReference ktTypeReference = specifier.getTypeReference();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, this.context, Variance.OUT_VARIANCE) : null);
        }
        return noError & this.checkTypeParameters(klass, this.context, Variance.OUT_VARIANCE);
    }

    private final void checkMembers(TopDownAnalysisContext c2) {
        Map<KtCallableDeclaration, CallableMemberDescriptor> map = c2.getMembers();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getMembers(...)");
        for (Map.Entry<KtCallableDeclaration, CallableMemberDescriptor> entry : map.entrySet()) {
            KtCallableDeclaration declaration2 = entry.getKey();
            CallableMemberDescriptor descriptor2 = entry.getValue();
            Intrinsics.checkNotNull((Object)declaration2);
            Intrinsics.checkNotNull((Object)descriptor2);
            this.checkMember(declaration2, descriptor2);
        }
    }

    public final boolean checkMember(@NotNull KtCallableDeclaration member, @NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return DescriptorVisibilities.isPrivate(descriptor2.getVisibility()) || this.checkCallableDeclaration(this.context, member, descriptor2);
    }

    private final Variance varianceWithManual(TypeParameterDescriptor $this$varianceWithManual) {
        Variance variance2;
        if (this.manualVariance != null && Intrinsics.areEqual((Object)$this$varianceWithManual.getOriginal(), (Object)this.manualVariance.getDescriptor())) {
            variance2 = this.manualVariance.getVariance();
        } else {
            Variance variance3 = $this$varianceWithManual.getVariance();
            variance2 = variance3;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)variance3), (String)"getVariance(...)");
        }
        return variance2;
    }

    public final void recordPrivateToThisIfNeeded(@NotNull CallableMemberDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.isIrrelevant(descriptor2) || !Intrinsics.areEqual((Object)descriptor2.getVisibility(), (Object)DescriptorVisibilities.PRIVATE)) {
            return;
        }
        SourceElement sourceElement = descriptor2.getSource();
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"getSource(...)");
        PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
        KtCallableDeclaration ktCallableDeclaration = psiElement instanceof KtCallableDeclaration ? (KtCallableDeclaration)psiElement : null;
        if (ktCallableDeclaration == null) {
            return;
        }
        KtCallableDeclaration psiElement2 = ktCallableDeclaration;
        if (!this.checkCallableDeclaration(this.context, psiElement2, descriptor2)) {
            VarianceCheckerCore.Companion.recordPrivateToThis(descriptor2);
        }
    }

    private final boolean checkCallableDeclaration(BindingContext trace, KtCallableDeclaration declaration2, CallableDescriptor descriptor2) {
        if (this.isIrrelevant(descriptor2)) {
            return true;
        }
        boolean noError = true;
        noError &= this.checkTypeParameters(declaration2, trace, Variance.IN_VARIANCE);
        KtTypeReference ktTypeReference = declaration2.getReceiverTypeReference();
        noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, Variance.IN_VARIANCE) : null);
        for (KtParameter parameter2 : declaration2.getValueParameters()) {
            KtTypeReference ktTypeReference2 = parameter2.getTypeReference();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference2 != null ? this.checkTypePosition(ktTypeReference2, trace, Variance.IN_VARIANCE) : null);
        }
        Variance returnTypePosition = descriptor2 instanceof VariableDescriptor && ((VariableDescriptor)descriptor2).isVar() ? Variance.INVARIANT : Variance.OUT_VARIANCE;
        TypeBinding<PsiElement> typeBinding = TypeBindingKt.createTypeBindingForReturnType(declaration2, trace);
        noError = VarianceCheckerCore.Companion.and(noError, typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, returnTypePosition)) : null);
        return noError;
    }

    private final boolean checkTypeParameters(KtTypeParameterListOwner $this$checkTypeParameters, BindingContext trace, Variance typePosition) {
        boolean noError = true;
        for (KtTypeParameter typeParameter : $this$checkTypeParameters.getTypeParameters()) {
            KtTypeReference ktTypeReference = typeParameter.getExtendsBound();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, typePosition) : null);
        }
        for (KtTypeConstraint typeConstraint : $this$checkTypeParameters.getTypeConstraints()) {
            KtTypeReference ktTypeReference = typeConstraint.getBoundTypeReference();
            noError = VarianceCheckerCore.Companion.and(noError, ktTypeReference != null ? this.checkTypePosition(ktTypeReference, trace, typePosition) : null);
        }
        return noError;
    }

    private final Boolean checkTypePosition(KtTypeReference $this$checkTypePosition, BindingContext trace, Variance position) {
        TypeBinding<KtTypeElement> typeBinding = TypeBindingKt.createTypeBinding($this$checkTypePosition, trace);
        return typeBinding != null ? Boolean.valueOf(this.checkTypePosition(typeBinding, position)) : null;
    }

    private final boolean checkTypePosition(TypeBinding<? extends PsiElement> $this$checkTypePosition, Variance position) {
        return this.checkTypePosition($this$checkTypePosition, $this$checkTypePosition.getType(), position);
    }

    private final boolean checkTypePosition(TypeBinding<? extends PsiElement> $this$checkTypePosition, KotlinType containingType, Variance position) {
        ClassifierDescriptor classifierDescriptor = $this$checkTypePosition.getType().getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            Variance declarationVariance = this.varianceWithManual((TypeParameterDescriptor)classifierDescriptor);
            if (!declarationVariance.allowsPosition(position) && !$this$checkTypePosition.getType().getAnnotations().hasAnnotation(StandardNames.FqNames.unsafeVariance)) {
                VarianceConflictDiagnosticData varianceConflictDiagnosticData = new VarianceConflictDiagnosticData(containingType, (TypeParameterDescriptor)classifierDescriptor, position);
                if ($this$checkTypePosition.isArgumentFromQualifier()) {
                    LanguageVersionSettings languageVersionSettings = this.languageVersionSettings;
                    if (languageVersionSettings == null) {
                        languageVersionSettings = LanguageVersionSettingsImpl.DEFAULT;
                    }
                    this.diagnosticSink.report(Errors.TYPE_VARIANCE_CONFLICT.on(languageVersionSettings, $this$checkTypePosition.getPsiElement(), varianceConflictDiagnosticData));
                } else if ($this$checkTypePosition.isInAbbreviation()) {
                    this.diagnosticSink.report(Errors.TYPE_VARIANCE_CONFLICT_IN_EXPANDED_TYPE.on($this$checkTypePosition.getPsiElement(), varianceConflictDiagnosticData));
                } else {
                    this.diagnosticSink.report(((DiagnosticFactory1)Errors.TYPE_VARIANCE_CONFLICT.getErrorFactory()).on($this$checkTypePosition.getPsiElement(), varianceConflictDiagnosticData));
                }
            }
            return declarationVariance.allowsPosition(position);
        }
        boolean noError = true;
        Iterator<TypeArgumentBinding<? extends PsiElement>> iterator2 = $this$checkTypePosition.getArguments().iterator();
        while (iterator2.hasNext()) {
            Variance newPosition;
            Variance variance2;
            TypeArgumentBinding<? extends PsiElement> argument;
            TypeArgumentBinding<? extends PsiElement> typeArgumentBinding = argument = iterator2.next();
            if ((typeArgumentBinding != null ? typeArgumentBinding.getTypeParameter() : null) == null || argument.getProjection().isStarProjection()) continue;
            TypeParameterDescriptor typeParameterDescriptor = argument.getTypeParameter();
            Intrinsics.checkNotNull((Object)typeParameterDescriptor);
            EnrichedProjectionKind enrichedProjectionKind = TypeCheckingProcedure.getEffectiveProjectionKind(typeParameterDescriptor, argument.getProjection());
            Intrinsics.checkNotNull((Object)((Object)enrichedProjectionKind));
            switch (WhenMappings.$EnumSwitchMapping$0[enrichedProjectionKind.ordinal()]) {
                case 1: {
                    variance2 = position;
                    break;
                }
                case 2: {
                    variance2 = position.opposite();
                    break;
                }
                case 3: {
                    variance2 = Variance.INVARIANT;
                    break;
                }
                case 4: {
                    variance2 = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            if ((newPosition = variance2) == null) continue;
            noError &= this.checkTypePosition(argument.getBinding(), containingType, newPosition);
        }
        return noError;
    }

    private final boolean isIrrelevant(CallableDescriptor descriptor2) {
        boolean bl2;
        block4: {
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
            if (classDescriptor == null) {
                return true;
            }
            ClassDescriptor containingClass = classDescriptor;
            List<TypeParameterDescriptor> list = containingClass.getTypeConstructor().getParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (this.varianceWithManual(it) == Variance.INVARIANT) continue;
                    bl2 = false;
                    break block4;
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001c\u0010\b\u001a\u00020\t*\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0082\u0004\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/VarianceCheckerCore$Companion;", "", "<init>", "()V", "recordPrivateToThis", "", "descriptor", "Lksp/org/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "and", "", "other", "(ZLjava/lang/Boolean;)Z", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        private final void recordPrivateToThis(CallableMemberDescriptor descriptor2) {
            CallableMemberDescriptor callableMemberDescriptor = descriptor2;
            if (callableMemberDescriptor instanceof FunctionDescriptorImpl) {
                ((FunctionDescriptorImpl)descriptor2).setVisibility(DescriptorVisibilities.PRIVATE_TO_THIS);
            } else if (callableMemberDescriptor instanceof PropertyDescriptorImpl) {
                ((PropertyDescriptorImpl)descriptor2).setVisibility(DescriptorVisibilities.PRIVATE_TO_THIS);
                for (PropertyAccessorDescriptor accessor : ((PropertyDescriptorImpl)descriptor2).getAccessors()) {
                    Intrinsics.checkNotNull((Object)accessor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.impl.PropertyAccessorDescriptorImpl");
                    ((PropertyAccessorDescriptorImpl)accessor).setVisibility(DescriptorVisibilities.PRIVATE_TO_THIS);
                }
            } else {
                throw new IllegalStateException("Unexpected descriptor type: " + descriptor2.getClass().getName());
            }
        }

        private final boolean and(boolean $this$and, Boolean other) {
            return other == null ? $this$and : $this$and & other;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EnrichedProjectionKind.values().length];
            try {
                nArray[EnrichedProjectionKind.OUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.IN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.INV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnrichedProjectionKind.STAR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

