/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import ksp.org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenConditionChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkDuplicatedLabels", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirWhenConditionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenConditionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenConditionChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,70:1\n44#2:71\n*S KotlinDebug\n*F\n+ 1 FirWhenConditionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenConditionChecker\n*L\n42#1:71\n*E\n"})
public final class FirWhenConditionChecker
extends FirExpressionChecker<FirWhenExpression> {
    @NotNull
    public static final FirWhenConditionChecker INSTANCE = new FirWhenConditionChecker();

    private FirWhenConditionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirWhenExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirWhenBranch branch : expression2.getBranches()) {
            FirExpression condition = branch.getCondition();
            if (condition instanceof FirElseIfTrueCondition) continue;
            FirHelpersKt.checkCondition(condition, context2, reporter);
        }
        if (expression2.getSubjectVariable() != null) {
            this.checkDuplicatedLabels(expression2, context2, reporter);
        }
    }

    private final void checkDuplicatedLabels(FirWhenExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        HashSet<Pair> checkedTypes = new HashSet<Pair>();
        HashSet<Object> checkedConstants = new HashSet<Object>();
        for (FirWhenBranch branch : expression2.getBranches()) {
            ConeKotlinType coneType;
            FirExpression condition = branch.getCondition();
            if (condition instanceof FirEqualityOperatorCall) {
                Object value2;
                Object object;
                FirCall $this$arguments$iv = (FirCall)((Object)condition);
                boolean $i$f$getArguments = false;
                List<FirExpression> arguments2 = $this$arguments$iv.getArgumentList().getArguments();
                if (arguments2.size() != 2 || !(FirExpressionUtilKt.unwrapSmartcastExpression(arguments2.get(0)) instanceof FirWhenSubjectExpression)) continue;
                FirExpression targetExpression = FirExpressionUtilKt.unwrapSmartcastExpression(arguments2.get(1));
                if (targetExpression instanceof FirLiteralExpression) {
                    object = ((FirLiteralExpression)targetExpression).getValue();
                } else if (targetExpression instanceof FirQualifiedAccessExpression) {
                    FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(((FirQualifiedAccessExpression)targetExpression).getCalleeReference(), false, 1, null);
                    object = firCallableSymbol instanceof FirEnumEntrySymbol ? (FirEnumEntrySymbol)firCallableSymbol : null;
                    if (object == null) {
                        continue;
                    }
                } else {
                    FirClassLikeSymbol<?> classSymbol;
                    if (!(targetExpression instanceof FirResolvedQualifier) || ((FirResolvedQualifier)targetExpression).getSymbol() == null || FirHelpersKt.getClassKind(classSymbol) != ClassKind.OBJECT) continue;
                    object = classSymbol.getClassId();
                }
                if (checkedConstants.add(value2 = object)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirEqualityOperatorCall)condition).getSource(), FirErrors.INSTANCE.getDUPLICATE_BRANCH_CONDITION_IN_WHEN(), (DiagnosticContext)context2, null, 8, null);
                continue;
            }
            if (!(condition instanceof FirTypeOperatorCall) || checkedTypes.add(TuplesKt.to((Object)(coneType = FirTypeUtilsKt.getConeType(((FirTypeOperatorCall)condition).getConversionTypeRef())), (Object)((Object)((FirTypeOperatorCall)condition).getOperation())))) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirTypeOperatorCall)condition).getConversionTypeRef().getSource(), FirErrors.INSTANCE.getDUPLICATE_BRANCH_CONDITION_IN_WHEN(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

