/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.common.checkers.declaration;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationChecker;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lksp/org/jetbrains/kotlin/backend/common/checkers/declaration/IrConstructorReceiverChecker;", "Lksp/org/jetbrains/kotlin/backend/common/checkers/declaration/IrDeclarationChecker;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "Lksp/org/jetbrains/kotlin/backend/common/checkers/declaration/IrFunctionChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nIrConstructorReceiverChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrConstructorReceiverChecker.kt\norg/jetbrains/kotlin/backend/common/checkers/declaration/IrConstructorReceiverChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,28:1\n1761#2,3:29\n*S KotlinDebug\n*F\n+ 1 IrConstructorReceiverChecker.kt\norg/jetbrains/kotlin/backend/common/checkers/declaration/IrConstructorReceiverChecker\n*L\n23#1:29,3\n*E\n"})
public final class IrConstructorReceiverChecker
implements IrDeclarationChecker<IrFunction> {
    @NotNull
    public static final IrConstructorReceiverChecker INSTANCE = new IrConstructorReceiverChecker();

    private IrConstructorReceiverChecker() {
    }

    @Override
    public void check(@NotNull IrFunction declaration2, @NotNull CheckerContext context2) {
        boolean bl2;
        block6: {
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            if (!(declaration2 instanceof IrConstructor)) {
                return;
            }
            if (!AdditionalIrUtilsKt.getConstructedClass((IrConstructor)declaration2).isInner() && declaration2.getDispatchReceiverParameter() != null) {
                context2.error(declaration2, "Constructors of non-inner classes can't have dispatch receiver parameters");
            }
            Iterable $this$any$iv = declaration2.getParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv;
                    boolean bl3 = false;
                    if (!(it.getKind() == IrParameterKind.ExtensionReceiver)) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            context2.error(declaration2, "Constructors can't have extension receiver parameters");
        }
    }
}

