/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import ksp.com.intellij.openapi.Forceable;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.ThrowableNotNullFunction;
import ksp.com.intellij.openapi.util.io.FileUtil;
import ksp.com.intellij.openapi.util.io.FileUtilRt;
import ksp.com.intellij.util.ExceptionUtil;
import ksp.com.intellij.util.SmartList;
import ksp.com.intellij.util.SystemProperties;
import ksp.com.intellij.util.ThrowableRunnable;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.com.intellij.util.io.DataOutputStream;
import ksp.com.intellij.util.io.PagedFileStorage;
import ksp.com.intellij.util.io.StorageLockContext;
import ksp.com.intellij.util.lang.CompoundRuntimeException;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class ResizeableMappedFile
implements Forceable,
Closeable {
    private static final Logger LOG = Logger.getInstance(ResizeableMappedFile.class);
    static final int DEFAULT_ALLOCATION_ROUND_FACTOR = 4096;
    private final PagedFileStorage storage;
    private final int initialSize;
    private volatile long logicalSize;
    private volatile long lastWrittenLogicalSize;
    private int roundingFactor;

    public ResizeableMappedFile(@NotNull Path file2, int initialSize, @Nullable StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(0);
        }
        this(file2, initialSize, lockContext, pageSize, valuesAreBufferAligned, false);
    }

    public ResizeableMappedFile(@NotNull Path file2, int initialSize, @Nullable StorageLockContext lockContext, int pageSize, boolean valuesAreBufferAligned, boolean nativeBytesOrder) throws IOException {
        if (file2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(1);
        }
        this.roundingFactor = 4096;
        this.storage = new PagedFileStorage(file2, lockContext, pageSize, valuesAreBufferAligned, nativeBytesOrder);
        this.initialSize = initialSize;
        Path storageFile = this.storage.getFile();
        Path lengthFile = this.deriveLengthFile();
        long storageFileSize = this.storage.length();
        if (!Files.exists(lengthFile, new LinkOption[0]) && storageFileSize == 0L) {
            this.logicalSize = 0L;
            this.lastWrittenLogicalSize = 0L;
            this.writeLogicalSize(0L);
        } else {
            this.lastWrittenLogicalSize = this.logicalSize = this.readLogicalSize();
            if (this.lastWrittenLogicalSize > storageFileSize) {
                LOG.warn("[" + storageFile.toAbsolutePath() + "] inconsistency: realFileSize(=" + storageFileSize + "b) > logicalSize(=" + this.lastWrittenLogicalSize + "b) -- storage file was removed/truncated? => resetting logical size to real size");
                this.lastWrittenLogicalSize = this.logicalSize = storageFileSize;
                this.writeLogicalSize(storageFileSize);
            }
        }
    }

    public boolean isNativeBytesOrder() {
        return this.storage.isNativeBytesOrder();
    }

    public void clear() throws IOException {
        this.storage.resize(0L);
        this.logicalSize = 0L;
        this.lastWrittenLogicalSize = 0L;
    }

    public long length() {
        return this.logicalSize;
    }

    private long realSize() {
        return this.storage.length();
    }

    void ensureSize(long pos) {
        this.logicalSize = Math.max(pos, this.logicalSize);
        this.expand(pos);
    }

    public void setRoundFactor(int roundingFactor) {
        this.roundingFactor = roundingFactor;
    }

    private void expand(long max) {
        long suggestedSize;
        long realSize = this.realSize();
        if (max <= realSize) {
            return;
        }
        if (realSize == 0L) {
            suggestedSize = this.doRoundToFactor(Math.max((long)this.initialSize, max));
        } else {
            suggestedSize = Math.max(realSize + 1L, 2L);
            while (max > suggestedSize) {
                long newSuggestedSize = suggestedSize * 13L >> 3;
                if (newSuggestedSize >= Integer.MAX_VALUE) {
                    suggestedSize += suggestedSize / 5L;
                    continue;
                }
                suggestedSize = newSuggestedSize;
            }
            suggestedSize = this.doRoundToFactor(suggestedSize);
        }
        try {
            this.storage.resize(suggestedSize);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private long doRoundToFactor(long suggestedSize) {
        int roundFactor = this.roundingFactor;
        if (suggestedSize % (long)roundFactor != 0L) {
            suggestedSize = (suggestedSize / (long)roundFactor + 1L) * (long)roundFactor;
        }
        return suggestedSize;
    }

    private Path deriveLengthFile() {
        Path file2 = this.storage.getFile();
        return file2.resolveSibling(file2.getFileName() + ".len");
    }

    private void writeLogicalSize(long logicalSize) {
        Path lengthFile = this.deriveLengthFile();
        try {
            FileUtilRt.doIOOperation(lastAttempt -> {
                Boolean bl2;
                DataOutputStream stream = new DataOutputStream(Files.newOutputStream(lengthFile, new OpenOption[0]));
                try {
                    stream.writeLong(logicalSize);
                    bl2 = Boolean.TRUE;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        if (ex instanceof NoSuchFileException) {
                            this.ensureParentDirectoryExists();
                        }
                        if (lastAttempt) {
                            throw ex;
                        }
                        return null;
                    }
                }
                stream.close();
                return bl2;
            });
        }
        catch (IOException e2) {
            LOG.error("Can't write logical size to [" + lengthFile.toAbsolutePath() + "]", e2);
        }
    }

    @Override
    public boolean isDirty() {
        return this.storage.isDirty();
    }

    @Override
    public void force() throws IOException {
        this.ensureLogicalSizeWritten();
        this.storage.force();
    }

    private void ensureLogicalSizeWritten() {
        if (this.lastWrittenLogicalSize != this.logicalSize) {
            this.writeLogicalSize(this.logicalSize);
            this.lastWrittenLogicalSize = this.logicalSize;
        }
    }

    private void ensureParentDirectoryExists() throws IOException {
        Path parentDir = this.storage.getFile().getParent();
        Files.createDirectories(parentDir, new FileAttribute[0]);
    }

    private long readLogicalSize() throws IOException {
        long l2;
        Path storageFile = this.storage.getFile();
        Path lengthFile = this.deriveLengthFile();
        DataInputStream stream = new DataInputStream(Files.newInputStream(lengthFile, StandardOpenOption.READ));
        try {
            l2 = stream.readLong();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e2) {
                long realSize = this.realSize();
                this.writeLogicalSize(realSize);
                LOG.info("Can't find .len file for " + storageFile + ", re-creating it from actual file. Storage size = " + realSize + ", file size = " + Files.size(storageFile), e2);
                return realSize;
            }
        }
        stream.close();
        return l2;
    }

    public int getInt(long index2) throws IOException {
        return this.storage.getInt(index2);
    }

    public void putInt(long index2, int value2) throws IOException {
        this.ensureSize(index2 + 4L);
        this.storage.putInt(index2, value2);
    }

    public long getLong(long index2) throws IOException {
        return this.storage.getLong(index2);
    }

    public void putLong(long index2, long value2) throws IOException {
        this.ensureSize(index2 + 8L);
        this.storage.putLong(index2, value2);
    }

    public byte get(long index2) throws IOException {
        return this.get(index2, true);
    }

    public byte get(long index2, boolean checkAccess) throws IOException {
        return this.storage.get(index2, checkAccess);
    }

    public void get(long index2, byte[] dst, int offset, int length, boolean checkAccess) throws IOException {
        this.storage.get(index2, dst, offset, length, checkAccess);
    }

    public void put(long index2, byte[] src, int offset, int length) throws IOException {
        this.ensureSize(index2 + (long)length);
        this.storage.put(index2, src, offset, length);
    }

    /*
     * WARNING - void declaration
     */
    public void put(long index2, @NotNull ByteBuffer byteBuffer) throws IOException {
        void buffer;
        if (byteBuffer == null) {
            ResizeableMappedFile.$$$reportNull$$$0(2);
        }
        this.ensureSize(index2 + (long)(buffer.limit() - buffer.position()));
        this.storage.putBuffer(index2, (ByteBuffer)buffer);
    }

    @Override
    public void close() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
        throwableRunnableArray[0] = () -> {
            this.ensureLogicalSizeWritten();
            assert (this.logicalSize == this.lastWrittenLogicalSize);
            this.storage.force();
            boolean truncateOnClose = SystemProperties.getBooleanProperty("idea.resizeable.file.truncate.on.close", false);
            if (truncateOnClose && this.logicalSize < this.storage.length()) {
                this.storage.resize(this.logicalSize);
            }
        };
        throwableRunnableArray[1] = this.storage::close;
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Failed to close ResizableMappedFile[" + this.getPagedFileStorage().getFile() + "]"), throwableRunnableArray);
    }

    @NotNull
    public PagedFileStorage getPagedFileStorage() {
        PagedFileStorage pagedFileStorage = this.storage;
        if (pagedFileStorage == null) {
            ResizeableMappedFile.$$$reportNull$$$0(3);
        }
        return pagedFileStorage;
    }

    @NotNull
    public StorageLockContext getStorageLockContext() {
        StorageLockContext storageLockContext = this.storage.getStorageLockContext();
        if (storageLockContext == null) {
            ResizeableMappedFile.$$$reportNull$$$0(4);
        }
        return storageLockContext;
    }

    @NotNull
    public <R> R readInputStream(@NotNull ThrowableNotNullFunction<? super InputStream, R, ? extends IOException> consumer2) throws IOException {
        if (consumer2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(5);
        }
        R r2 = this.storage.readInputStream(consumer2);
        if (r2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(6);
        }
        return r2;
    }

    @NotNull
    public <R> R readChannel(@NotNull ThrowableNotNullFunction<? super ReadableByteChannel, R, ? extends IOException> consumer2) throws IOException {
        if (consumer2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(7);
        }
        R r2 = this.storage.readChannel(consumer2);
        if (r2 == null) {
            ResizeableMappedFile.$$$reportNull$$$0(8);
        }
        return r2;
    }

    public void lockRead() {
        this.storage.lockRead();
    }

    public void unlockRead() {
        this.storage.unlockRead();
    }

    public void lockWrite() {
        this.storage.lockWrite();
    }

    public void unlockWrite() {
        this.storage.unlockWrite();
    }

    public void closeAndRemoveAllFiles() throws IOException {
        SmartList exceptions = new SmartList();
        ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(this.storage::close));
        ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(() -> FileUtil.delete(this.storage.getFile())));
        ContainerUtil.addIfNotNull(exceptions, ExceptionUtil.runAndCatch(() -> FileUtil.delete(this.deriveLengthFile())));
        if (!exceptions.isEmpty()) {
            throw new IOException(new CompoundRuntimeException(exceptions));
        }
    }

    public String toString() {
        return "ResizeableMappedFile[" + this.storage.toString() + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/io/ResizeableMappedFile";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/io/ResizeableMappedFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPagedFileStorage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStorageLockContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readInputStream";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "readChannel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readInputStream";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readChannel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

