/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.vfs.newvfs.events;

import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileSystem;
import ksp.com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class VFileCopyEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myNewParent;
    private final String myNewChildName;

    @ApiStatus.Internal
    public VFileCopyEvent(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String newChildName) {
        if (file2 == null) {
            VFileCopyEvent.$$$reportNull$$$0(0);
        }
        if (newParent == null) {
            VFileCopyEvent.$$$reportNull$$$0(1);
        }
        if (newChildName == null) {
            VFileCopyEvent.$$$reportNull$$$0(2);
        }
        super(requestor);
        this.myFile = file2;
        this.myNewParent = newParent;
        this.myNewChildName = newChildName;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            VFileCopyEvent.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getNewParent() {
        VirtualFile virtualFile = this.myNewParent;
        if (virtualFile == null) {
            VFileCopyEvent.$$$reportNull$$$0(4);
        }
        return virtualFile;
    }

    @NotNull
    public String getNewChildName() {
        String string2 = this.myNewChildName;
        if (string2 == null) {
            VFileCopyEvent.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Nullable
    public VirtualFile findCreatedFile() {
        return this.myNewParent.isValid() ? this.myNewParent.findChild(this.myNewChildName) : null;
    }

    public String toString() {
        return "VfsEvent[copy " + this.myFile + " to " + this.myNewParent + " as " + this.myNewChildName + "]";
    }

    @Override
    @NotNull
    protected String computePath() {
        String string2 = this.myNewParent.getPath() + "/" + this.myNewChildName;
        if (string2 == null) {
            VFileCopyEvent.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            VFileCopyEvent.$$$reportNull$$$0(7);
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && this.myNewParent.findChild(this.myNewChildName) == null;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        VFileCopyEvent event = (VFileCopyEvent)o2;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewChildName.equals(event.myNewChildName)) {
            return false;
        }
        return this.myNewParent.equals(event.myNewParent);
    }

    @Override
    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + this.myNewParent.hashCode();
        result2 = 31 * result2 + this.myNewChildName.hashCode();
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChildName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/vfs/newvfs/events/VFileCopyEvent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewParent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewChildName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

