/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.type;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirArrayOfNothingQualifierCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.type.FirTypeChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/type/FirArrayOfNothingTypeChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/type/FirTypeChecker;", "Lksp/org/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/type/FirResolvedTypeRefChecker;", "<init>", "()V", "check", "", "typeRef", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirArrayOfNothingTypeChecker
extends FirTypeChecker<FirResolvedTypeRef> {
    @NotNull
    public static final FirArrayOfNothingTypeChecker INSTANCE = new FirArrayOfNothingTypeChecker();

    private FirArrayOfNothingTypeChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirResolvedTypeRef typeRef, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        boolean isVararg2;
        Intrinsics.checkNotNullParameter((Object)typeRef, (String)"typeRef");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (CollectionsKt.lastOrNull(context2.getContainingDeclarations()) instanceof FirTypeAlias) {
            return;
        }
        ConeKotlinType fullyExpandedType2 = TypeExpansionUtilsKt.fullyExpandedType$default(typeRef.getConeType(), context2.getSession(), null, 2, null);
        Object object = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        FirValueParameter firValueParameter = object instanceof FirValueParameter ? (FirValueParameter)object : null;
        boolean bl = isVararg2 = firValueParameter != null ? firValueParameter.isVararg() : false;
        if (!isVararg2 && FirArrayOfNothingQualifierCheckerKt.isArrayOfNothing(fullyExpandedType2, context2.getLanguageVersionSettings())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Array<Nothing> is illegal", (DiagnosticContext)context2, null, 16, null);
        }
    }
}

