/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirTypeAliasExpandsToArrayOfNothingsCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasExpandsToArrayOfNothingsChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeAliasChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirTypeAliasExpandsToArrayOfNothingsChecker
extends FirDeclarationChecker<FirTypeAlias> {
    @NotNull
    public static final FirTypeAliasExpandsToArrayOfNothingsChecker INSTANCE = new FirTypeAliasExpandsToArrayOfNothingsChecker();

    private FirTypeAliasExpandsToArrayOfNothingsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirTypeAlias declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ConeClassLikeType coneClassLikeType = FirDeclarationUtilKt.getExpandedConeType(declaration2);
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType type2 = coneClassLikeType;
        boolean allowNullableNothing = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.NullableNothingInReifiedPosition);
        if (FirTypeAliasExpandsToArrayOfNothingsCheckerKt.isMalformedExpandedType(type2, context2, allowNullableNothing)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getExpandedTypeRef().getSource(), FirErrors.INSTANCE.getTYPEALIAS_EXPANDS_TO_ARRAY_OF_NOTHINGS(), (Object)type2, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

