/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.Language;
import ksp.com.intellij.lang.PsiBuilder;
import ksp.com.intellij.lang.PsiBuilderFactory;
import ksp.com.intellij.lexer.Lexer;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.IErrorCounterReparseableElementType;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.ElementTypeUtils;
import ksp.org.jetbrains.kotlin.idea.KotlinLanguage;
import ksp.org.jetbrains.kotlin.lexer.KotlinLexer;
import ksp.org.jetbrains.kotlin.lexer.KtTokens;
import ksp.org.jetbrains.kotlin.parsing.KotlinParser;
import ksp.org.jetbrains.kotlin.psi.KtFunctionLiteral;
import ksp.org.jetbrains.kotlin.psi.KtLambdaExpression;
import ksp.org.jetbrains.kotlin.psi.KtParameterList;

class LambdaExpressionElementType
extends IErrorCounterReparseableElementType {
    public LambdaExpressionElementType() {
        super("LAMBDA_EXPRESSION", KotlinLanguage.INSTANCE);
    }

    @Override
    public ASTNode parseContents(ASTNode chameleon) {
        Project project = chameleon.getPsi().getProject();
        PsiBuilder builder2 = PsiBuilderFactory.getInstance().createBuilder(project, chameleon, null, (Language)KotlinLanguage.INSTANCE, chameleon.getChars());
        return KotlinParser.parseLambdaExpression(builder2).getFirstChildNode();
    }

    @Override
    public ASTNode createNode(CharSequence text) {
        return new KtLambdaExpression(text);
    }

    @Override
    public boolean isParsable(@Nullable ASTNode parent2, CharSequence buffer, Language fileLanguage, Project project) {
        return super.isParsable(parent2, buffer, fileLanguage, project) && !LambdaExpressionElementType.wasArrowMovedOrDeleted(parent2, buffer) && !LambdaExpressionElementType.wasParameterCommaMovedOrDeleted(parent2, buffer);
    }

    private static boolean wasArrowMovedOrDeleted(@Nullable ASTNode parent2, CharSequence buffer) {
        KtLambdaExpression lambdaExpression = LambdaExpressionElementType.findLambdaExpression(parent2);
        if (lambdaExpression == null) {
            return false;
        }
        KtFunctionLiteral literal = lambdaExpression.getFunctionLiteral();
        PsiElement arrow = literal.getArrow();
        if (arrow == null) {
            return false;
        }
        int arrowOffset = arrow.getStartOffsetInParent() + literal.getStartOffsetInParent();
        return LambdaExpressionElementType.hasTokenMoved(lambdaExpression.getText(), buffer, arrowOffset, KtTokens.ARROW);
    }

    private static boolean wasParameterCommaMovedOrDeleted(@Nullable ASTNode parent2, CharSequence buffer) {
        KtLambdaExpression lambdaExpression = LambdaExpressionElementType.findLambdaExpression(parent2);
        if (lambdaExpression == null) {
            return false;
        }
        KtFunctionLiteral literal = lambdaExpression.getFunctionLiteral();
        KtParameterList valueParameterList = literal.getValueParameterList();
        if (valueParameterList == null || valueParameterList.getParameters().size() <= 1) {
            return false;
        }
        PsiElement comma = valueParameterList.getFirstComma();
        if (comma == null) {
            return false;
        }
        int commaOffset = comma.getTextOffset() - lambdaExpression.getTextOffset();
        return LambdaExpressionElementType.hasTokenMoved(lambdaExpression.getText(), buffer, commaOffset, KtTokens.COMMA);
    }

    private static KtLambdaExpression findLambdaExpression(@Nullable ASTNode parent2) {
        if (parent2 == null) {
            return null;
        }
        PsiElement parentPsi = parent2.getPsi();
        KtLambdaExpression[] lambdaExpressions = (KtLambdaExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)parentPsi, KtLambdaExpression.class);
        if (lambdaExpressions == null || lambdaExpressions.length != 1) {
            return null;
        }
        return lambdaExpressions[0];
    }

    private static boolean hasTokenMoved(String oldText, CharSequence buffer, int oldOffset, IElementType tokenType) {
        IElementType oldType;
        KotlinLexer oldLexer = new KotlinLexer();
        oldLexer.start(oldText);
        KotlinLexer newLexer = new KotlinLexer();
        newLexer.start(buffer);
        while ((oldType = ((Lexer)oldLexer).getTokenType()) != null) {
            IElementType newType = ((Lexer)newLexer).getTokenType();
            if (newType == null) {
                return true;
            }
            if (newType != oldType) {
                if (newType == KtTokens.WHITE_SPACE) {
                    ((Lexer)newLexer).advance();
                    continue;
                }
                if (oldType == KtTokens.WHITE_SPACE) {
                    ((Lexer)oldLexer).advance();
                    continue;
                }
                return true;
            }
            if (oldType == tokenType && ((Lexer)oldLexer).getCurrentPosition().getOffset() == oldOffset) break;
            ((Lexer)oldLexer).advance();
            ((Lexer)newLexer).advance();
        }
        return false;
    }

    @Override
    public int getErrorsCount(CharSequence seq, Language fileLanguage, Project project) {
        return ElementTypeUtils.getKotlinBlockImbalanceCount(seq);
    }
}

