/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.util.DumpIrTreeOptions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J+\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\r\"\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/ir/util/FlagsRenderer;", "", "flagsFilter", "Lksp/org/jetbrains/kotlin/ir/util/DumpIrTreeOptions$FlagsFilter;", "isReference", "", "<init>", "(Lorg/jetbrains/kotlin/ir/util/DumpIrTreeOptions$FlagsFilter;Z)V", "renderFlagsList", "", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "flags", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;[Ljava/lang/String;)Ljava/lang/String;", "ir.tree"})
final class FlagsRenderer {
    @NotNull
    private final DumpIrTreeOptions.FlagsFilter flagsFilter;
    private final boolean isReference;

    public FlagsRenderer(@NotNull DumpIrTreeOptions.FlagsFilter flagsFilter, boolean isReference) {
        Intrinsics.checkNotNullParameter((Object)flagsFilter, (String)"flagsFilter");
        this.flagsFilter = flagsFilter;
        this.isReference = isReference;
    }

    @NotNull
    public final String renderFlagsList(@NotNull IrDeclaration declaration2, String ... flags) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        List<String> flagsList = this.flagsFilter.filterFlags(declaration2, this.isReference, ArraysKt.filterNotNull((Object[])flags));
        if (flagsList.isEmpty()) {
            return "";
        }
        return CollectionsKt.joinToString$default((Iterable)flagsList, (CharSequence)",", (CharSequence)"[", (CharSequence)"] ", (int)0, null, null, (int)56, null);
    }
}

