/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.util.MathUtil;
import ksp.com.intellij.util.SystemProperties;
import ksp.com.intellij.util.io.OpenChannelsCache;
import ksp.com.intellij.util.system.CpuArch;
import ksp.org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class PageCacheUtils {
    private static final Logger LOG = Logger.getInstance(PageCacheUtils.class);
    public static final int DEFAULT_PAGE_SIZE = Math.max(1, SystemProperties.getIntProperty("idea.paged.storage.page.size", 10)) * 0x100000;
    public static final long MAX_DIRECT_MEMORY_TO_USE_BYTES = PageCacheUtils.maxDirectMemory() - 2L * (long)DEFAULT_PAGE_SIZE;
    public static final long FILE_PAGE_CACHES_TOTAL_CAPACITY_BYTES = MathUtil.clamp(SystemProperties.getLongProperty("file-page-cache.cache-capacity-mb", CpuArch.is32Bit() ? 200L : 600L) * 0x100000L, Math.min(0x6400000L, MAX_DIRECT_MEMORY_TO_USE_BYTES), MAX_DIRECT_MEMORY_TO_USE_BYTES);
    public static final boolean LOCK_FREE_PAGE_CACHE_ENABLED = SystemProperties.getBooleanProperty("vfs.lock-free-impl.enable", true);
    public static final double NEW_PAGE_CACHE_MEMORY_FRACTION = SystemProperties.getFloatProperty("vfs.lock-free-impl.fraction-direct-memory-to-utilize", 0.2f);
    public static final long FILE_PAGE_CACHE_NEW_CAPACITY_BYTES = LOCK_FREE_PAGE_CACHE_ENABLED ? Math.round(NEW_PAGE_CACHE_MEMORY_FRACTION * (double)FILE_PAGE_CACHES_TOTAL_CAPACITY_BYTES) : 0L;
    public static final long FILE_PAGE_CACHE_OLD_CAPACITY_BYTES = FILE_PAGE_CACHES_TOTAL_CAPACITY_BYTES - FILE_PAGE_CACHE_NEW_CAPACITY_BYTES;
    static final int MAX_DIRECT_BUFFERS_POOL_BYTES = (int)Math.min(0x6400000L, Math.max(0L, MAX_DIRECT_MEMORY_TO_USE_BYTES - FILE_PAGE_CACHES_TOTAL_CAPACITY_BYTES - 314572800L));
    static final float HEAP_CAPACITY_FRACTION = SystemProperties.getFloatProperty("vfs.lock-free-impl.heap-capacity-ratio", 0.1f);
    private static final int CHANNELS_CACHE_CAPACITY = SystemProperties.getIntProperty("paged.file.storage.open.channel.cache.capacity", 400);
    static final OpenChannelsCache CHANNELS_CACHE = new OpenChannelsCache(CHANNELS_CACHE_CAPACITY);

    private static long maxDirectMemory() {
        try {
            Class<?> aClass = Class.forName("jdk.internal.misc.VM");
            Method maxDirectMemory = aClass.getMethod("maxDirectMemory", new Class[0]);
            return (Long)maxDirectMemory.invoke(null, new Object[0]);
        }
        catch (Throwable aClass) {
            try {
                Class<?> aClass2 = Class.forName("sun.misc.VM");
                Method maxDirectMemory = aClass2.getMethod("maxDirectMemory", new Class[0]);
                return (Long)maxDirectMemory.invoke(null, new Object[0]);
            }
            catch (Throwable aClass2) {
                try {
                    Class<?> aClass3 = Class.forName("java.nio.Bits");
                    Field maxMemory = aClass3.getDeclaredField("maxMemory");
                    maxMemory.setAccessible(true);
                    return (Long)maxMemory.get(null);
                }
                catch (Throwable aClass3) {
                    try {
                        Class<?> aClass4 = Class.forName("java.nio.Bits");
                        Field maxMemory = aClass4.getDeclaredField("MAX_MEMORY");
                        maxMemory.setAccessible(true);
                        return (Long)maxMemory.get(null);
                    }
                    catch (Throwable throwable) {
                        return Runtime.getRuntime().maxMemory();
                    }
                }
            }
        }
    }

    private PageCacheUtils() {
        throw new AssertionError((Object)"Not for instantiation");
    }

    static {
        LOG.info("File page caching params:");
        LOG.info("\tDEFAULT_PAGE_SIZE: " + DEFAULT_PAGE_SIZE);
        LOG.info("\tDirect memory to use, max: " + MAX_DIRECT_MEMORY_TO_USE_BYTES);
        if (LOCK_FREE_PAGE_CACHE_ENABLED) {
            LOG.info("\tFilePageCache: regular + lock-free (LOCK_FREE_PAGE_CACHE_ENABLED:true)");
            LOG.info("\tNEW_PAGE_CACHE_MEMORY_FRACTION: " + NEW_PAGE_CACHE_MEMORY_FRACTION);
            LOG.info("\tRegular FilePageCache: " + FILE_PAGE_CACHE_OLD_CAPACITY_BYTES + " bytes");
            LOG.info("\tNew     FilePageCache: " + FILE_PAGE_CACHE_NEW_CAPACITY_BYTES + " bytes (+ up to " + HEAP_CAPACITY_FRACTION * 100.0f + "% overflow)");
        } else {
            LOG.info("\tFilePageCache: regular");
            LOG.info("\tRegular FilePageCache: " + FILE_PAGE_CACHE_OLD_CAPACITY_BYTES + " bytes");
        }
        LOG.info("\tDirectByteBuffers pool: " + MAX_DIRECT_BUFFERS_POOL_BYTES + " bytes");
    }
}

