/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.vfs.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import ksp.com.intellij.ide.highlighter.ArchiveFileType;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.application.ex.ApplicationManagerEx;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.fileTypes.FileTypeRegistry;
import ksp.com.intellij.openapi.util.InvalidDataException;
import ksp.com.intellij.openapi.util.JDOMUtil;
import ksp.com.intellij.openapi.util.Pair;
import ksp.com.intellij.openapi.util.TraceableDisposable;
import ksp.com.intellij.openapi.util.Trinity;
import ksp.com.intellij.openapi.util.io.FileUtil;
import ksp.com.intellij.openapi.vfs.StandardFileSystems;
import ksp.com.intellij.openapi.vfs.VfsUtilCore;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileVisitor;
import ksp.com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import ksp.com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import ksp.com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import ksp.com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import ksp.com.intellij.util.ArrayUtil;
import ksp.com.intellij.util.ArrayUtilRt;
import ksp.com.intellij.util.containers.ConcurrentList;
import ksp.com.intellij.util.containers.ContainerUtil;
import ksp.org.jdom.Element;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class VirtualFilePointerContainerImpl
extends TraceableDisposable
implements VirtualFilePointerContainer,
Disposable {
    private static final Logger LOG = Logger.getInstance(VirtualFilePointerContainer.class);
    private static final int UNINITIALIZED = -1;
    @NotNull
    private final ConcurrentList<VirtualFilePointer> myList;
    @NotNull
    private final ConcurrentList<VirtualFilePointer> myJarDirectories;
    @NotNull
    private final ConcurrentList<VirtualFilePointer> myJarRecursiveDirectories;
    @NotNull
    private final VirtualFilePointerManager myVirtualFilePointerManager;
    @NotNull
    private final Disposable myParent;
    private final VirtualFilePointerListener myListener;
    private volatile Trinity<String[], VirtualFile[], VirtualFile[]> myCachedThings;
    private volatile long myTimeStampOfCachedThings;
    @NonNls
    public static final String URL_ATTR = "url";
    private boolean myDisposed;
    private static final boolean TRACE_CREATION = LOG.isDebugEnabled() || ApplicationManager.getApplication().isUnitTestMode();
    @NonNls
    public static final String JAR_DIRECTORY_ELEMENT = "jarDirectory";
    @NonNls
    public static final String RECURSIVE_ATTR = "recursive";
    private static final Trinity<String[], VirtualFile[], VirtualFile[]> EMPTY = Trinity.create(ArrayUtilRt.EMPTY_STRING_ARRAY, VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY);

    VirtualFilePointerContainerImpl(@NotNull VirtualFilePointerManager manager, @NotNull Disposable parentDisposable, @Nullable VirtualFilePointerListener listener2) {
        if (manager == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(1);
        }
        super(TRACE_CREATION && !ApplicationManagerEx.isInStressTest());
        this.myList = ContainerUtil.createConcurrentList();
        this.myJarDirectories = ContainerUtil.createConcurrentList();
        this.myJarRecursiveDirectories = ContainerUtil.createConcurrentList();
        this.myTimeStampOfCachedThings = -1L;
        this.myVirtualFilePointerManager = manager;
        this.myParent = parentDisposable;
        this.myListener = listener2;
    }

    @Override
    public void readExternal(@NotNull Element rootChild, @NotNull String childName, boolean externalizeJarDirectories) throws InvalidDataException {
        if (rootChild == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(2);
        }
        if (childName == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(3);
        }
        List<Element> urls = rootChild.getChildren(childName);
        this.addAll(ContainerUtil.map(urls, url -> url.getAttributeValue(URL_ATTR)));
        if (externalizeJarDirectories) {
            List<Element> jarDirs = rootChild.getChildren(JAR_DIRECTORY_ELEMENT);
            for (Element jarDir : jarDirs) {
                String url2 = jarDir.getAttributeValue(URL_ATTR);
                if (url2 == null) {
                    throw new InvalidDataException("path element without url: " + JDOMUtil.getValue(jarDir));
                }
                boolean recursive = Boolean.parseBoolean(jarDir.getAttributeValue(RECURSIVE_ATTR, "false"));
                this.addJarDirectory(url2, recursive);
            }
        }
    }

    @Override
    public void writeExternal(@NotNull Element element2, @NotNull String childElementName, boolean externalizeJarDirectories) {
        if (element2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(4);
        }
        if (childElementName == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(5);
        }
        for (VirtualFilePointer pointer : this.myList) {
            String url = pointer.getUrl();
            if (url.isEmpty()) continue;
            Element rootPathElement = new Element(childElementName);
            rootPathElement.setAttribute(URL_ATTR, url);
            element2.addContent(rootPathElement);
        }
        if (externalizeJarDirectories) {
            VirtualFilePointerContainerImpl.writeJarDirs(this.myJarDirectories, element2, false);
            VirtualFilePointerContainerImpl.writeJarDirs(this.myJarRecursiveDirectories, element2, true);
        }
    }

    private static void writeJarDirs(@NotNull List<? extends VirtualFilePointer> myJarDirectories, @NotNull Element element2, boolean recursive) {
        if (myJarDirectories == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(7);
        }
        ArrayList<? extends VirtualFilePointer> jarDirectories = new ArrayList<VirtualFilePointer>(myJarDirectories);
        jarDirectories.sort(Comparator.comparing(VirtualFilePointer::getUrl, String.CASE_INSENSITIVE_ORDER));
        for (VirtualFilePointer virtualFilePointer : jarDirectories) {
            String url = virtualFilePointer.getUrl();
            Element jarDirElement = new Element(JAR_DIRECTORY_ELEMENT);
            jarDirElement.setAttribute(URL_ATTR, url);
            jarDirElement.setAttribute(RECURSIVE_ATTR, Boolean.toString(recursive));
            element2.addContent(jarDirElement);
        }
    }

    @Override
    public void moveUp(@NotNull String url) {
        int index2;
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(8);
        }
        if ((index2 = this.indexOf(url)) <= 0) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, index2 - 1, index2);
    }

    @Override
    public void moveDown(@NotNull String url) {
        int index2;
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(9);
        }
        if ((index2 = this.indexOf(url)) < 0 || index2 + 1 >= this.myList.size()) {
            return;
        }
        this.dropCaches();
        ContainerUtil.swapElements(this.myList, index2, index2 + 1);
    }

    private int indexOf(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(10);
        }
        for (int i = 0; i < this.myList.size(); ++i) {
            VirtualFilePointer pointer = (VirtualFilePointer)this.myList.get(i);
            if (!url.equals(pointer.getUrl())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void killAll() {
        this.myList.clear();
        this.myJarDirectories.clear();
        this.myJarRecursiveDirectories.clear();
    }

    @Override
    public void add(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(11);
        }
        this.checkDisposed();
        this.dropCaches();
        this.myList.addIfAbsent(this.create(file2));
    }

    @Override
    public void add(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(12);
        }
        this.checkDisposed();
        this.dropCaches();
        this.myList.addIfAbsent(this.create(url));
    }

    @Override
    public void remove(@NotNull VirtualFilePointer pointer) {
        if (pointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(13);
        }
        this.checkDisposed();
        this.dropCaches();
        boolean result2 = this.myList.remove(pointer);
        LOG.assertTrue(result2);
    }

    @Override
    @NotNull
    public List<VirtualFilePointer> getList() {
        this.checkDisposed();
        List<VirtualFilePointer> list = Collections.unmodifiableList(this.myList);
        if (list == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Override
    public void addAll(@NotNull VirtualFilePointerContainer that) {
        if (that == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(15);
        }
        this.checkDisposed();
        this.dropCaches();
        this.addAll(Arrays.asList(that.getUrls()));
        List<VirtualFilePointer> jarDups = ContainerUtil.map(((VirtualFilePointerContainerImpl)that).myJarDirectories, this::duplicate);
        List<VirtualFilePointer> jarRecursiveDups = ContainerUtil.map(((VirtualFilePointerContainerImpl)that).myJarRecursiveDirectories, this::duplicate);
        this.myJarDirectories.addAllAbsent(jarDups);
        this.myJarRecursiveDirectories.addAllAbsent(jarRecursiveDups);
    }

    public void addAll(@NotNull Collection<String> urls) {
        if (urls == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(16);
        }
        this.myList.addAllAbsent(ContainerUtil.map(urls, url -> this.create((String)url)));
    }

    private void dropCaches() {
        this.myTimeStampOfCachedThings = -1L;
        this.myCachedThings = EMPTY;
    }

    @Override
    public String @NotNull [] getUrls() {
        if (this.myTimeStampOfCachedThings == -1L) {
            String[] stringArray = ContainerUtil.map2Array(this.myList, ArrayUtil.EMPTY_STRING_ARRAY, VirtualFilePointer::getUrl);
            if (stringArray == null) {
                VirtualFilePointerContainerImpl.$$$reportNull$$$0(17);
            }
            return stringArray;
        }
        String[] stringArray = (String[])this.getOrCache().first;
        if (stringArray == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> getOrCache() {
        this.checkDisposed();
        long timeStamp = this.myTimeStampOfCachedThings;
        Trinity<String[], VirtualFile[], VirtualFile[]> cached = this.myCachedThings;
        return timeStamp == this.myVirtualFilePointerManager.getModificationCount() ? cached : this.cacheThings();
    }

    @NotNull
    private Trinity<String[], VirtualFile[], VirtualFile[]> cacheThings() {
        Trinity<String[], VirtualFile[], VirtualFile[]> result2;
        if (this.isEmpty()) {
            result2 = EMPTY;
        } else {
            VirtualFile jarDirectory;
            final ArrayList<VirtualFile> cachedFiles = new ArrayList<VirtualFile>(this.myList.size());
            ArrayList<String> cachedUrls = new ArrayList<String>(this.myList.size());
            final ArrayList<VirtualFile> cachedDirectories = new ArrayList<VirtualFile>(this.myList.size() / 3);
            boolean allFilesAreDirs = true;
            for (VirtualFilePointer v : this.myList) {
                VirtualFile file2 = v.getFile();
                String url = v.getUrl();
                cachedUrls.add(url);
                if (file2 == null) continue;
                cachedFiles.add(file2);
                if (file2.isDirectory()) {
                    cachedDirectories.add(file2);
                    continue;
                }
                allFilesAreDirs = false;
            }
            for (VirtualFilePointer jarDirectoryPtr : this.myJarDirectories) {
                VirtualFile[] children2;
                jarDirectory = jarDirectoryPtr.getFile();
                if (jarDirectory == null) continue;
                cachedDirectories.remove(jarDirectory);
                for (VirtualFile file3 : children2 = jarDirectory.getChildren()) {
                    VirtualFile jarRoot;
                    if (file3.isDirectory() || FileTypeRegistry.getInstance().getFileTypeByFileName(file3.getNameSequence()) != ArchiveFileType.INSTANCE || (jarRoot = StandardFileSystems.jar().findFileByPath(file3.getPath() + "!/")) == null) continue;
                    cachedFiles.add(jarRoot);
                    cachedDirectories.add(jarRoot);
                }
            }
            for (VirtualFilePointer jarDirectoryPtr : this.myJarRecursiveDirectories) {
                jarDirectory = jarDirectoryPtr.getFile();
                if (jarDirectory == null) continue;
                cachedDirectories.remove(jarDirectory);
                VfsUtilCore.visitChildrenRecursively(jarDirectory, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                    @Override
                    public boolean visitFile(@NotNull VirtualFile file2) {
                        VirtualFile jarRoot;
                        if (file2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!file2.isDirectory() && FileTypeRegistry.getInstance().getFileTypeByFileName(file2.getNameSequence()) == ArchiveFileType.INSTANCE && (jarRoot = StandardFileSystems.jar().findFileByPath(file2.getPath() + "!/")) != null) {
                            cachedFiles.add(jarRoot);
                            cachedDirectories.add(jarRoot);
                            return false;
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "ksp/com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl$1", "visitFile"));
                    }
                });
            }
            String[] urlsArray = ArrayUtilRt.toStringArray(cachedUrls);
            VirtualFile[] directories2 = VfsUtilCore.toVirtualFileArray(cachedDirectories);
            VirtualFile[] files2 = allFilesAreDirs ? directories2 : VfsUtilCore.toVirtualFileArray(cachedFiles);
            result2 = Trinity.create(urlsArray, files2, directories2);
        }
        this.myCachedThings = result2;
        this.myTimeStampOfCachedThings = this.myVirtualFilePointerManager.getModificationCount();
        Trinity<String[], VirtualFile[], VirtualFile[]> trinity = result2;
        if (trinity == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(19);
        }
        return trinity;
    }

    @Override
    public boolean isEmpty() {
        return this.myList.isEmpty() && this.myJarDirectories.isEmpty() && this.myJarRecursiveDirectories.isEmpty();
    }

    @Override
    public VirtualFile @NotNull [] getFiles() {
        VirtualFile[] virtualFileArray = (VirtualFile[])this.getOrCache().second;
        if (virtualFileArray == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(20);
        }
        return virtualFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getDirectories() {
        VirtualFile[] virtualFileArray = (VirtualFile[])this.getOrCache().third;
        if (virtualFileArray == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(21);
        }
        return virtualFileArray;
    }

    @Override
    @Nullable
    public VirtualFilePointer findByUrl(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(22);
        }
        this.checkDisposed();
        for (VirtualFilePointer pointer : ContainerUtil.concat(new List[]{this.myList, this.myJarDirectories, this.myJarRecursiveDirectories})) {
            if (!url.equals(pointer.getUrl())) continue;
            return pointer;
        }
        return null;
    }

    @Override
    public void clear() {
        this.dropCaches();
        this.killAll();
    }

    @Override
    public int size() {
        return this.myList.size() + this.myJarDirectories.size() + this.myJarRecursiveDirectories.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualFilePointerContainerImpl)) {
            return false;
        }
        VirtualFilePointerContainerImpl impl = (VirtualFilePointerContainerImpl)o;
        return this.myList.equals(impl.myList) && this.myJarDirectories.equals(impl.myJarDirectories) && this.myJarRecursiveDirectories.equals(impl.myJarRecursiveDirectories);
    }

    public int hashCode() {
        return this.myList.hashCode();
    }

    @NotNull
    private VirtualFilePointer create(@NotNull VirtualFile file2) {
        if (file2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(23);
        }
        VirtualFilePointer virtualFilePointer = this.myVirtualFilePointerManager.create(file2, this.myParent, this.myListener);
        if (virtualFilePointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(24);
        }
        return virtualFilePointer;
    }

    @NotNull
    private VirtualFilePointer create(@NotNull String url) {
        if (url == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(25);
        }
        VirtualFilePointer virtualFilePointer = this.myVirtualFilePointerManager.create(url, this.myParent, this.myListener);
        if (virtualFilePointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(26);
        }
        return virtualFilePointer;
    }

    @NotNull
    private VirtualFilePointer duplicate(@NotNull VirtualFilePointer virtualFilePointer) {
        if (virtualFilePointer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(27);
        }
        VirtualFilePointer virtualFilePointer2 = this.myVirtualFilePointerManager.duplicate(virtualFilePointer, this.myParent, this.myListener);
        if (virtualFilePointer2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(28);
        }
        return virtualFilePointer2;
    }

    @NotNull
    @NonNls
    public String toString() {
        String string2 = "VFPContainer: " + this.myList + (this.myJarDirectories.isEmpty() ? "" : ", jars: " + this.myJarDirectories) + (this.myJarRecursiveDirectories.isEmpty() ? "" : ", jars(recursively): " + this.myJarRecursiveDirectories);
        if (string2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(29);
        }
        return string2;
    }

    @Override
    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent2) {
        if (parent2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(30);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.clone(parent2, null);
        if (virtualFilePointerContainer == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(31);
        }
        return virtualFilePointerContainer;
    }

    @Override
    @NotNull
    public VirtualFilePointerContainer clone(@NotNull Disposable parent2, @Nullable VirtualFilePointerListener listener2) {
        if (parent2 == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(32);
        }
        this.checkDisposed();
        VirtualFilePointerContainerImpl clone = (VirtualFilePointerContainerImpl)this.myVirtualFilePointerManager.createContainer(parent2, listener2);
        List<VirtualFilePointer> toAdd = ContainerUtil.map(this.myList, p -> clone.create(p.getUrl()));
        clone.myList.addAll(toAdd);
        clone.addAllJarDirectories(ContainerUtil.map(this.myJarDirectories, VirtualFilePointer::getUrl), false);
        clone.addAllJarDirectories(ContainerUtil.map(this.myJarRecursiveDirectories, VirtualFilePointer::getUrl), true);
        VirtualFilePointerContainerImpl virtualFilePointerContainerImpl = clone;
        if (virtualFilePointerContainerImpl == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(33);
        }
        return virtualFilePointerContainerImpl;
    }

    @Override
    public void dispose() {
        this.checkDisposed();
        this.myDisposed = true;
        this.kill(null);
        this.clear();
    }

    private void checkDisposed() {
        if (this.myDisposed) {
            this.throwDisposalError("Already disposed:\n" + this.getStackTrace());
        }
    }

    @Override
    public void addJarDirectory(@NotNull String directoryUrl, boolean recursively) {
        if (directoryUrl == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(34);
        }
        VirtualFilePointer pointer = this.myVirtualFilePointerManager.createDirectoryPointer(directoryUrl, recursively, this.myParent, this.myListener);
        (recursively ? this.myJarRecursiveDirectories : this.myJarDirectories).addIfAbsent(pointer);
        this.myList.addIfAbsent(pointer);
        this.dropCaches();
    }

    public void addAllJarDirectories(@NotNull Collection<String> directoryUrls, boolean recursively) {
        if (directoryUrls == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(35);
        }
        if (directoryUrls.isEmpty()) {
            return;
        }
        List<VirtualFilePointer> pointers = ContainerUtil.map(directoryUrls, url -> this.myVirtualFilePointerManager.createDirectoryPointer((String)url, recursively, this.myParent, this.myListener));
        (recursively ? this.myJarRecursiveDirectories : this.myJarDirectories).addAllAbsent(pointers);
        this.myList.addAllAbsent(pointers);
        this.dropCaches();
    }

    @Override
    public boolean removeJarDirectory(@NotNull String directoryUrl) {
        if (directoryUrl == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(36);
        }
        this.dropCaches();
        Predicate<VirtualFilePointer> filter = ptr -> FileUtil.pathsEqual(ptr.getUrl(), directoryUrl);
        boolean removed0 = this.myList.removeIf(filter);
        boolean removed1 = this.myJarDirectories.removeIf(filter);
        boolean removed2 = this.myJarRecursiveDirectories.removeIf(filter);
        return removed0 || removed1 || removed2;
    }

    @Override
    @NotNull
    public List<Pair<String, Boolean>> getJarDirectories() {
        List<Pair> jars = ContainerUtil.map(this.myJarDirectories, ptr -> Pair.create(ptr.getUrl(), false));
        List<Pair> recJars = ContainerUtil.map(this.myJarRecursiveDirectories, ptr -> Pair.create(ptr.getUrl(), true));
        List<Pair<String, Boolean>> list = ContainerUtil.concat(jars, recJars);
        if (list == null) {
            VirtualFilePointerContainerImpl.$$$reportNull$$$0(37);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 37: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootChild";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childElementName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myJarDirectories";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = URL_ATTR;
                break;
            }
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFilePointer";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryUrl";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/vfs/impl/VirtualFilePointerContainerImpl";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getList";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "cacheThings";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectories";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "duplicate";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarDirectories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeJarDirs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveUp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moveDown";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 37: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findByUrl";
                break;
            }
            case 23: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "duplicate";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addJarDirectory";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addAllJarDirectories";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "removeJarDirectory";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 37: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

