/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.impl.base.references;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.psi.ContributedReferenceHost;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiReference;
import ksp.com.intellij.psi.PsiReferenceService;
import ksp.com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import ksp.com.intellij.psi.util.CachedValueProvider;
import ksp.com.intellij.psi.util.CachedValuesManager;
import ksp.com.intellij.psi.util.PsiModificationTracker;
import ksp.com.intellij.util.containers.ConcurrentFactoryMap;
import ksp.com.intellij.util.containers.MultiMap;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.idea.references.KotlinPsiReferenceProvider;
import ksp.org.jetbrains.kotlin.idea.references.KotlinPsiReferenceRegistrar;
import ksp.org.jetbrains.kotlin.idea.references.KotlinReferenceProviderContributor;
import ksp.org.jetbrains.kotlin.psi.KotlinReferenceProvidersService;
import ksp.org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0014J\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0016\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\"\u0010\b\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u001c\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/impl/base/references/HLApiReferenceProviderService;", "Lksp/org/jetbrains/kotlin/psi/KotlinReferenceProvidersService;", "project", "Lksp/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "originalProvidersBinding", "Lksp/com/intellij/util/containers/MultiMap;", "Ljava/lang/Class;", "Lksp/com/intellij/psi/PsiElement;", "Lksp/org/jetbrains/kotlin/idea/references/KotlinPsiReferenceProvider;", "providersBindingCache", "", "", "doGetKotlinReferencesFromProviders", "", "Lksp/com/intellij/psi/PsiReference;", "context", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "getReferences", "psiElement", "analysis-api-impl-base"})
@SourceDebugExtension(value={"SMAP\nHLApiReferenceProviderService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HLApiReferenceProviderService.kt\norg/jetbrains/kotlin/analysis/api/impl/base/references/HLApiReferenceProviderService\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,74:1\n37#2:75\n36#2,3:76\n*S KotlinDebug\n*F\n+ 1 HLApiReferenceProviderService.kt\norg/jetbrains/kotlin/analysis/api/impl/base/references/HLApiReferenceProviderService\n*L\n58#1:75\n58#1:76,3\n*E\n"})
public final class HLApiReferenceProviderService
extends KotlinReferenceProvidersService {
    @NotNull
    private final Project project;
    @NotNull
    private final MultiMap<Class<? extends PsiElement>, KotlinPsiReferenceProvider> originalProvidersBinding;
    @NotNull
    private final Map<Class<? extends PsiElement>, List<KotlinPsiReferenceProvider>> providersBindingCache;

    public HLApiReferenceProviderService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        KotlinPsiReferenceRegistrar registrar2 = new KotlinPsiReferenceRegistrar();
        KotlinReferenceProviderContributor.Companion.getInstance(this.project).registerReferenceProviders(registrar2);
        this.originalProvidersBinding = registrar2.getProviders();
        ConcurrentMap<Object, List> concurrentMap = ConcurrentFactoryMap.createMap(arg_0 -> HLApiReferenceProviderService._init_$lambda$1(arg_0 -> HLApiReferenceProviderService._init_$lambda$0(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(concurrentMap, (String)"createMap(...)");
        this.providersBindingCache = concurrentMap;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    private final PsiReference[] doGetKotlinReferencesFromProviders(PsiElement context2) {
        List<KotlinPsiReferenceProvider> providers = this.providersBindingCache.get(context2.getClass());
        Collection collection = providers;
        if (collection == null || collection.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        SmartList result2 = new SmartList();
        for (KotlinPsiReferenceProvider provider2 : providers) {
            CollectionsKt.addAll((Collection)result2, (Object[])provider2.getReferencesByElement(context2));
        }
        if (result2.isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Collection $this$toTypedArray$iv = result2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    @Override
    @NotNull
    public PsiReference[] getReferences(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (psiElement instanceof ContributedReferenceHost) {
            PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders(psiElement, PsiReferenceService.Hints.NO_HINTS);
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferencesFromProviders(...)");
            return psiReferenceArray;
        }
        Object t2 = CachedValuesManager.getCachedValue(psiElement, () -> HLApiReferenceProviderService.getReferences$lambda$2(this, psiElement));
        Intrinsics.checkNotNullExpressionValue(t2, (String)"getCachedValue(...)");
        return (PsiReference[])t2;
    }

    private static final List _init_$lambda$0(HLApiReferenceProviderService this$0, Class klass) {
        SmartList<KotlinPsiReferenceProvider> result2 = new SmartList<KotlinPsiReferenceProvider>();
        for (Class<? extends PsiElement> bindingClass : this$0.originalProvidersBinding.keySet()) {
            if (!bindingClass.isAssignableFrom(klass)) continue;
            result2.addAll(this$0.originalProvidersBinding.get(bindingClass));
        }
        return result2;
    }

    private static final List _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final CachedValueProvider.Result getReferences$lambda$2(HLApiReferenceProviderService this$0, PsiElement $psiElement) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create(this$0.doGetKotlinReferencesFromProviders($psiElement), objectArray);
    }
}

