/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree.java;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementFactory;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiIfStatement;
import ksp.com.intellij.psi.PsiJavaToken;
import ksp.com.intellij.psi.PsiKeyword;
import ksp.com.intellij.psi.PsiPatternVariable;
import ksp.com.intellij.psi.PsiStatement;
import ksp.com.intellij.psi.ResolveState;
import ksp.com.intellij.psi.controlFlow.AnalysisCanceledException;
import ksp.com.intellij.psi.controlFlow.ControlFlow;
import ksp.com.intellij.psi.controlFlow.ControlFlowFactory;
import ksp.com.intellij.psi.controlFlow.ControlFlowOptions;
import ksp.com.intellij.psi.controlFlow.ControlFlowUtil;
import ksp.com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.psi.impl.source.Constants;
import ksp.com.intellij.psi.impl.source.tree.ChildRole;
import ksp.com.intellij.psi.impl.source.tree.CompositePsiElement;
import ksp.com.intellij.psi.impl.source.tree.ElementType;
import ksp.com.intellij.psi.impl.source.tree.TreeElement;
import ksp.com.intellij.psi.scope.ElementClassHint;
import ksp.com.intellij.psi.scope.NameHint;
import ksp.com.intellij.psi.scope.PatternResolveState;
import ksp.com.intellij.psi.scope.PsiScopeProcessor;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.util.IncorrectOperationException;
import ksp.org.jetbrains.annotations.NotNull;

public class PsiIfStatementImpl
extends CompositePsiElement
implements PsiIfStatement,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiIfStatementImpl.class);

    public PsiIfStatementImpl() {
        super(IF_STATEMENT);
    }

    @Override
    public PsiExpression getCondition() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(32);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        ASTNode elseKeyword;
        if (child == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(0);
        }
        if (child == this.getThenBranch()) {
            this.replaceChildInternal(child, (TreeElement)((Object)JavaPsiFacade.getElementFactory(this.getProject()).createStatementFromText("{}", null)));
            return;
        }
        if (child == this.getElseBranch() && (elseKeyword = this.findChildByRole(31)) != null) {
            super.deleteChildInternal(elseKeyword);
        }
        super.deleteChildInternal(child);
    }

    @Override
    public PsiStatement getThenBranch() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(33);
    }

    @Override
    public PsiStatement getElseBranch() {
        return (PsiStatement)this.findChildByRoleAsPsiElement(34);
    }

    @Override
    public PsiJavaToken getLParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(24);
    }

    @Override
    public PsiJavaToken getRParenth() {
        return (PsiJavaToken)this.findChildByRoleAsPsiElement(25);
    }

    @Override
    public PsiKeyword getElseElement() {
        return (PsiKeyword)this.findChildByRoleAsPsiElement(31);
    }

    @Override
    public void setElseBranch(@NotNull PsiStatement statement) throws IncorrectOperationException {
        PsiKeyword elseElement;
        PsiStatement elseBranch;
        if (statement == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(1);
        }
        if ((elseBranch = this.getElseBranch()) != null) {
            elseBranch.delete();
        }
        if ((elseElement = this.getElseElement()) != null) {
            elseElement.delete();
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getProject());
        PsiIfStatement ifStatement = (PsiIfStatement)elementFactory.createStatementFromText("if (true) {} else {}", this);
        ifStatement.getElseBranch().replace(statement);
        this.addRange(ifStatement.getElseElement(), ifStatement.getLastChild());
    }

    @Override
    public void setThenBranch(@NotNull PsiStatement statement) throws IncorrectOperationException {
        PsiStatement thenBranch;
        if (statement == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(2);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(this.getProject());
        ASTNode keyword = this.findChildByRole(30);
        LOG.assertTrue(keyword != null);
        PsiIfStatement ifStatementPattern = (PsiIfStatement)elementFactory.createStatementFromText("if (){}", this);
        if (this.getLParenth() == null) {
            this.addAfter(ifStatementPattern.getLParenth(), keyword.getPsi());
        }
        if (this.getRParenth() == null) {
            PsiElement anchor = this.getCondition() == null ? this.getLParenth() : this.getCondition();
            this.addAfter(ifStatementPattern.getRParenth(), anchor);
        }
        if ((thenBranch = this.getThenBranch()) == null) {
            this.addAfter(statement, this.getRParenth());
        } else {
            thenBranch.replace(statement);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 30: {
                return this.findChildByType(IF_KEYWORD);
            }
            case 24: {
                return this.findChildByType(LPARENTH);
            }
            case 32: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 25: {
                return this.findChildByType(RPARENTH);
            }
            case 33: {
                return PsiImplUtil.findStatementChild(this);
            }
            case 31: {
                return this.findChildByType(ELSE_KEYWORD);
            }
            case 34: 
        }
        ASTNode elseKeyword = this.findChildByRole(31);
        if (elseKeyword == null) {
            return null;
        }
        for (ASTNode child = elseKeyword.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (!(child.getPsi() instanceof PsiStatement)) continue;
            return child;
        }
        return null;
    }

    @Override
    public int getChildRole(@NotNull ASTNode child) {
        if (child == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == IF_KEYWORD) {
            return 30;
        }
        if (i == ELSE_KEYWORD) {
            return 31;
        }
        if (i == LPARENTH) {
            return 24;
        }
        if (i == RPARENTH) {
            return 25;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 32;
        }
        if (child.getPsi() instanceof PsiStatement) {
            if (this.findChildByRoleAsPsiElement(33) == child) {
                return 33;
            }
            return 34;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(4);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitIfStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        ElementClassHint elementClassHint;
        if (processor == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(5);
        }
        if (state == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(6);
        }
        if (place == null) {
            PsiIfStatementImpl.$$$reportNull$$$0(7);
        }
        if ((elementClassHint = processor.getHint(ElementClassHint.KEY)) != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        PsiExpression condition = this.getCondition();
        if (condition != null) {
            PsiStatement thenBranch = this.getThenBranch();
            PsiStatement elseBranch = this.getElseBranch();
            if (lastParent == null) {
                if (state.get(PatternResolveState.KEY) == PatternResolveState.WHEN_NONE) {
                    return true;
                }
                PsiScopeProcessor conditionProcessor = state.get(PatternResolveState.KEY) == PatternResolveState.WHEN_BOTH ? processor : (element2, s2) -> {
                    ControlFlow flow;
                    LOG.assertTrue(element2 instanceof PsiPatternVariable);
                    NameHint hint = processor.getHint(NameHint.KEY);
                    if (hint != null && !((PsiPatternVariable)element2).getName().equals(hint.getName(s2))) {
                        return true;
                    }
                    try {
                        flow = ControlFlowFactory.getControlFlow(this, new LocalsControlFlowPolicy(this), ControlFlowOptions.NO_CONST_EVALUATE);
                    }
                    catch (AnalysisCanceledException e) {
                        return true;
                    }
                    boolean thenCompletesNormally = PsiIfStatementImpl.canCompleteNormally(thenBranch, flow);
                    boolean elseCompletesNormally = PsiIfStatementImpl.canCompleteNormally(elseBranch, flow);
                    if (thenCompletesNormally == elseCompletesNormally || PatternResolveState.fromBoolean(thenCompletesNormally) != PatternResolveState.stateAtParent((PsiPatternVariable)element2, condition)) {
                        return true;
                    }
                    return processor.execute(element2, s2);
                };
                return condition.processDeclarations(conditionProcessor, PatternResolveState.WHEN_BOTH.putInto(state), null, place);
            }
            if (lastParent == thenBranch) {
                return condition.processDeclarations(processor, PatternResolveState.WHEN_TRUE.putInto(state), null, place);
            }
            if (lastParent == elseBranch) {
                return condition.processDeclarations(processor, PatternResolveState.WHEN_FALSE.putInto(state), null, place);
            }
        }
        return true;
    }

    private static boolean canCompleteNormally(PsiStatement branch, ControlFlow flow) {
        if (branch == null) {
            return true;
        }
        int startOffset = flow.getStartOffset(branch);
        int endOffset = flow.getEndOffset(branch);
        return startOffset != -1 && endOffset != -1 && ControlFlowUtil.canCompleteNormally(flow, startOffset, endOffset);
    }

    @Override
    public String toString() {
        return "PsiIfStatement";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/java/PsiIfStatementImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteChildInternal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setElseBranch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setThenBranch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getChildRole";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

