/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.wasm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.wasm.FirWasmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"checkWasmInteropSignature", "", "declaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "isTypeSupportedInWasmInterop", "", "unexpandedType", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "isInFunctionReturnPosition", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "checkers.wasm"})
public final class FirWasmImportAnnotationCheckerKt {
    public static final void checkWasmInteropSignature(@NotNull FirFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirValueParameter parameter2 : declaration2.getValueParameters()) {
            ConeKotlinType type2 = FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef());
            if (parameter2.getDefaultValue() != null) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getSource(), FirWasmErrors.INSTANCE.getWASM_IMPORT_EXPORT_PARAMETER_DEFAULT_VALUE(), (DiagnosticContext)context2, null, 8, null);
            }
            if (parameter2.isVararg()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getSource(), FirWasmErrors.INSTANCE.getWASM_IMPORT_EXPORT_VARARG_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
            }
            if (FirWasmImportAnnotationCheckerKt.isTypeSupportedInWasmInterop(type2, false, context2.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)parameter2.getSource(), FirWasmErrors.INSTANCE.getWASM_IMPORT_EXPORT_UNSUPPORTED_PARAMETER_TYPE(), (Object)type2, (DiagnosticContext)context2, null, 16, null);
        }
        ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef());
        if (!FirWasmImportAnnotationCheckerKt.isTypeSupportedInWasmInterop(returnType2, true, context2.getSession())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration2.getSource(), FirWasmErrors.INSTANCE.getWASM_IMPORT_EXPORT_UNSUPPORTED_RETURN_TYPE(), (Object)returnType2, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private static final boolean isTypeSupportedInWasmInterop(ConeKotlinType unexpandedType, boolean isInFunctionReturnPosition, FirSession session) {
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType$default(unexpandedType, session, null, 2, null);
        if (ConeBuiltinTypeUtilsKt.isUnit(type2)) {
            return isInFunctionReturnPosition;
        }
        return ConeBuiltinTypeUtilsKt.isPrimitive(type2) && !ConeBuiltinTypeUtilsKt.isChar(type2) || ConeBuiltinTypeUtilsKt.isUnsignedType(type2);
    }
}

