/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import ksp.org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.FirAbstractImportingScopeKt;
import ksp.org.jetbrains.kotlin.fir.scopes.impl.ImportedFromObjectOrStaticData;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a8\u0010\b\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a(\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0010"}, d2={"checkFieldAccess", "", "expression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClashWithInvisibleProperty", "fieldSymbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirFieldSymbol;", "containingFile", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "dispatchReceiver", "Lksp/org/jetbrains/kotlin/fir/expressions/FirExpression;", "checkClashWithCompanionProperty", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirFieldAccessShadowedByInvisibleKotlinProperty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFieldAccessShadowedByInvisibleKotlinProperty.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirFieldAccessShadowedByInvisibleKotlinPropertyKt\n+ 2 declarationUtils.kt\norg/jetbrains/kotlin/fir/declarations/DeclarationUtilsKt\n*L\n1#1,108:1\n93#2:109\n84#2,11:110\n*S KotlinDebug\n*F\n+ 1 FirFieldAccessShadowedByInvisibleKotlinProperty.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirFieldAccessShadowedByInvisibleKotlinPropertyKt\n*L\n50#1:109\n50#1:110,11\n*E\n"})
public final class FirFieldAccessShadowedByInvisibleKotlinPropertyKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void checkFieldAccess(FirQualifiedAccessExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        if (context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperFieldAccessGenerationForFieldAccessShadowedByKotlinProperty)) {
            return;
        }
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(expression2);
        if (!(firCallableSymbol instanceof FirFieldSymbol)) return;
        FirFieldSymbol firFieldSymbol = (FirFieldSymbol)firCallableSymbol;
        if (firFieldSymbol == null) {
            return;
        }
        FirFieldSymbol fieldSymbol = firFieldSymbol;
        FirBasedSymbol $this$isJavaOrEnhancement$iv = fieldSymbol;
        boolean $i$f$isJavaOrEnhancement = false;
        FirDeclarationOrigin $this$isJavaOrEnhancement$iv$iv = $this$isJavaOrEnhancement$iv.getOrigin();
        boolean $i$f$isJavaOrEnhancement2 = false;
        if (!($this$isJavaOrEnhancement$iv$iv instanceof FirDeclarationOrigin.Java || Intrinsics.areEqual((Object)$this$isJavaOrEnhancement$iv$iv, (Object)FirDeclarationOrigin.Enhancement.INSTANCE))) {
            Object e = $this$isJavaOrEnhancement$iv.getFir();
            if (!(e instanceof FirCallableDeclaration)) return;
            FirCallableDeclaration firCallableDeclaration = (FirCallableDeclaration)e;
            Object object = firCallableDeclaration;
            if (firCallableDeclaration == null) return;
            ImportedFromObjectOrStaticData<FirCallableDeclaration> importedFromObjectOrStaticData = FirAbstractImportingScopeKt.getImportedFromObjectOrStaticData(object);
            object = importedFromObjectOrStaticData;
            if (importedFromObjectOrStaticData == null) return;
            Object d = ((ImportedFromObjectOrStaticData)object).getOriginal();
            object = d;
            if (d == null) return;
            if (!DeclarationUtilsKt.isJavaOrEnhancement((FirDeclaration)object)) return;
            boolean bl = true;
            if (!bl) return;
        }
        boolean bl = true;
        if (!bl) {
            return;
        }
        FirFile firFile = context2.getContainingFile();
        if (firFile == null) {
            return;
        }
        FirFile containingFile2 = firFile;
        FirExpression firExpression = expression2.getDispatchReceiver();
        if (firExpression == null) {
            return;
        }
        FirExpression dispatchReceiver = firExpression;
        FirFieldAccessShadowedByInvisibleKotlinPropertyKt.checkClashWithInvisibleProperty(context2, fieldSymbol, containingFile2, dispatchReceiver, reporter, expression2);
        FirFieldAccessShadowedByInvisibleKotlinPropertyKt.checkClashWithCompanionProperty(context2, fieldSymbol, reporter, expression2);
    }

    private static final void checkClashWithInvisibleProperty(CheckerContext context2, FirFieldSymbol fieldSymbol, FirFile containingFile2, FirExpression dispatchReceiver, DiagnosticReporter reporter, FirQualifiedAccessExpression expression2) {
        FirTypeScope firTypeScope = ScopeUtilsKt.scope(FirTypeUtilsKt.getResolvedType(dispatchReceiver), context2.getSession(), context2.getScopeSession(), CallableCopyTypeCalculator.Forced.INSTANCE, null);
        if (firTypeScope == null) {
            return;
        }
        FirTypeScope scope = firTypeScope;
        List<FirVariableSymbol<?>> properties = FirScopeKt.getProperties(scope, fieldSymbol.getName());
        for (FirVariableSymbol<?> property : properties) {
            boolean isVisible;
            if (!(property instanceof FirPropertySymbol) || !DeclarationAttributesKt.getHasBackingField((FirPropertySymbol)property) || (isVisible = FirVisibilityCheckerKt.isVisible(FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession()), (FirCallableSymbol)property, context2.getSession(), containingFile2, context2.getContainingDeclarations(), dispatchReceiver))) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getJAVA_FIELD_SHADOWED_BY_KOTLIN_PROPERTY(), property, (DiagnosticContext)context2, null, 16, null);
            break;
        }
    }

    private static final void checkClashWithCompanionProperty(CheckerContext context2, FirFieldSymbol fieldSymbol, DiagnosticReporter reporter, FirQualifiedAccessExpression expression2) {
        Object object = expression2.getDispatchReceiver();
        if (object == null || (object = FirTypeUtilsKt.getResolvedType((FirExpression)object)) == null || (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeKotlinType)object, context2.getSession())) == null) {
            return;
        }
        Object dispatchReceiverClass = object;
        FirRegularClassSymbol firRegularClassSymbol = ((FirRegularClassSymbol)dispatchReceiverClass).getCompanionObjectSymbol();
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol companionClass = firRegularClassSymbol;
        FirTypeScope companionScope = FirHelpersKt.unsubstitutedScope(companionClass, context2);
        List<FirVariableSymbol<?>> properties = FirScopeKt.getProperties(companionScope, fieldSymbol.getName());
        for (FirVariableSymbol<?> property : properties) {
            if (!(property instanceof FirPropertySymbol) || !DeclarationAttributesKt.getHasBackingField((FirPropertySymbol)property)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirJvmErrors.INSTANCE.getJAVA_FIELD_SHADOWED_BY_KOTLIN_PROPERTY(), property, (DiagnosticContext)context2, null, 16, null);
            break;
        }
    }

    public static final /* synthetic */ void access$checkFieldAccess(FirQualifiedAccessExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirFieldAccessShadowedByInvisibleKotlinPropertyKt.checkFieldAccess(expression2, context2, reporter);
    }
}

