/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.scopes;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorWithDeprecation;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.VariableDescriptor;
import ksp.org.jetbrains.kotlin.incremental.components.LookupLocation;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import ksp.org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import ksp.org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J2\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006$"}, d2={"Lksp/org/jetbrains/kotlin/resolve/scopes/CompositePrioritizedImportingScope;", "Lksp/org/jetbrains/kotlin/resolve/scopes/ImportingScope;", "primaryScope", "secondaryScope", "<init>", "(Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;)V", "parent", "getParent", "()Lorg/jetbrains/kotlin/resolve/scopes/ImportingScope;", "getContributedPackage", "Lksp/org/jetbrains/kotlin/descriptors/PackageViewDescriptor;", "name", "Lksp/org/jetbrains/kotlin/name/Name;", "getContributedDescriptors", "", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "kindFilter", "Lksp/org/jetbrains/kotlin/resolve/scopes/DescriptorKindFilter;", "nameFilter", "Lkotlin/Function1;", "", "changeNamesForAliased", "computeImportedNames", "", "printStructure", "", "p", "Lksp/org/jetbrains/kotlin/utils/Printer;", "getContributedClassifier", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "location", "Lksp/org/jetbrains/kotlin/incremental/components/LookupLocation;", "getContributedVariables", "Lksp/org/jetbrains/kotlin/descriptors/VariableDescriptor;", "getContributedFunctions", "Lksp/org/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resolution"})
public final class CompositePrioritizedImportingScope
implements ImportingScope {
    @NotNull
    private final ImportingScope primaryScope;
    @NotNull
    private final ImportingScope secondaryScope;

    public CompositePrioritizedImportingScope(@NotNull ImportingScope primaryScope, @NotNull ImportingScope secondaryScope) {
        Intrinsics.checkNotNullParameter((Object)primaryScope, (String)"primaryScope");
        Intrinsics.checkNotNullParameter((Object)secondaryScope, (String)"secondaryScope");
        this.primaryScope = primaryScope;
        this.secondaryScope = secondaryScope;
    }

    @Override
    @Nullable
    public ImportingScope getParent() {
        ImportingScope importingScope = this.primaryScope.getParent();
        if (importingScope == null) {
            importingScope = this.secondaryScope.getParent();
        }
        return importingScope;
    }

    @Override
    @Nullable
    public PackageViewDescriptor getContributedPackage(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        PackageViewDescriptor packageViewDescriptor = this.primaryScope.getContributedPackage(name2);
        if (packageViewDescriptor == null) {
            packageViewDescriptor = this.secondaryScope.getContributedPackage(name2);
        }
        return packageViewDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getContributedDescriptors(@NotNull DescriptorKindFilter kindFilter, @NotNull Function1<? super Name, Boolean> nameFilter, boolean changeNamesForAliased) {
        Intrinsics.checkNotNullParameter((Object)kindFilter, (String)"kindFilter");
        Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
        return CollectionsKt.union((Iterable)this.primaryScope.getContributedDescriptors(kindFilter, nameFilter, changeNamesForAliased), (Iterable)this.secondaryScope.getContributedDescriptors(kindFilter, nameFilter, changeNamesForAliased));
    }

    @Override
    @Nullable
    public Set<Name> computeImportedNames() {
        Set set;
        block5: {
            Set secondaryNames;
            block4: {
                Set primaryNames = this.primaryScope.computeImportedNames();
                secondaryNames = this.secondaryScope.computeImportedNames();
                set = primaryNames;
                if (set == null) break block4;
                Iterable iterable = set;
                Set set2 = secondaryNames;
                if (set2 == null) {
                    set2 = SetsKt.emptySet();
                }
                if ((set = CollectionsKt.union((Iterable)iterable, (Iterable)set2)) != null) break block5;
            }
            set = secondaryNames;
        }
        return set;
    }

    @Override
    public void printStructure(@NotNull Printer p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Object[] objectArray = new Object[]{this.primaryScope.getClass().getSimpleName()};
        p.println(objectArray);
    }

    @Override
    @Nullable
    public ClassifierDescriptor getContributedClassifier(@NotNull Name name2, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        ClassifierDescriptor classifierDescriptor = this.primaryScope.getContributedClassifier(name2, location2);
        if (classifierDescriptor == null) {
            classifierDescriptor = this.secondaryScope.getContributedClassifier(name2, location2);
        }
        return classifierDescriptor;
    }

    @NotNull
    public Collection<VariableDescriptor> getContributedVariables(@NotNull Name name2, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return CollectionsKt.union((Iterable)this.primaryScope.getContributedVariables(name2, location2), (Iterable)this.secondaryScope.getContributedVariables(name2, location2));
    }

    @NotNull
    public Collection<FunctionDescriptor> getContributedFunctions(@NotNull Name name2, @NotNull LookupLocation location2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return CollectionsKt.union((Iterable)this.primaryScope.getContributedFunctions(name2, location2), (Iterable)this.secondaryScope.getContributedFunctions(name2, location2));
    }

    @Override
    @Nullable
    public DescriptorWithDeprecation<ClassifierDescriptor> getContributedClassifierIncludeDeprecated(@NotNull Name name2, @NotNull LookupLocation location2) {
        return ImportingScope.DefaultImpls.getContributedClassifierIncludeDeprecated(this, name2, location2);
    }

    @Override
    public boolean definitelyDoesNotContainName(@NotNull Name name2) {
        return ImportingScope.DefaultImpls.definitelyDoesNotContainName(this, name2);
    }

    @Override
    public void recordLookup(@NotNull Name name2, @NotNull LookupLocation location2) {
        ImportingScope.DefaultImpls.recordLookup(this, name2, location2);
    }
}

