/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.config.LanguageVersionSettings;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.Call;
import ksp.org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.psi.ValueArgument;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import ksp.org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallableReferenceCompatibilityChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class CallableReferenceCompatibilityChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        LanguageFeature typeInferenceForCallableReferencesFeature = LanguageFeature.TypeInferenceOnGenericsForCallableReferences;
        if (context2.getLanguageVersionSettings().supportsFeature(typeInferenceForCallableReferencesFeature)) {
            return;
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> map = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getValueArguments(...)");
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedArgument = iterator2.next().getValue();
            for (ValueArgument argument : resolvedArgument.getArguments()) {
                ResolvedCall<? extends CallableDescriptor> callableReferenceResolvedCall;
                KtCallableReferenceExpression argumentExpression;
                KtExpression ktExpression = argument.getArgumentExpression();
                if ((ktExpression instanceof KtCallableReferenceExpression ? (KtCallableReferenceExpression)ktExpression : null) == null) continue;
                argumentExpression = argumentExpression;
                KtElement ktElement = argumentExpression.getCallableReference();
                BindingContext bindingContext = context2.getTrace().getBindingContext();
                Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                if (CallUtilKt.getResolvedCall(ktElement, bindingContext) == null) continue;
                Call call2 = callableReferenceResolvedCall.getCall();
                Intrinsics.checkNotNullExpressionValue((Object)call2, (String)"getCall(...)");
                if (!CallUtilKt.isCallableReference(call2)) continue;
                List<TypeParameterDescriptor> list = callableReferenceResolvedCall.getCandidateDescriptor().getTypeParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getTypeParameters(...)");
                if (!(!((Collection)list).isEmpty())) continue;
                context2.getTrace().report(Errors.UNSUPPORTED_FEATURE.on(argumentExpression, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)typeInferenceForCallableReferencesFeature), (Object)context2.getLanguageVersionSettings())));
            }
        }
    }
}

