/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.decompiler.psi.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.decompiler.psi.text.DecompiledText;
import ksp.org.jetbrains.kotlin.analysis.decompiler.stub.ClsStubBuildingKt;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import ksp.org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassKind;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.MemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import ksp.org.jetbrains.kotlin.renderer.DescriptorRenderer;
import ksp.org.jetbrains.kotlin.renderer.DescriptorRendererModifier;
import ksp.org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import ksp.org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.constants.ConstantValue;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import ksp.org.jetbrains.kotlin.types.FlexibleTypesKt;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0007\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\t*\u00020\nH\u0002\u001a$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014\u001a&\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"DECOMPILED_CODE_COMMENT", "", "DECOMPILED_COMMENT_FOR_PARAMETER", "FLEXIBLE_TYPE_COMMENT", "DECOMPILED_CONTRACT_STUB", "defaultDecompilerRendererOptions", "", "Lksp/org/jetbrains/kotlin/renderer/DescriptorRendererOptions;", "mustNotBeWrittenToDecompiledText", "", "Lksp/org/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "syntheticMemberMustNotBeWrittenToDecompiledText", "buildDecompiledText", "Lksp/org/jetbrains/kotlin/analysis/decompiler/psi/text/DecompiledText;", "packageFqName", "Lksp/org/jetbrains/kotlin/name/FqName;", "descriptors", "", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptorRenderer", "Lksp/org/jetbrains/kotlin/renderer/DescriptorRenderer;", "buildDecompiledTextImpl", "decompiler-to-psi"})
@SourceDebugExtension(value={"SMAP\nbuildDecompiledText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 buildDecompiledText.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,227:1\n3193#2,10:228\n*S KotlinDebug\n*F\n+ 1 buildDecompiledText.kt\norg/jetbrains/kotlin/analysis/decompiler/psi/text/BuildDecompiledTextKt\n*L\n183#1:228,10\n*E\n"})
public final class BuildDecompiledTextKt {
    @NotNull
    private static final String DECOMPILED_CODE_COMMENT = "/* compiled code */";
    @NotNull
    private static final String DECOMPILED_COMMENT_FOR_PARAMETER = "/* = compiled code */";
    @NotNull
    private static final String FLEXIBLE_TYPE_COMMENT = "/* platform type */";
    @NotNull
    private static final String DECOMPILED_CONTRACT_STUB = "contract { /* compiled contract */ }";

    public static final void defaultDecompilerRendererOptions(@NotNull DescriptorRendererOptions $this$defaultDecompilerRendererOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$defaultDecompilerRendererOptions, (String)"<this>");
        $this$defaultDecompilerRendererOptions.setWithDefinedIn(false);
        $this$defaultDecompilerRendererOptions.setClassWithPrimaryConstructor(true);
        $this$defaultDecompilerRendererOptions.setSecondaryConstructorsAsPrimary(false);
        $this$defaultDecompilerRendererOptions.setModifiers(DescriptorRendererModifier.ALL);
        $this$defaultDecompilerRendererOptions.setExcludedTypeAnnotationClasses(SetsKt.emptySet());
        $this$defaultDecompilerRendererOptions.setAlwaysRenderModifiers(true);
        $this$defaultDecompilerRendererOptions.setParameterNamesInFunctionalTypes(false);
        $this$defaultDecompilerRendererOptions.setDefaultParameterValueRenderer((Function1<? super ValueParameterDescriptor, String>)((Function1)BuildDecompiledTextKt::defaultDecompilerRendererOptions$lambda$0));
        $this$defaultDecompilerRendererOptions.setIncludePropertyConstant(true);
        $this$defaultDecompilerRendererOptions.setPropertyConstantRenderer(BuildDecompiledTextKt::defaultDecompilerRendererOptions$lambda$1);
    }

    public static final boolean mustNotBeWrittenToDecompiledText(@NotNull CallableMemberDescriptor $this$mustNotBeWrittenToDecompiledText) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$mustNotBeWrittenToDecompiledText, (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$mustNotBeWrittenToDecompiledText.getKind().ordinal()]) {
            case 1: 
            case 2: {
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            case 4: {
                bl = BuildDecompiledTextKt.syntheticMemberMustNotBeWrittenToDecompiledText($this$mustNotBeWrittenToDecompiledText);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private static final boolean syntheticMemberMustNotBeWrittenToDecompiledText(CallableMemberDescriptor $this$syntheticMemberMustNotBeWrittenToDecompiledText) {
        boolean bl;
        DeclarationDescriptor declarationDescriptor = $this$syntheticMemberMustNotBeWrittenToDecompiledText.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClass = classDescriptor;
        if (containingClass.getKind() == ClassKind.ENUM_CLASS) {
            Object[] objectArray = new Name[]{StandardNames.ENUM_VALUES, StandardNames.ENUM_ENTRIES, StandardNames.ENUM_VALUE_OF};
            bl = ArraysKt.contains((Object[])objectArray, (Object)$this$syntheticMemberMustNotBeWrittenToDecompiledText.getName());
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final DecompiledText buildDecompiledText(@NotNull FqName packageFqName, @NotNull List<? extends DeclarationDescriptor> descriptors, @NotNull DescriptorRenderer descriptorRenderer) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)descriptorRenderer, (String)"descriptorRenderer");
        return BuildDecompiledTextKt.buildDecompiledTextImpl(packageFqName, descriptors, descriptorRenderer.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)BuildDecompiledTextKt::buildDecompiledText$lambda$2)));
    }

    private static final DecompiledText buildDecompiledTextImpl(FqName packageFqName, List<? extends DeclarationDescriptor> descriptors, DescriptorRenderer descriptorRenderer) {
        StringBuilder builder2 = new StringBuilder();
        BuildDecompiledTextKt.buildDecompiledTextImpl$appendDecompiledTextAndPackageName(builder2, packageFqName);
        for (DeclarationDescriptor declarationDescriptor : descriptors) {
            BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$default(builder2, descriptorRenderer, declarationDescriptor, "", null, 16, null);
            builder2.append("\n");
        }
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return new DecompiledText(string2);
    }

    private static final String defaultDecompilerRendererOptions$lambda$0(ValueParameterDescriptor valueParameterDescriptor) {
        Intrinsics.checkNotNullParameter((Object)valueParameterDescriptor, (String)"<unused var>");
        return "COMPILED_CODE";
    }

    private static final String defaultDecompilerRendererOptions$lambda$1(ConstantValue constantValue) {
        Intrinsics.checkNotNullParameter((Object)constantValue, (String)"<unused var>");
        return "COMPILED_CODE";
    }

    private static final Unit buildDecompiledText$lambda$2(DescriptorRendererOptions $this$withOptions) {
        Intrinsics.checkNotNullParameter((Object)$this$withOptions, (String)"$this$withOptions");
        $this$withOptions.setRenderTypeExpansions(true);
        $this$withOptions.setRenderAbbreviatedTypeComments(true);
        return Unit.INSTANCE;
    }

    private static final void buildDecompiledTextImpl$appendDecompiledTextAndPackageName(StringBuilder builder2, FqName $packageFqName) {
        builder2.append("// IntelliJ API Decompiler stub source generated from a class file\n// Implementation of methods is not available");
        builder2.append("\n\n");
        if (!$packageFqName.isRoot()) {
            builder2.append("package ").append(RenderingUtilsKt.render($packageFqName)).append("\n\n");
        }
    }

    private static final void buildDecompiledTextImpl$appendDescriptor$newlineExceptFirst(Ref.BooleanRef firstPassed, StringBuilder builder2) {
        if (firstPassed.element) {
            builder2.append("\n");
        } else {
            firstPassed.element = true;
        }
    }

    private static final void buildDecompiledTextImpl$appendDescriptor(StringBuilder builder2, DescriptorRenderer $descriptorRenderer, DeclarationDescriptor descriptor2, String indent, Boolean lastEnumEntry) {
        StringBuilder stringBuilder;
        if (DescriptorUtils.isEnumEntry(descriptor2)) {
            for (AnnotationDescriptor annotation : descriptor2.getAnnotations()) {
                builder2.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, annotation, null, 2, null));
                builder2.append(" ");
            }
            String string2 = descriptor2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            builder2.append(KtPsiUtilKt.quoteIfNeeded(string2));
            Boolean bl = lastEnumEntry;
            Intrinsics.checkNotNull((Object)bl);
            stringBuilder = builder2.append(bl != false ? ";" : ",");
        } else {
            stringBuilder = builder2.append(StringsKt.replace$default((String)$descriptorRenderer.render(descriptor2), (String)"= ...", (String)DECOMPILED_COMMENT_FOR_PARAMETER, (boolean)false, (int)4, null));
        }
        if (descriptor2 instanceof CallableDescriptor) {
            KotlinType kotlinType = ((CallableDescriptor)descriptor2).getReturnType();
            Intrinsics.checkNotNull((Object)kotlinType);
            if (FlexibleTypesKt.isFlexible(kotlinType)) {
                builder2.append(" ").append(FLEXIBLE_TYPE_COMMENT);
            }
        }
        if (descriptor2 instanceof FunctionDescriptor || descriptor2 instanceof PropertyDescriptor) {
            if (((MemberDescriptor)descriptor2).getModality() != Modality.ABSTRACT) {
                StringBuilder stringBuilder2;
                if (descriptor2 instanceof FunctionDescriptor) {
                    StringBuilder $this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243 = builder2;
                    boolean bl = false;
                    $this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243.append(" { ");
                    AbstractContractProvider abstractContractProvider = (AbstractContractProvider)((FunctionDescriptor)descriptor2).getUserData(ContractProviderKey.INSTANCE);
                    if ((abstractContractProvider != null ? abstractContractProvider.getContractDescription() : null) != null) {
                        $this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243.append(DECOMPILED_CONTRACT_STUB).append("; ");
                    }
                    stringBuilder2 = $this$buildDecompiledTextImpl_u24appendDescriptor_u24lambda_u243.append(DECOMPILED_CODE_COMMENT).append(" }");
                } else {
                    stringBuilder2 = builder2.append(" ").append(DECOMPILED_CODE_COMMENT);
                }
            }
            if (descriptor2 instanceof PropertyDescriptor) {
                for (PropertyAccessorDescriptor accessor : ((PropertyDescriptor)descriptor2).getAccessors()) {
                    Object annotation2;
                    if (accessor.isDefault()) continue;
                    builder2.append('\n' + indent + "    ");
                    builder2.append(accessor.getVisibility().getInternalDisplayName()).append(" ");
                    builder2.append(CapitalizeDecapitalizeKt.toLowerCaseAsciiOnly(accessor.getModality().name())).append(" ");
                    if (accessor.isExternal()) {
                        builder2.append("external ");
                    }
                    for (Object annotation2 : accessor.getAnnotations()) {
                        builder2.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, (AnnotationDescriptor)annotation2, null, 2, null));
                        builder2.append(" ");
                    }
                    if (accessor instanceof PropertyGetterDescriptor) {
                        builder2.append("get");
                        continue;
                    }
                    if (!(accessor instanceof PropertySetterDescriptor)) continue;
                    builder2.append("set(");
                    ValueParameterDescriptor parameterDescriptor = ((PropertySetterDescriptor)accessor).getValueParameters().get(0);
                    annotation2 = parameterDescriptor.getAnnotations().iterator();
                    while (annotation2.hasNext()) {
                        AnnotationDescriptor annotation3 = (AnnotationDescriptor)annotation2.next();
                        builder2.append(DescriptorRenderer.renderAnnotation$default($descriptorRenderer, annotation3, null, 2, null));
                        builder2.append(" ");
                    }
                    Name name2 = parameterDescriptor.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
                    Name parameterName = ClsStubBuildingKt.computeParameterName(name2);
                    StringBuilder stringBuilder3 = builder2.append(parameterName.asString()).append(": ");
                    KotlinType kotlinType = parameterDescriptor.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                    stringBuilder3.append($descriptorRenderer.renderType(kotlinType));
                    builder2.append(")");
                    builder2.append(" {").append(DECOMPILED_CODE_COMMENT).append(" }");
                }
            }
        } else if (descriptor2 instanceof ClassDescriptor && !DescriptorUtils.isEnumEntry(descriptor2)) {
            builder2.append(" {\n");
            String subindent = indent + "    ";
            Ref.BooleanRef firstPassed = new Ref.BooleanRef();
            List allDescriptors = CollectionsKt.plus((Collection)DescriptorUtilsKt.getSecondaryConstructors((ClassDescriptor)descriptor2), (Iterable)ResolutionScope.DefaultImpls.getContributedDescriptors$default(((ClassDescriptor)descriptor2).getDefaultType().getMemberScope(), null, null, 3, null));
            Iterable $this$partition$iv = allDescriptors;
            boolean $i$f$partition = false;
            Object first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                DeclarationDescriptor p0 = (DeclarationDescriptor)element$iv;
                boolean bl = false;
                boolean $i$f$buildDecompiledTextImpl$appendDescriptor$stub_for_inlining = false;
                if (DescriptorUtils.isEnumEntry(p0)) {
                    ((ArrayList)first$iv).add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List enumEntries = (List)pair.component1();
            List members = (List)pair.component2();
            first$iv = ((Iterable)enumEntries).iterator();
            int n = 0;
            while (first$iv.hasNext()) {
                int index = n++;
                Object e = first$iv.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                DeclarationDescriptor enumEntry = (DeclarationDescriptor)e;
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor(builder2, $descriptorRenderer, enumEntry, subindent, index == CollectionsKt.getLastIndex((List)enumEntries));
            }
            ClassDescriptor companionObject = ((ClassDescriptor)descriptor2).getCompanionObjectDescriptor();
            if (companionObject != null) {
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$default(builder2, $descriptorRenderer, companionObject, subindent, null, 16, null);
            }
            for (DeclarationDescriptor member : members) {
                if (!Intrinsics.areEqual((Object)member.getContainingDeclaration(), (Object)descriptor2) || Intrinsics.areEqual((Object)member, (Object)companionObject) || member instanceof CallableMemberDescriptor && BuildDecompiledTextKt.mustNotBeWrittenToDecompiledText((CallableMemberDescriptor)member)) continue;
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$newlineExceptFirst(firstPassed, builder2);
                builder2.append(subindent);
                BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor$default(builder2, $descriptorRenderer, member, subindent, null, 16, null);
            }
            builder2.append(indent).append("}");
        }
        builder2.append("\n");
    }

    static /* synthetic */ void buildDecompiledTextImpl$appendDescriptor$default(StringBuilder stringBuilder, DescriptorRenderer descriptorRenderer, DeclarationDescriptor declarationDescriptor, String string2, Boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = null;
        }
        BuildDecompiledTextKt.buildDecompiledTextImpl$appendDescriptor(stringBuilder, descriptorRenderer, declarationDescriptor, string2, bl);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CallableMemberDescriptor.Kind.values().length];
            try {
                nArray[CallableMemberDescriptor.Kind.DECLARATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.DELEGATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.FAKE_OVERRIDE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CallableMemberDescriptor.Kind.SYNTHESIZED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

