/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.light;

import java.util.StringJoiner;
import ksp.com.intellij.lang.java.JavaLanguage;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiManager;
import ksp.com.intellij.psi.PsiReferenceParameterList;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeElement;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.psi.impl.light.LightElement;
import ksp.org.jetbrains.annotations.NotNull;

public class LightReferenceParameterList
extends LightElement
implements PsiReferenceParameterList {
    private final PsiTypeElement[] myTypeElements;
    private final String myText;

    public LightReferenceParameterList(PsiManager manager, PsiTypeElement[] referenceElements) {
        super(manager, JavaLanguage.INSTANCE);
        this.myTypeElements = referenceElements;
        this.myText = this.calculateText();
    }

    private String calculateText() {
        if (this.myTypeElements.length == 0) {
            return "";
        }
        StringJoiner buffer = new StringJoiner(",", "<", ">");
        for (PsiTypeElement type2 : this.myTypeElements) {
            buffer.add(type2.getText());
        }
        return buffer.toString();
    }

    @Override
    public String toString() {
        return "PsiReferenceParameterList";
    }

    @Override
    public String getText() {
        return this.myText;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            LightReferenceParameterList.$$$reportNull$$$0(0);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceParameterList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiElement copy() {
        PsiTypeElement[] elements = new PsiTypeElement[this.myTypeElements.length];
        for (int i = 0; i < this.myTypeElements.length; ++i) {
            PsiTypeElement typeElement = this.myTypeElements[i];
            elements[i] = (PsiTypeElement)typeElement.copy();
        }
        return new LightReferenceParameterList(this.myManager, elements);
    }

    @Override
    public PsiTypeElement @NotNull [] getTypeParameterElements() {
        if (this.myTypeElements == null) {
            LightReferenceParameterList.$$$reportNull$$$0(1);
        }
        return this.myTypeElements;
    }

    @Override
    public PsiType @NotNull [] getTypeArguments() {
        PsiType[] psiTypeArray = PsiImplUtil.typesByTypeElements(this.myTypeElements);
        if (psiTypeArray == null) {
            LightReferenceParameterList.$$$reportNull$$$0(2);
        }
        return psiTypeArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/light/LightReferenceParameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/light/LightReferenceParameterList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameterElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

