/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi;

import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public final class BasicLiteralUtil {
    private BasicLiteralUtil() {
    }

    public static int getTextBlockIndent(@NotNull PsiElement expression2) {
        String[] lines;
        if (expression2 == null) {
            BasicLiteralUtil.$$$reportNull$$$0(0);
        }
        if ((lines = BasicLiteralUtil.getTextBlockLines(expression2)) == null) {
            return -1;
        }
        return BasicLiteralUtil.getTextBlockIndent(lines);
    }

    public static String @Nullable [] getTextBlockLines(@NotNull PsiElement expression2) {
        if (expression2 == null) {
            BasicLiteralUtil.$$$reportNull$$$0(1);
        }
        String rawText = expression2.getText();
        return BasicLiteralUtil.getTextBlockLines(rawText);
    }

    public static String @Nullable [] getTextBlockLines(String rawText) {
        char c;
        if (rawText.length() < 7 || !rawText.endsWith("\"\"\"")) {
            return null;
        }
        int start = 3;
        while ((c = rawText.charAt(start++)) != '\n') {
            if (BasicLiteralUtil.isTextBlockWhiteSpace(c) && start != rawText.length()) continue;
            return null;
        }
        return rawText.substring(start, rawText.length() - 3).split("\n", -1);
    }

    public static boolean isTextBlockWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\f';
    }

    public static int getTextBlockIndent(String @NotNull [] lines) {
        if (lines == null) {
            BasicLiteralUtil.$$$reportNull$$$0(2);
        }
        return BasicLiteralUtil.getTextBlockIndent(lines, false, false);
    }

    public static int getTextBlockIndent(String @NotNull [] lines, boolean preserveContent, boolean ignoreLastLine) {
        if (lines == null) {
            BasicLiteralUtil.$$$reportNull$$$0(3);
        }
        int prefix = Integer.MAX_VALUE;
        for (int i = 0; i < lines.length && prefix != 0; ++i) {
            int indent;
            String line = lines[i];
            for (indent = 0; indent < line.length() && Character.isWhitespace(line.charAt(indent)); ++indent) {
            }
            if (indent == line.length() && (i < lines.length - 1 || ignoreLastLine)) {
                if (preserveContent) continue;
                lines[i] = "";
                continue;
            }
            if (indent >= prefix) continue;
            prefix = indent;
        }
        return prefix;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/psi/BasicLiteralUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextBlockIndent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextBlockLines";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

