/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.org.objectweb.asm.util;

import java.io.PrintWriter;
import ksp.org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import ksp.org.jetbrains.org.objectweb.asm.Attribute;
import ksp.org.jetbrains.org.objectweb.asm.ClassVisitor;
import ksp.org.jetbrains.org.objectweb.asm.FieldVisitor;
import ksp.org.jetbrains.org.objectweb.asm.MethodVisitor;
import ksp.org.jetbrains.org.objectweb.asm.ModuleVisitor;
import ksp.org.jetbrains.org.objectweb.asm.RecordComponentVisitor;
import ksp.org.jetbrains.org.objectweb.asm.TypePath;
import ksp.org.jetbrains.org.objectweb.asm.util.Printer;
import ksp.org.jetbrains.org.objectweb.asm.util.Textifier;
import ksp.org.jetbrains.org.objectweb.asm.util.TraceAnnotationVisitor;
import ksp.org.jetbrains.org.objectweb.asm.util.TraceFieldVisitor;
import ksp.org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;
import ksp.org.jetbrains.org.objectweb.asm.util.TraceModuleVisitor;
import ksp.org.jetbrains.org.objectweb.asm.util.TraceRecordComponentVisitor;

public final class TraceClassVisitor
extends ClassVisitor {
    private final PrintWriter printWriter;
    public final Printer p;

    public TraceClassVisitor(PrintWriter printWriter) {
        this(null, printWriter);
    }

    public TraceClassVisitor(ClassVisitor classVisitor2, PrintWriter printWriter) {
        this(classVisitor2, new Textifier(), printWriter);
    }

    public TraceClassVisitor(ClassVisitor classVisitor2, Printer printer, PrintWriter printWriter) {
        super(0x10A0000, classVisitor2);
        this.printWriter = printWriter;
        this.p = printer;
    }

    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
        this.p.visit(version, access, name2, signature, superName, interfaces);
        super.visit(version, access, name2, signature, superName, interfaces);
    }

    public void visitSource(String file2, String debug) {
        this.p.visitSource(file2, debug);
        super.visitSource(file2, debug);
    }

    public ModuleVisitor visitModule(String name2, int flags, String version) {
        Printer modulePrinter = this.p.visitModule(name2, flags, version);
        return new TraceModuleVisitor(super.visitModule(name2, flags, version), modulePrinter);
    }

    public void visitNestHost(String nestHost) {
        this.p.visitNestHost(nestHost);
        super.visitNestHost(nestHost);
    }

    public void visitOuterClass(String owner, String name2, String descriptor) {
        this.p.visitOuterClass(owner, name2, descriptor);
        super.visitOuterClass(owner, name2, descriptor);
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        Printer annotationPrinter = this.p.visitClassAnnotation(descriptor, visible);
        return new TraceAnnotationVisitor(super.visitAnnotation(descriptor, visible), annotationPrinter);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        Printer annotationPrinter = this.p.visitClassTypeAnnotation(typeRef, typePath, descriptor, visible);
        return new TraceAnnotationVisitor(super.visitTypeAnnotation(typeRef, typePath, descriptor, visible), annotationPrinter);
    }

    public void visitAttribute(Attribute attribute) {
        this.p.visitClassAttribute(attribute);
        super.visitAttribute(attribute);
    }

    public void visitNestMember(String nestMember) {
        this.p.visitNestMember(nestMember);
        super.visitNestMember(nestMember);
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        this.p.visitPermittedSubclass(permittedSubclass);
        super.visitPermittedSubclass(permittedSubclass);
    }

    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        this.p.visitInnerClass(name2, outerName, innerName, access);
        super.visitInnerClass(name2, outerName, innerName, access);
    }

    public RecordComponentVisitor visitRecordComponent(String name2, String descriptor, String signature) {
        Printer recordComponentPrinter = this.p.visitRecordComponent(name2, descriptor, signature);
        return new TraceRecordComponentVisitor(super.visitRecordComponent(name2, descriptor, signature), recordComponentPrinter);
    }

    public FieldVisitor visitField(int access, String name2, String descriptor, String signature, Object value2) {
        Printer fieldPrinter = this.p.visitField(access, name2, descriptor, signature, value2);
        return new TraceFieldVisitor(super.visitField(access, name2, descriptor, signature, value2), fieldPrinter);
    }

    public MethodVisitor visitMethod(int access, String name2, String descriptor, String signature, String[] exceptions) {
        Printer methodPrinter = this.p.visitMethod(access, name2, descriptor, signature, exceptions);
        return new TraceMethodVisitor(super.visitMethod(access, name2, descriptor, signature, exceptions), methodPrinter);
    }

    public void visitEnd() {
        this.p.visitClassEnd();
        if (this.printWriter != null) {
            this.p.print(this.printWriter);
            this.printWriter.flush();
        }
        super.visitEnd();
    }
}

