/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeUtils;
import ksp.org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a\f\u0010\u000b\u001a\u00020\u0007*\u00020\u0007H\u0002\u00a8\u0006\f"}, d2={"checkEnumsForCompatibility", "", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "reportOn", "Lksp/org/jetbrains/kotlin/psi/KtElement;", "typeA", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "typeB", "isIncompatibleEnums", "", "representativeTypeForTypeParameter", "frontend"})
public final class EnumCompatibilityCheckerKt {
    public static final void checkEnumsForCompatibility(@NotNull ResolutionContext<?> context2, @NotNull KtElement reportOn, @NotNull KotlinType typeA, @NotNull KotlinType typeB) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)typeA, (String)"typeA");
        Intrinsics.checkNotNullParameter((Object)typeB, (String)"typeB");
        if (EnumCompatibilityCheckerKt.isIncompatibleEnums(typeA, typeB)) {
            DiagnosticFactory2<KtElement, KotlinType, KotlinType> diagnostic = context2.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitComparisonOfIncompatibleEnums) ? Errors.INCOMPATIBLE_ENUM_COMPARISON_ERROR : Errors.INCOMPATIBLE_ENUM_COMPARISON;
            context2.trace.report(diagnostic.on((KtElement)((PsiElement)reportOn), typeA, typeB));
        }
    }

    private static final boolean isIncompatibleEnums(KotlinType typeA, KotlinType typeB) {
        if (!TypeUtilsKt.isEnum(typeA) && !TypeUtilsKt.isEnum(typeB)) {
            return false;
        }
        if (TypeUtils.isNullableType(typeA) && TypeUtils.isNullableType(typeB)) {
            return false;
        }
        if (TypeUtilsKt.isNothingOrNullableNothing(typeA) || TypeUtilsKt.isNothingOrNullableNothing(typeB)) {
            return false;
        }
        KotlinType representativeTypeA = EnumCompatibilityCheckerKt.representativeTypeForTypeParameter(typeA);
        KotlinType representativeTypeB = EnumCompatibilityCheckerKt.representativeTypeForTypeParameter(typeB);
        ClassifierDescriptor classifierDescriptor = representativeTypeA.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor = classifierDescriptor instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor classA = classDescriptor;
        ClassifierDescriptor classifierDescriptor2 = representativeTypeB.getConstructor().getDeclarationDescriptor();
        ClassDescriptor classDescriptor2 = classifierDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor2 : null;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor classB = classDescriptor2;
        return !DescriptorUtils.isSubclass(classA, classB) && !DescriptorUtils.isSubclass(classB, classA);
    }

    private static final KotlinType representativeTypeForTypeParameter(KotlinType $this$representativeTypeForTypeParameter) {
        ClassifierDescriptor descriptor = $this$representativeTypeForTypeParameter.getConstructor().getDeclarationDescriptor();
        return descriptor instanceof TypeParameterDescriptor ? TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor) : $this$representativeTypeForTypeParameter;
    }
}

