/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import ksp.org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.TypeConstructor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/checkers/EnumDeclaringClassDeprecationChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lksp/org/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lksp/com/intellij/psi/PsiElement;", "context", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nEnumDeclaringClassDeprecationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnumDeclaringClassDeprecationChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/EnumDeclaringClassDeprecationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,32:1\n2632#2,3:33\n*S KotlinDebug\n*F\n+ 1 EnumDeclaringClassDeprecationChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/EnumDeclaringClassDeprecationChecker\n*L\n28#1:33,3\n*E\n"})
public final class EnumDeclaringClassDeprecationChecker
implements CallChecker {
    @NotNull
    public static final EnumDeclaringClassDeprecationChecker INSTANCE = new EnumDeclaringClassDeprecationChecker();

    private EnumDeclaringClassDeprecationChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        Intrinsics.checkNotNullParameter(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Object obj = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, (String)"getResultingDescriptor(...)");
        Object resultingDescriptor = obj;
        if (!(resultingDescriptor instanceof PropertyDescriptor) || ((PropertyDescriptor)resultingDescriptor).getKind() != CallableMemberDescriptor.Kind.SYNTHESIZED) {
            return;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = ((PropertyDescriptor)resultingDescriptor).getExtensionReceiverParameter();
        ReceiverValue receiverValue = receiverParameterDescriptor != null ? receiverParameterDescriptor.getValue() : null;
        ExtensionReceiver extensionReceiver2 = receiverValue instanceof ExtensionReceiver ? (ExtensionReceiver)receiverValue : null;
        if (extensionReceiver2 == null) {
            return;
        }
        ExtensionReceiver extensionReceiver3 = extensionReceiver2;
        if (!Intrinsics.areEqual((Object)((PropertyDescriptor)resultingDescriptor).getName().asString(), (Object)"declaringClass")) {
            return;
        }
        TypeConstructor extensionReceiverConstructor = extensionReceiver3.getType().getConstructor();
        if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getClassId(extensionReceiverConstructor.getDeclarationDescriptor()), (Object)StandardClassIds.INSTANCE.getEnum())) {
            boolean bl;
            block8: {
                Collection<KotlinType> collection = extensionReceiverConstructor.getSupertypes();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getSupertypes(...)");
                Iterable $this$none$iv = collection;
                boolean $i$f$none = false;
                if (((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getClassId(it.getConstructor().getDeclarationDescriptor()), (Object)StandardClassIds.INSTANCE.getEnum())) continue;
                        bl = false;
                        break block8;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return;
            }
        }
        context2.getTrace().report(ErrorsJvm.ENUM_DECLARING_CLASS_DEPRECATED.on(context2.getLanguageVersionSettings(), reportOn));
    }
}

