/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve.jvm;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.psi.KtExpression;
import ksp.org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import ksp.org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import ksp.org.jetbrains.kotlin.resolve.jvm.JvmBindingContextSlices;
import ksp.org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionInfo;
import ksp.org.jetbrains.kotlin.resolve.jvm.RuntimeAssertionsDataFlowExtras;
import ksp.org.jetbrains.kotlin.types.KotlinType;
import ksp.org.jetbrains.kotlin.types.StubTypeForBuilderInference;
import ksp.org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/resolve/jvm/RuntimeAssertionsTypeChecker;", "Lksp/org/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "<init>", "()V", "checkType", "", "expression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lksp/org/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "c", "Lksp/org/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "frontend.java"})
public final class RuntimeAssertionsTypeChecker
implements AdditionalTypeChecker {
    @NotNull
    public static final RuntimeAssertionsTypeChecker INSTANCE = new RuntimeAssertionsTypeChecker();

    private RuntimeAssertionsTypeChecker() {
    }

    @Override
    public void checkType(@NotNull KtExpression expression2, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expressionType, (String)"expressionType");
        Intrinsics.checkNotNullParameter((Object)expressionTypeWithSmartCast, (String)"expressionTypeWithSmartCast");
        Intrinsics.checkNotNullParameter(c, (String)"c");
        if (TypeUtils.noExpectedType(c.expectedType) || c.expectedType instanceof StubTypeForBuilderInference) {
            return;
        }
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        RuntimeAssertionInfo assertionInfo = RuntimeAssertionInfo.Companion.create(kotlinType, expressionType, new RuntimeAssertionsDataFlowExtras(c, expressionType, expression2));
        if (assertionInfo != null) {
            c.trace.record(JvmBindingContextSlices.RUNTIME_ASSERTION_INFO, expression2, assertionInfo);
        }
    }
}

