/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.CallableDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import ksp.org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import ksp.org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import ksp.org.jetbrains.kotlin.diagnostics.Errors;
import ksp.org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import ksp.org.jetbrains.kotlin.resolve.BindingContext;
import ksp.org.jetbrains.kotlin.resolve.DescriptorUtils;
import ksp.org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import ksp.org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.ClassifierQualifier;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.PackageQualifier;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.QualifierKt;
import ksp.org.jetbrains.kotlin.resolve.scopes.receivers.TypeParameterQualifier;
import ksp.org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\"\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\t\u001a\u0004\u0018\u00010\u0001*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"resolveQualifierAsReceiverInExpression", "Lksp/org/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "qualifier", "Lksp/org/jetbrains/kotlin/resolve/scopes/receivers/Qualifier;", "selector", "context", "Lksp/org/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "resolveQualifierAsStandaloneExpression", "resolveQualifierReferenceTarget", "getCallableReceiverDescriptorRetainingTypeAliasReference", "Lksp/org/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "frontend"})
public final class QualifiedExpressionResolveUtilKt {
    @NotNull
    public static final DeclarationDescriptor resolveQualifierAsReceiverInExpression(@NotNull Qualifier qualifier2, @Nullable DeclarationDescriptor selector, @NotNull ExpressionTypingContext context2) {
        Intrinsics.checkNotNullParameter((Object)qualifier2, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DeclarationDescriptor referenceTarget = QualifiedExpressionResolveUtilKt.resolveQualifierReferenceTarget(qualifier2, selector, context2);
        if (referenceTarget instanceof TypeParameterDescriptor) {
            context2.trace.report(Errors.TYPE_PARAMETER_ON_LHS_OF_DOT.on((KtSimpleNameExpression)((PsiElement)qualifier2.getReferenceExpression()), (TypeParameterDescriptor)referenceTarget));
        }
        return referenceTarget;
    }

    @NotNull
    public static final DeclarationDescriptor resolveQualifierAsStandaloneExpression(@NotNull Qualifier qualifier2, @NotNull ExpressionTypingContext context2) {
        DeclarationDescriptor referenceTarget;
        Intrinsics.checkNotNullParameter((Object)qualifier2, (String)"qualifier");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        DeclarationDescriptor declarationDescriptor = referenceTarget = QualifiedExpressionResolveUtilKt.resolveQualifierReferenceTarget(qualifier2, null, context2);
        if (declarationDescriptor instanceof TypeAliasDescriptor) {
            ClassDescriptor classDescriptor = ((TypeAliasDescriptor)referenceTarget).getClassDescriptor();
            if (classDescriptor != null) {
                ClassDescriptor classDescriptor2 = classDescriptor;
                boolean bl = false;
                if (!classDescriptor2.getKind().isSingleton()) {
                    context2.trace.report(Errors.NO_COMPANION_OBJECT.on((KtSimpleNameExpression)((PsiElement)qualifier2.getReferenceExpression()), (ClassifierDescriptor)referenceTarget));
                }
            }
        } else if (declarationDescriptor instanceof TypeParameterDescriptor) {
            context2.trace.report(Errors.TYPE_PARAMETER_IS_NOT_AN_EXPRESSION.on((KtSimpleNameExpression)((PsiElement)qualifier2.getReferenceExpression()), (TypeParameterDescriptor)referenceTarget));
        } else if (declarationDescriptor instanceof ClassDescriptor) {
            if (!((ClassDescriptor)referenceTarget).getKind().isSingleton()) {
                context2.trace.report(Errors.NO_COMPANION_OBJECT.on((KtSimpleNameExpression)((PsiElement)qualifier2.getReferenceExpression()), (ClassifierDescriptor)referenceTarget));
            }
        } else if (declarationDescriptor instanceof PackageViewDescriptor) {
            context2.trace.report(Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND.on((KtSimpleNameExpression)((PsiElement)qualifier2.getReferenceExpression())));
        }
        return referenceTarget;
    }

    private static final DeclarationDescriptor resolveQualifierReferenceTarget(Qualifier qualifier2, DeclarationDescriptor selector, ExpressionTypingContext context2) {
        DeclarationDescriptor selectorContainer;
        DeclarationDescriptor declarationDescriptor;
        if (qualifier2 instanceof TypeParameterQualifier) {
            return ((TypeParameterQualifier)qualifier2).getDescriptor();
        }
        if (selector instanceof ConstructorDescriptor) {
            declarationDescriptor = ((ConstructorDescriptor)selector).getContainingDeclaration().getContainingDeclaration();
        } else {
            DeclarationDescriptor declarationDescriptor2 = selector;
            declarationDescriptor = selectorContainer = declarationDescriptor2 != null ? declarationDescriptor2.getContainingDeclaration() : null;
        }
        if (qualifier2 instanceof PackageQualifier && (selectorContainer instanceof PackageFragmentDescriptor || selectorContainer instanceof PackageViewDescriptor) && Intrinsics.areEqual((Object)DescriptorUtils.getFqName(((PackageQualifier)qualifier2).getDescriptor()), (Object)DescriptorUtils.getFqName(selectorContainer))) {
            return ((PackageQualifier)qualifier2).getDescriptor();
        }
        if (qualifier2 instanceof ClassifierQualifier) {
            ClassifierDescriptorWithTypeParameters classifier = ((ClassifierQualifier)qualifier2).getDescriptor();
            boolean selectorIsCallable = selector instanceof CallableDescriptor && (((CallableDescriptor)selector).getDispatchReceiverParameter() != null || ((CallableDescriptor)selector).getExtensionReceiverParameter() != null);
            DeclarationDescriptor receiverClassifierDescriptor = QualifiedExpressionResolveUtilKt.getCallableReceiverDescriptorRetainingTypeAliasReference(classifier);
            if (selectorIsCallable && receiverClassifierDescriptor != null) {
                ClassDescriptor classDescriptor = DescriptorUtilsKt.getClassValueTypeDescriptor(classifier);
                Intrinsics.checkNotNull((Object)classDescriptor);
                ClassDescriptor classValueTypeDescriptor = classDescriptor;
                context2.trace.record(BindingContext.REFERENCE_TARGET, qualifier2.getReferenceExpression(), receiverClassifierDescriptor);
                context2.trace.recordType(QualifierKt.getExpression(qualifier2), classValueTypeDescriptor.getDefaultType());
                if (DescriptorUtilsKt.getHasCompanionObject(classifier)) {
                    context2.trace.record(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, qualifier2.getReferenceExpression(), classifier);
                }
                return classValueTypeDescriptor;
            }
        }
        return qualifier2.getDescriptor();
    }

    private static final DeclarationDescriptor getCallableReceiverDescriptorRetainingTypeAliasReference(ClassifierDescriptor $this$getCallableReceiverDescriptorRetainingTypeAliasReference) {
        DeclarationDescriptor declarationDescriptor;
        ClassifierDescriptor classifierDescriptor = $this$getCallableReceiverDescriptorRetainingTypeAliasReference;
        if (classifierDescriptor instanceof ClassDescriptor) {
            declarationDescriptor = DescriptorUtilsKt.getClassValueDescriptor((ClassDescriptor)$this$getCallableReceiverDescriptorRetainingTypeAliasReference);
        } else if (classifierDescriptor instanceof TypeAliasDescriptor) {
            ClassDescriptor classDescriptor = ((TypeAliasDescriptor)$this$getCallableReceiverDescriptorRetainingTypeAliasReference).getClassDescriptor();
            declarationDescriptor = (classDescriptor != null ? DescriptorUtilsKt.getClassValueDescriptor(classDescriptor) : null) != null ? new FakeCallableDescriptorForTypeAliasObject((TypeAliasDescriptor)$this$getCallableReceiverDescriptorRetainingTypeAliasReference) : $this$getCallableReceiverDescriptorRetainingTypeAliasReference;
        } else {
            declarationDescriptor = null;
        }
        return declarationDescriptor;
    }
}

