/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.ir.overrides;

import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFile;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunctionWithLateBinding;
import ksp.org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrOverridableMember;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPackageFragmentsKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPropertyWithLateBinding;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.overrides.FakeOverrideBuilderStrategyKt;
import ksp.org.jetbrains.kotlin.ir.overrides.IrUnimplementedOverridesStrategy;
import ksp.org.jetbrains.kotlin.ir.symbols.impl.IrPropertySymbolImpl;
import ksp.org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001.B)\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000bJ\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J+\u0010 \u001a\u0002H!\"\u0004\b\u0000\u0010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H!0%H&\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000bH$J\u0018\u0010+\u001a\u00020\u00162\u0006\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020\u000bH$R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006/"}, d2={"Lksp/org/jetbrains/kotlin/ir/overrides/FakeOverrideBuilderStrategy;", "", "friendModules", "", "", "", "unimplementedOverridesStrategy", "Lksp/org/jetbrains/kotlin/ir/overrides/IrUnimplementedOverridesStrategy;", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/ir/overrides/IrUnimplementedOverridesStrategy;)V", "isGenericClashFromSameSupertypeAllowed", "", "()Z", "isOverrideOfPublishedApiFromOtherModuleDisallowed", "fakeOverrideMember", "Lksp/org/jetbrains/kotlin/ir/declarations/IrOverridableMember;", "superType", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "member", "clazz", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "postProcessGeneratedFakeOverride", "", "fakeOverride", "linkFakeOverride", "compatibilityMode", "isInFriendModules", "fromModule", "Lksp/org/jetbrains/kotlin/descriptors/ModuleDescriptor;", "toModule", "isVisibleForOverrideInClass", "original", "inFile", "R", "file", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "linkFunctionFakeOverride", "function", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunctionWithLateBinding;", "manglerCompatibleMode", "linkPropertyFakeOverride", "property", "Lksp/org/jetbrains/kotlin/ir/declarations/IrPropertyWithLateBinding;", "BindToPrivateSymbols", "ir.tree"})
public abstract class FakeOverrideBuilderStrategy {
    @NotNull
    private final Map<String, Collection<String>> friendModules;
    @NotNull
    private final IrUnimplementedOverridesStrategy unimplementedOverridesStrategy;
    private final boolean isGenericClashFromSameSupertypeAllowed;
    private final boolean isOverrideOfPublishedApiFromOtherModuleDisallowed;

    public FakeOverrideBuilderStrategy(@NotNull Map<String, ? extends Collection<String>> friendModules, @NotNull IrUnimplementedOverridesStrategy unimplementedOverridesStrategy) {
        Intrinsics.checkNotNullParameter(friendModules, (String)"friendModules");
        Intrinsics.checkNotNullParameter((Object)unimplementedOverridesStrategy, (String)"unimplementedOverridesStrategy");
        this.friendModules = friendModules;
        this.unimplementedOverridesStrategy = unimplementedOverridesStrategy;
    }

    public boolean isGenericClashFromSameSupertypeAllowed() {
        return this.isGenericClashFromSameSupertypeAllowed;
    }

    public boolean isOverrideOfPublishedApiFromOtherModuleDisallowed() {
        return this.isOverrideOfPublishedApiFromOtherModuleDisallowed;
    }

    @Nullable
    public final IrOverridableMember fakeOverrideMember(@NotNull IrType superType, @NotNull IrOverridableMember member, @NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)superType, (String)"superType");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        return this.isVisibleForOverrideInClass(member, clazz) ? FakeOverrideBuilderStrategyKt.buildFakeOverrideMember(superType, member, clazz, this.unimplementedOverridesStrategy) : null;
    }

    public final void postProcessGeneratedFakeOverride(@NotNull IrOverridableMember fakeOverride, @NotNull IrClass clazz) {
        Intrinsics.checkNotNullParameter((Object)fakeOverride, (String)"fakeOverride");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        this.unimplementedOverridesStrategy.postProcessGeneratedFakeOverride((IrOverridableDeclaration)fakeOverride, clazz);
    }

    public final void linkFakeOverride(@NotNull IrOverridableMember fakeOverride, boolean compatibilityMode) {
        Intrinsics.checkNotNullParameter((Object)fakeOverride, (String)"fakeOverride");
        IrOverridableMember irOverridableMember = fakeOverride;
        if (irOverridableMember instanceof IrFunctionWithLateBinding) {
            this.linkFunctionFakeOverride((IrFunctionWithLateBinding)fakeOverride, compatibilityMode);
        } else if (irOverridableMember instanceof IrPropertyWithLateBinding) {
            this.linkPropertyFakeOverride((IrPropertyWithLateBinding)fakeOverride, compatibilityMode);
        } else {
            throw new IllegalStateException(("Unexpected fake override: " + fakeOverride).toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInFriendModules(ModuleDescriptor fromModule, ModuleDescriptor toModule) {
        String string2 = fromModule.getName().asStringStripSpecialMarkers();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asStringStripSpecialMarkers(...)");
        String fromModuleName = string2;
        String string3 = toModule.getName().asStringStripSpecialMarkers();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"asStringStripSpecialMarkers(...)");
        String toModuleName = string3;
        if (Intrinsics.areEqual((Object)fromModuleName, (Object)toModuleName)) return true;
        Collection<String> collection = this.friendModules.get(fromModuleName);
        if (collection == null) return false;
        if (!collection.contains(toModuleName)) return false;
        return true;
    }

    private final boolean isVisibleForOverrideInClass(IrOverridableMember original, IrClass clazz) {
        boolean bl;
        if (DescriptorVisibilities.isPrivate(original.getVisibility())) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)original.getVisibility(), (Object)DescriptorVisibilities.INVISIBLE_FAKE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)original.getVisibility(), (Object)DescriptorVisibilities.INTERNAL)) {
            ModuleDescriptor thisModule = IrPackageFragmentsKt.getModuleDescriptor(IrUtilsKt.getPackageFragment(clazz));
            ModuleDescriptor memberModule = IrPackageFragmentsKt.getModuleDescriptor(IrUtilsKt.getPackageFragment(original));
            bl = Intrinsics.areEqual((Object)thisModule, (Object)memberModule) ? true : (this.isInFriendModules(thisModule, memberModule) ? true : !this.isOverrideOfPublishedApiFromOtherModuleDisallowed() && IrUtilsKt.hasAnnotation((IrAnnotationContainer)original, StandardClassIds.Annotations.INSTANCE.getPublishedApi()));
        } else {
            bl = original.getVisibility().visibleFromPackage(IrUtilsKt.getPackageFragment(clazz).getPackageFqName(), IrUtilsKt.getPackageFragment(original).getPackageFqName());
        }
        return bl;
    }

    public abstract <R> R inFile(@Nullable IrFile var1, @NotNull Function0<? extends R> var2);

    protected abstract void linkFunctionFakeOverride(@NotNull IrFunctionWithLateBinding var1, boolean var2);

    protected abstract void linkPropertyFakeOverride(@NotNull IrPropertyWithLateBinding var1, boolean var2);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0014J+\u0010\u0011\u001a\u0002H\u0012\"\u0004\b\u0000\u0010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lksp/org/jetbrains/kotlin/ir/overrides/FakeOverrideBuilderStrategy$BindToPrivateSymbols;", "Lksp/org/jetbrains/kotlin/ir/overrides/FakeOverrideBuilderStrategy;", "friendModules", "", "", "", "<init>", "(Ljava/util/Map;)V", "linkFunctionFakeOverride", "", "function", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunctionWithLateBinding;", "manglerCompatibleMode", "", "linkPropertyFakeOverride", "property", "Lksp/org/jetbrains/kotlin/ir/declarations/IrPropertyWithLateBinding;", "inFile", "R", "file", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFile;", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ir.tree"})
    public static abstract class BindToPrivateSymbols
    extends FakeOverrideBuilderStrategy {
        public BindToPrivateSymbols(@NotNull Map<String, ? extends Collection<String>> friendModules) {
            Intrinsics.checkNotNullParameter(friendModules, (String)"friendModules");
            super(friendModules, IrUnimplementedOverridesStrategy.ProcessAsFakeOverrides.INSTANCE);
        }

        @Override
        protected void linkFunctionFakeOverride(@NotNull IrFunctionWithLateBinding function2, boolean manglerCompatibleMode) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            function2.acquireSymbol(new IrSimpleFunctionSymbolImpl(null, null, 3, null));
        }

        @Override
        protected void linkPropertyFakeOverride(@NotNull IrPropertyWithLateBinding property, boolean manglerCompatibleMode) {
            block3: {
                IrSimpleFunction it;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                property.acquireSymbol(new IrPropertySymbolImpl(null, null, 3, null));
                IrSimpleFunction irSimpleFunction = property.getGetter();
                if (irSimpleFunction != null) {
                    it = irSimpleFunction;
                    boolean bl = false;
                    it.setCorrespondingPropertySymbol(property.getSymbol());
                    IrFunctionWithLateBinding irFunctionWithLateBinding = it instanceof IrFunctionWithLateBinding ? (IrFunctionWithLateBinding)it : null;
                    if (irFunctionWithLateBinding == null) {
                        throw new IllegalStateException(("Unexpected fake override getter: " + it).toString());
                    }
                    this.linkFunctionFakeOverride(irFunctionWithLateBinding, manglerCompatibleMode);
                }
                IrSimpleFunction irSimpleFunction2 = property.getSetter();
                if (irSimpleFunction2 == null) break block3;
                it = irSimpleFunction2;
                boolean bl = false;
                it.setCorrespondingPropertySymbol(property.getSymbol());
                IrFunctionWithLateBinding irFunctionWithLateBinding = it instanceof IrFunctionWithLateBinding ? (IrFunctionWithLateBinding)it : null;
                if (irFunctionWithLateBinding == null) {
                    throw new IllegalStateException(("Unexpected fake override setter: " + it).toString());
                }
                this.linkFunctionFakeOverride(irFunctionWithLateBinding, manglerCompatibleMode);
            }
        }

        @Override
        public <R> R inFile(@Nullable IrFile file2, @NotNull Function0<? extends R> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return (R)block.invoke();
        }
    }
}

