/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.HiddenCandidate;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import ksp.org.jetbrains.kotlin.fir.resolve.calls.ResolutionStagesKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeDynamicType;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/calls/ProcessDynamicExtensionAnnotation;", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "<init>", "()V", "check", "", "candidate", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lksp/org/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolve"})
public final class ProcessDynamicExtensionAnnotation
extends ResolutionStage {
    @NotNull
    public static final ProcessDynamicExtensionAnnotation INSTANCE = new ProcessDynamicExtensionAnnotation();

    private ProcessDynamicExtensionAnnotation() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, @NotNull Continuation<? super Unit> $completion) {
        if (candidate.getSymbol().getOrigin() == FirDeclarationOrigin.DynamicScope.INSTANCE) {
            return Unit.INSTANCE;
        }
        FirExpression firExpression = candidate.getChosenExtensionReceiver();
        if (firExpression == null) {
            return Unit.INSTANCE;
        }
        FirExpression extensionReceiver2 = firExpression;
        boolean argumentIsDynamic = FirTypeUtilsKt.getResolvedType(extensionReceiver2) instanceof ConeDynamicType;
        FirBasedSymbol<?> firBasedSymbol = candidate.getSymbol();
        Object object = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        boolean parameterIsDynamic = (object != null && (object = ((FirCallableSymbol)object).getResolvedReceiverTypeRef()) != null ? ((FirResolvedTypeRef)object).getType() : null) instanceof ConeDynamicType;
        if (parameterIsDynamic != argumentIsDynamic || parameterIsDynamic && !FirAnnotationUtilsKt.hasAnnotation(candidate.getSymbol(), ResolutionStagesKt.access$getDYNAMIC_EXTENSION_ANNOTATION_CLASS_ID$p(), context2.getSession())) {
            candidate.addDiagnostic(HiddenCandidate.INSTANCE);
        }
        return Unit.INSTANCE;
    }
}

