/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.backend.jvm;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import ksp.org.jetbrains.kotlin.backend.jvm.CachedFieldsForObjectInstances;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmFileFacadeClass;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmIrDeserializer;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import ksp.org.jetbrains.kotlin.backend.jvm.overrides.IrJavaIncompatibilityRulesOverridabilityCondition;
import ksp.org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import ksp.org.jetbrains.kotlin.config.CompilerConfiguration;
import ksp.org.jetbrains.kotlin.config.JVMConfigurationKeys;
import ksp.org.jetbrains.kotlin.config.JvmSerializeIrMode;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import ksp.org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import ksp.org.jetbrains.kotlin.fir.backend.utils.InjectedValue;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.references.FirReference;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import ksp.org.jetbrains.kotlin.ir.IrBuiltIns;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrMemberWithContainerSource;
import ksp.org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import ksp.org.jetbrains.kotlin.ir.declarations.impl.IrExternalPackageFragmentImpl;
import ksp.org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import ksp.org.jetbrains.kotlin.ir.overrides.IrExternalOverridabilityCondition;
import ksp.org.jetbrains.kotlin.ir.symbols.IrExternalPackageFragmentSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.KotlinMangler;
import ksp.org.jetbrains.kotlin.ir.util.SymbolTable;
import ksp.org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import ksp.org.jetbrains.kotlin.load.kotlin.FacadeClassSource;
import ksp.org.jetbrains.kotlin.name.FqName;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;
import ksp.org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import ksp.org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u001a\u00108\u001a\u0004\u0018\u00010\u00162\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u00020\f2\u0006\u0010>\u001a\u00020\u00162\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010?\u001a\u00020\f2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J\u0018\u0010D\u001a\u00020\f2\u0006\u00109\u001a\u00020E2\u0006\u0010B\u001a\u00020CH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u000e\u00a8\u0006F"}, d2={"Lksp/org/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions;", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "configuration", "Lksp/org/jetbrains/kotlin/config/CompilerConfiguration;", "irDeserializer", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;", "mangler", "Lksp/org/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "<init>", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;)V", "parametersAreAssignable", "", "getParametersAreAssignable", "()Z", "externalOverridabilityConditions", "", "Lksp/org/jetbrains/kotlin/ir/overrides/IrExternalOverridabilityCondition;", "getExternalOverridabilityConditions", "()Ljava/util/List;", "classNameOverride", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "Lksp/org/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getClassNameOverride", "()Ljava/util/Map;", "cachedFields", "Lksp/org/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "getCachedFields", "()Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "kotlinIrInternalPackage", "Lksp/org/jetbrains/kotlin/ir/declarations/impl/IrExternalPackageFragmentImpl;", "kotlinJvmInternalPackage", "specialAnnotationConstructors", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrConstructor;", "rawTypeAnnotationClassConstructor", "generateRawTypeAnnotationCall", "Lksp/org/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "createSpecialAnnotationClass", "fqn", "Lksp/org/jetbrains/kotlin/name/FqName;", "parent", "Lksp/org/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "registerDeclarations", "", "symbolTable", "Lksp/org/jetbrains/kotlin/ir/util/SymbolTable;", "findInjectedValue", "Lksp/org/jetbrains/kotlin/fir/backend/utils/InjectedValue;", "calleeReference", "Lksp/org/jetbrains/kotlin/fir/references/FirReference;", "conversionScope", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "irNeedsDeserialization", "getIrNeedsDeserialization", "generateOrGetFacadeClass", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrMemberWithContainerSource;", "components", "Lksp/org/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "deserializeToplevelClass", "irClass", "hasBackingField", "property", "Lksp/org/jetbrains/kotlin/fir/declarations/FirProperty;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "isTrueStatic", "Lksp/org/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nJvmFir2IrExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmFir2IrExtensions.kt\norg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1863#2,2:125\n*S KotlinDebug\n*F\n+ 1 JvmFir2IrExtensions.kt\norg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions\n*L\n85#1:125,2\n*E\n"})
public final class JvmFir2IrExtensions
implements Fir2IrExtensions,
JvmGeneratorExtensions {
    @NotNull
    private final JvmIrDeserializer irDeserializer;
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    @NotNull
    private final Map<IrClass, JvmClassName> classNameOverride;
    @NotNull
    private final CachedFieldsForObjectInstances cachedFields;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinIrInternalPackage;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinJvmInternalPackage;
    @NotNull
    private final List<IrConstructor> specialAnnotationConstructors;
    @NotNull
    private final IrConstructor rawTypeAnnotationClassConstructor;
    private final boolean irNeedsDeserialization;

    public JvmFir2IrExtensions(@NotNull CompilerConfiguration configuration2, @NotNull JvmIrDeserializer irDeserializer, @NotNull KotlinMangler.IrMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)irDeserializer, (String)"irDeserializer");
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        this.irDeserializer = irDeserializer;
        this.mangler = mangler;
        this.classNameOverride = new LinkedHashMap();
        this.cachedFields = new CachedFieldsForObjectInstances(IrFactoryImpl.INSTANCE, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2));
        this.kotlinIrInternalPackage = new IrExternalPackageFragmentImpl(new DescriptorlessExternalPackageFragmentSymbol(), IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN());
        IrExternalPackageFragmentSymbol irExternalPackageFragmentSymbol = new DescriptorlessExternalPackageFragmentSymbol();
        FqName fqName = JvmAnnotationNames.KOTLIN_JVM_INTERNAL;
        Intrinsics.checkNotNullExpressionValue((Object)fqName, (String)"KOTLIN_JVM_INTERNAL");
        this.kotlinJvmInternalPackage = new IrExternalPackageFragmentImpl(irExternalPackageFragmentSymbol, fqName);
        this.specialAnnotationConstructors = new ArrayList();
        this.rawTypeAnnotationClassConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors(this.createSpecialAnnotationClass(JvmSymbols.Companion.getRAW_TYPE_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage)));
        FqName fqName2 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"ENHANCED_NULLABILITY_ANNOTATION");
        this.createSpecialAnnotationClass(fqName2, this.kotlinJvmInternalPackage);
        this.createSpecialAnnotationClass(JvmSymbols.Companion.getFLEXIBLE_NULLABILITY_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.createSpecialAnnotationClass(JvmSymbols.Companion.getFLEXIBLE_MUTABILITY_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.irNeedsDeserialization = configuration2.get(JVMConfigurationKeys.SERIALIZE_IR, JvmSerializeIrMode.NONE) != JvmSerializeIrMode.NONE;
    }

    @Override
    public boolean getParametersAreAssignable() {
        return true;
    }

    @Override
    @NotNull
    public List<IrExternalOverridabilityCondition> getExternalOverridabilityConditions() {
        return CollectionsKt.listOf((Object)new IrJavaIncompatibilityRulesOverridabilityCondition());
    }

    @Override
    @NotNull
    public Map<IrClass, JvmClassName> getClassNameOverride() {
        return this.classNameOverride;
    }

    @Override
    @NotNull
    public CachedFieldsForObjectInstances getCachedFields() {
        return this.cachedFields;
    }

    @Override
    @NotNull
    public IrConstructorCall generateRawTypeAnnotationCall() {
        IrConstructor it = this.rawTypeAnnotationClassConstructor;
        boolean bl = false;
        return IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, -1, -1, IrUtilsKt.getConstructedClassType(it), it.getSymbol(), null, 16, null);
    }

    private final IrClass createSpecialAnnotationClass(FqName fqn, IrPackageFragment parent2) {
        IrClass irClass;
        IrClass $this$createSpecialAnnotationClass_u24lambda_u241 = irClass = IrUtilsKt.createSpecialAnnotationClass(IrFactoryImpl.INSTANCE, fqn, parent2);
        boolean bl = false;
        this.specialAnnotationConstructors.add((IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors($this$createSpecialAnnotationClass_u24lambda_u241)));
        return irClass;
    }

    @Override
    public void registerDeclarations(@NotNull SymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        PublicIdSignatureComputer signatureComputer = new PublicIdSignatureComputer(this.mangler);
        Iterable $this$forEach$iv = this.specialAnnotationConstructors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructor constructor = (IrConstructor)element$iv;
            boolean bl = false;
            symbolTable.declareConstructorWithSignature(signatureComputer.composePublicIdSignature(constructor, false), constructor.getSymbol());
        }
    }

    @Override
    @Nullable
    public InjectedValue findInjectedValue(@NotNull FirReference calleeReference, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)calleeReference, (String)"calleeReference");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        return null;
    }

    @Override
    public boolean getIrNeedsDeserialization() {
        return this.irNeedsDeserialization;
    }

    @Override
    @Nullable
    public IrClass generateOrGetFacadeClass(@NotNull IrMemberWithContainerSource declaration2, @NotNull Fir2IrComponents components) {
        JvmFileFacadeClass jvmFileFacadeClass;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        DeserializedContainerSource deserializedContainerSource = declaration2.getContainerSource();
        if (deserializedContainerSource == null) {
            return null;
        }
        DeserializedContainerSource deserializedSource = deserializedContainerSource;
        if (!(deserializedSource instanceof FacadeClassSource)) {
            return null;
        }
        JvmClassName jvmClassName = ((FacadeClassSource)((Object)deserializedSource)).getFacadeClassName();
        if (jvmClassName == null) {
            jvmClassName = ((FacadeClassSource)((Object)deserializedSource)).getClassName();
        }
        JvmClassName facadeName = jvmClassName;
        IrDeclarationOrigin irDeclarationOrigin = ((FacadeClassSource)((Object)deserializedSource)).getFacadeClassName() != null ? IrDeclarationOrigin.Companion.getJVM_MULTIFILE_CLASS() : IrDeclarationOrigin.Companion.getFILE_CLASS();
        Name name2 = facadeName.getFqNameForTopLevelClassMaybeWithDollars().shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"shortName(...)");
        JvmFileFacadeClass it = jvmFileFacadeClass = new JvmFileFacadeClass(irDeclarationOrigin, name2, deserializedSource, (Function1<? super IrClass, Boolean>)((Function1)arg_0 -> JvmFir2IrExtensions.generateOrGetFacadeClass$lambda$3(this, components, arg_0)));
        boolean bl = false;
        IrUtilsKt.createParameterDeclarations(it);
        this.getClassNameOverride().put(it, facadeName);
        return jvmFileFacadeClass;
    }

    @Override
    public boolean deserializeToplevelClass(@NotNull IrClass irClass, @NotNull Fir2IrComponents components) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        return this.irDeserializer.deserializeTopLevelClass(irClass, components.getIrBuiltIns(), components.getSymbolTable(), components.getIrProviders(), this);
    }

    @Override
    public boolean hasBackingField(@NotNull FirProperty property, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return property.getOrigin() instanceof FirDeclarationOrigin.Java || Fir2IrExtensions.Default.INSTANCE.hasBackingField(property, session);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isTrueStatic(@NotNull FirCallableDeclaration declaration2, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (FirAnnotationUtilsKt.hasAnnotation(declaration2, StandardClassIds.Annotations.INSTANCE.getJvmStatic(), session)) return true;
        if (!(declaration2 instanceof FirPropertyAccessor)) return false;
        FirPropertyAccessor firPropertyAccessor = (FirPropertyAccessor)declaration2;
        Object object = firPropertyAccessor;
        if (firPropertyAccessor == null) return false;
        FirPropertySymbol firPropertySymbol = ((FirPropertyAccessor)object).getPropertySymbol();
        object = firPropertySymbol;
        if (firPropertySymbol == null) return false;
        FirProperty firProperty = (FirProperty)((FirBasedSymbol)object).getFir();
        object = firProperty;
        if (firProperty == null) return false;
        if (!FirAnnotationUtilsKt.hasAnnotation((FirDeclaration)object, StandardClassIds.Annotations.INSTANCE.getJvmStatic(), session)) return false;
        return true;
    }

    private static final boolean generateOrGetFacadeClass$lambda$3(JvmFir2IrExtensions this$0, Fir2IrComponents $components, IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        return this$0.deserializeToplevelClass(irClass, $components);
    }
}

