/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.backend.common.BackendContext;
import ksp.org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import ksp.org.jetbrains.kotlin.backend.common.ScopeWithIr;
import ksp.org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import ksp.org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import ksp.org.jetbrains.kotlin.backend.common.lower.loops.ForLoopsLowering;
import ksp.org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import ksp.org.jetbrains.kotlin.backend.jvm.InlineClassAbi;
import ksp.org.jetbrains.kotlin.backend.jvm.InlineClassAbiKt;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import ksp.org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import ksp.org.jetbrains.kotlin.backend.jvm.MemoizedValueClassAbstractReplacements;
import ksp.org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.CollectionStubMethodLowering;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmBuiltInsLowering;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmSingleAbstractMethodLowering;
import ksp.org.jetbrains.kotlin.backend.jvm.lower.JvmValueClassAbstractLowering;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.config.ApiVersion;
import ksp.org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import ksp.org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import ksp.org.jetbrains.kotlin.ir.IrElement;
import ksp.org.jetbrains.kotlin.ir.IrElementBase;
import ksp.org.jetbrains.kotlin.ir.IrElementsKt;
import ksp.org.jetbrains.kotlin.ir.IrStatement;
import ksp.org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import ksp.org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.IrBlockBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import ksp.org.jetbrains.kotlin.ir.builders.IrGeneratorWithScope;
import ksp.org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import ksp.org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import ksp.org.jetbrains.kotlin.ir.declarations.IrClass;
import ksp.org.jetbrains.kotlin.ir.declarations.IrConstructor;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import ksp.org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFactory;
import ksp.org.jetbrains.kotlin.ir.declarations.IrField;
import ksp.org.jetbrains.kotlin.ir.declarations.IrFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import ksp.org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import ksp.org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import ksp.org.jetbrains.kotlin.ir.declarations.IrVariable;
import ksp.org.jetbrains.kotlin.ir.expressions.IrBody;
import ksp.org.jetbrains.kotlin.ir.expressions.IrCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetField;
import ksp.org.jetbrains.kotlin.ir.expressions.IrGetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import ksp.org.jetbrains.kotlin.ir.expressions.IrReturn;
import ksp.org.jetbrains.kotlin.ir.expressions.IrSetValue;
import ksp.org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import ksp.org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import ksp.org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import ksp.org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrSymbol;
import ksp.org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import ksp.org.jetbrains.kotlin.ir.types.IrSimpleType;
import ksp.org.jetbrains.kotlin.ir.types.IrType;
import ksp.org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import ksp.org.jetbrains.kotlin.ir.types.IrTypesKt;
import ksp.org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.InlineClassesKt;
import ksp.org.jetbrains.kotlin.ir.util.IrUtilsKt;
import ksp.org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import ksp.org.jetbrains.kotlin.ir.util.TransformKt;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import ksp.org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import ksp.org.jetbrains.kotlin.name.Name;
import ksp.org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;

@PhaseDescription(name="InlineClasses", description="Lower inline classes", prerequisite={ForLoopsLowering.class, JvmBuiltInsLowering.class, CollectionStubMethodLowering.class, JvmSingleAbstractMethodLowering.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0016J\u0015\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0002\b\"J\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aH\u0016J\u0010\u0010$\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u001aH\u0016J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001aH\u0002J(\u0010'\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u0019H\u0014J\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020!0+2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020\u0014H\u0014J,\u0010.\u001a\u00020\u000f*\u0006\u0012\u0002\b\u00030/2\u0006\u00100\u001a\u00020\u00112\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030/2\u0006\u0010\u0012\u001a\u00020\u0014H\u0002J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u0002022\u0006\u00103\u001a\u000206H\u0016J*\u00107\u001a\u0002022\u0006\u00108\u001a\u0002022\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020:2\b\b\u0002\u0010<\u001a\u00020\u0019H\u0002J\f\u0010=\u001a\u000202*\u000202H\u0002J\u001e\u0010>\u001a\u0004\u0018\u000102*\u00020?2\u0006\u0010@\u001a\u0002022\u0006\u0010A\u001a\u000202H\u0002J\u0010\u0010B\u001a\u0002022\u0006\u00103\u001a\u00020CH\u0016J\u0010\u0010J\u001a\u0002022\u0006\u00103\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u0002022\u0006\u00103\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u0002022\u0006\u00103\u001a\u00020OH\u0016J\u0018\u0010P\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010Q\u001a\u00020-H\u0002J\u0010\u0010R\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001aH\u0002J\u0010\u0010S\u001a\u00020\u000f2\u0006\u0010T\u001a\u00020\u001aH\u0002J\u0010\u0010U\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u001aH\u0002R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u001c8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010D\u001a\u00020\u0019*\u00020C8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010ER\u0018\u0010F\u001a\u00020\u0019*\u00020C8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010ER\u0018\u0010G\u001a\u00020\u0019*\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010I\u00a8\u0006V"}, d2={"Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmInlineClassLowering;", "Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmValueClassAbstractLowering;", "context", "Lksp/org/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "replacements", "Lksp/org/jetbrains/kotlin/backend/jvm/MemoizedValueClassAbstractReplacements;", "getReplacements", "()Lorg/jetbrains/kotlin/backend/jvm/MemoizedValueClassAbstractReplacements;", "valueMap", "", "Lksp/org/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lksp/org/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "addBindingsFor", "", "original", "Lksp/org/jetbrains/kotlin/ir/declarations/IrFunction;", "replacement", "createBridgeDeclaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "source", "mangledName", "Lksp/org/jetbrains/kotlin/name/Name;", "isSpecificLoweringLogicApplicable", "", "Lksp/org/jetbrains/kotlin/ir/declarations/IrClass;", "specificMangle", "Lksp/org/jetbrains/kotlin/backend/jvm/lower/JvmValueClassAbstractLowering$SpecificMangle;", "getSpecificMangle", "()Lorg/jetbrains/kotlin/backend/jvm/lower/JvmValueClassAbstractLowering$SpecificMangle;", "visitClassNewDeclarationsWhenParallel", "declaration", "Lksp/org/jetbrains/kotlin/ir/declarations/IrDeclaration;", "visitClassNewDeclarationsWhenParallel$backend_jvm_lower", "visitClassNew", "handleSpecificNewClass", "addJvmInlineAnnotation", "valueClass", "createBridgeBody", "target", "inverted", "transformSecondaryConstructorFlat", "", "constructor", "Lksp/org/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildReplacement", "Lksp/org/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "originalFunction", "visitFunctionReference", "Lksp/org/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lksp/org/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitFunctionAccess", "Lksp/org/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "coerceInlineClasses", "argument", "from", "Lksp/org/jetbrains/kotlin/ir/types/IrType;", "to", "skipCast", "coerceToUnboxed", "specializeEqualsCall", "Lksp/org/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "left", "right", "visitCall", "Lksp/org/jetbrains/kotlin/ir/expressions/IrCall;", "isEqualsMethodCallOnInlineClass", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)Z", "isEqEqCallOnInlineClass", "canUseSpecializedEqMethod", "getCanUseSpecializedEqMethod", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Z", "visitGetField", "Lksp/org/jetbrains/kotlin/ir/expressions/IrGetField;", "visitGetValue", "Lksp/org/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lksp/org/jetbrains/kotlin/ir/expressions/IrSetValue;", "buildPrimaryInlineClassConstructor", "irConstructor", "buildBoxFunction", "buildUnboxFunction", "irClass", "buildSpecializedEqualsMethodIfNeeded", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmInlineClassLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmInlineClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmInlineClassLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 LowerUtils.kt\norg/jetbrains/kotlin/backend/common/lower/LowerUtilsKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBuilderKt\n+ 7 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n+ 8 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 9 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBuilder\n+ 10 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 11 IrElementTransformerVoidWithContext.kt\norg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext\n*L\n1#1,540:1\n237#2,4:541\n289#2:573\n283#2,13:574\n1#3:545\n1863#4,2:546\n1863#4,2:555\n1863#4,2:587\n808#4,11:597\n827#4:608\n855#4,2:609\n1863#4,2:611\n97#5:548\n97#5:589\n180#6,5:549\n180#6,5:590\n72#7:554\n73#7:557\n72#7,2:595\n72#7,2:623\n72#7,2:635\n388#8,13:558\n416#8,10:613\n416#8,10:625\n98#9,2:571\n350#10,12:637\n350#10,12:653\n47#11,4:649\n*S KotlinDebug\n*F\n+ 1 JvmInlineClassLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmInlineClassLowering\n*L\n65#1:541,4\n427#1:573\n427#1:574,13\n147#1:546,2\n154#1:555,2\n434#1:587,2\n451#1:597,11\n452#1:608\n452#1:609,2\n454#1:611,2\n148#1:548\n437#1:589\n148#1:549,5\n437#1:590,5\n148#1:554\n148#1:557\n437#1:595,2\n455#1:623,2\n488#1:635,2\n309#1:558,13\n455#1:613,10\n488#1:625,10\n309#1:571,2\n504#1:637,12\n296#1:653,12\n94#1:649,4\n*E\n"})
public final class JvmInlineClassLowering
extends JvmValueClassAbstractLowering {
    @NotNull
    private final Map<IrValueSymbol, IrValueDeclaration> valueMap;

    public JvmInlineClassLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super(context2);
        this.valueMap = new LinkedHashMap();
    }

    @Override
    @NotNull
    public MemoizedValueClassAbstractReplacements getReplacements() {
        return this.getContext().getInlineClassReplacements();
    }

    @Override
    protected void addBindingsFor(@NotNull IrFunction original, @NotNull IrFunction replacement) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        for (Pair pair : CollectionsKt.zip((Iterable)IrUtilsKt.getExplicitParameters(original), (Iterable)IrUtilsKt.getExplicitParameters(replacement))) {
            IrValueParameter param = (IrValueParameter)pair.component1();
            IrValueParameter newParam = (IrValueParameter)pair.component2();
            this.valueMap.put(param.getSymbol(), newParam);
        }
    }

    @Override
    @NotNull
    public IrSimpleFunction createBridgeDeclaration(@NotNull IrSimpleFunction source, @NotNull IrSimpleFunction replacement, @NotNull Name mangledName) {
        IrSimpleFunction irSimpleFunction;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        Intrinsics.checkNotNullParameter((Object)mangledName, (String)"mangledName");
        IrFactory $this$buildFun$iv = this.getContext().getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createBridgeDeclaration_u24lambda_u240 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl2 = false;
        $this$createBridgeDeclaration_u24lambda_u240.updateFrom(source);
        $this$createBridgeDeclaration_u24lambda_u240.setName(mangledName);
        $this$createBridgeDeclaration_u24lambda_u240.setReturnType(source.getReturnType());
        IrSimpleFunction $this$createBridgeDeclaration_u24lambda_u241 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        boolean bl3 = false;
        IrUtilsKt.copyParameterDeclarationsFrom($this$createBridgeDeclaration_u24lambda_u241, source);
        $this$createBridgeDeclaration_u24lambda_u241.setAnnotations(source.getAnnotations());
        $this$createBridgeDeclaration_u24lambda_u241.setParent(source.getParent());
        IrDeclarationsKt.copyAttributes((IrAttributeContainer)$this$createBridgeDeclaration_u24lambda_u241, source);
        return irSimpleFunction;
    }

    @Override
    public boolean isSpecificLoweringLogicApplicable(@NotNull IrClass $this$isSpecificLoweringLogicApplicable) {
        Intrinsics.checkNotNullParameter((Object)$this$isSpecificLoweringLogicApplicable, (String)"<this>");
        return IrDeclarationsKt.isSingleFieldValueClass($this$isSpecificLoweringLogicApplicable);
    }

    @Override
    @NotNull
    protected JvmValueClassAbstractLowering.SpecificMangle getSpecificMangle() {
        return JvmValueClassAbstractLowering.SpecificMangle.Inline;
    }

    @Override
    public void visitClassNewDeclarationsWhenParallel$backend_jvm_lower(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
    }

    @Override
    @NotNull
    public IrClass visitClassNew(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(declaration2);
        if (irConstructor != null) {
            IrConstructor it = irConstructor;
            boolean bl = false;
            IrSimpleFunction irSimpleFunction = this.getReplacements().getReplacementFunction(it);
            if (irSimpleFunction != null) {
                IrSimpleFunction replacement = irSimpleFunction;
                boolean bl2 = false;
                this.addBindingsFor(it, replacement);
            }
        }
        TransformKt.transformDeclarationsFlat(declaration2, (Function1<? super IrDeclaration, ? extends List<? extends IrDeclaration>>)((Function1)arg_0 -> JvmInlineClassLowering.visitClassNew$lambda$5(this, arg_0)));
        if (this.isSpecificLoweringLogicApplicable(declaration2)) {
            this.handleSpecificNewClass(declaration2);
        }
        return declaration2;
    }

    @Override
    public void handleSpecificNewClass(@NotNull IrClass declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(declaration2);
        Intrinsics.checkNotNull((Object)irConstructor);
        IrConstructor irConstructor2 = irConstructor;
        declaration2.getDeclarations().removeIf(arg_0 -> JvmInlineClassLowering.handleSpecificNewClass$lambda$7(arg_0 -> JvmInlineClassLowering.handleSpecificNewClass$lambda$6(irConstructor2, arg_0), arg_0));
        this.buildPrimaryInlineClassConstructor(declaration2, irConstructor2);
        this.buildBoxFunction(declaration2);
        this.buildUnboxFunction(declaration2);
        this.buildSpecializedEqualsMethodIfNeeded(declaration2);
        this.addJvmInlineAnnotation(declaration2);
    }

    private final void addJvmInlineAnnotation(IrClass valueClass) {
        if (IrUtilsKt.hasAnnotation((IrAnnotationContainer)valueClass, InlineClassesUtilsKt.getJVM_INLINE_ANNOTATION_FQ_NAME())) {
            return;
        }
        IrConstructorSymbol constructor = (IrConstructorSymbol)SequencesKt.first(IrUtilsKt.getConstructors(this.getContext().getIr().getSymbols().getJvmInlineAnnotation()));
        valueClass.setAnnotations(CollectionsKt.plus((Collection)valueClass.getAnnotations(), (Object)IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, ((IrConstructor)constructor.getOwner()).getReturnType(), constructor, null, 4, null)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void createBridgeBody(@NotNull IrSimpleFunction source, @NotNull IrSimpleFunction target, @NotNull IrFunction original, boolean inverted) {
        void $this$createBridgeBody_u24lambda_u249_u24lambda_u248;
        void $this$createBridgeBody_u24lambda_u249;
        IrFunctionAccessExpression irFunctionAccessExpression;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        DeclarationIrBuilder declarationIrBuilder = LowerUtilsKt.createIrBuilder(this.getContext(), (IrSymbol)source.getSymbol(), source.getStartOffset(), source.getEndOffset());
        IrSimpleFunction irSimpleFunction = source;
        boolean bl = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$createBridgeBody_u24lambda_u249, target);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createBridgeBody_u24lambda_u249;
        boolean bl2 = false;
        IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$createBridgeBody_u24lambda_u249_u24lambda_u248, source, 0, 2, null);
        for (Pair pair : CollectionsKt.zip((Iterable)IrUtilsKt.getExplicitParameters(source), (Iterable)IrUtilsKt.getExplicitParameters(target))) {
            IrValueParameter parameter2 = (IrValueParameter)pair.component1();
            IrValueParameter newParameter = (IrValueParameter)pair.component2();
            IrExpressionsKt.putArgument((IrFunctionAccessExpression)$this$createBridgeBody_u24lambda_u249_u24lambda_u248, newParameter, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createBridgeBody_u24lambda_u249, parameter2));
        }
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, irFunctionAccessExpression));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<IrDeclaration> transformSecondaryConstructorFlat(@NotNull IrConstructor constructor, @NotNull IrSimpleFunction replacement) {
        void $this$transformSecondaryConstructorFlat_u24lambda_u2412;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        Iterable $this$forEach$iv = replacement.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl = false;
            this.transformChildrenVoid(it);
        }
        IrGeneratorWithScope $this$irBlockBody$iv = LowerUtilsKt.createIrBuilder(this.getContext(), (IrSymbol)replacement.getSymbol(), replacement.getStartOffset(), replacement.getEndOffset());
        boolean $i$f$irBlockBody = false;
        IrGeneratorWithScope irGeneratorWithScope = $this$irBlockBody$iv;
        int element$iv = ((IrElement)replacement).getStartOffset();
        int endOffset$iv$iv = ((IrElement)replacement).getEndOffset();
        boolean $i$f$irBlockBody2 = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv);
        boolean $i$f$blockBody = false;
        void var11_13 = this_$iv$iv$iv;
        IrSimpleFunction irSimpleFunction = replacement;
        boolean bl = false;
        IrType irType = replacement.getReturnType();
        IrVariable thisVar = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$transformSecondaryConstructorFlat_u24lambda_u2412, null, "$this", irType, false, null, 25, null);
        IrValueParameter irValueParameter = AdditionalIrUtilsKt.getConstructedClass(constructor).getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        this.valueMap.put(irValueParameter.getSymbol(), thisVar);
        Object object = constructor.getBody();
        if (object != null && (object = IrUtilsKt.getStatements((IrBody)object)) != null) {
            Iterable $this$forEach$iv2 = (Iterable)object;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrStatement statement = (IrStatement)element$iv2;
                boolean bl2 = false;
                $this$transformSecondaryConstructorFlat_u24lambda_u2412.unaryPlus((IrStatement)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)IrElementsKt.transformStatement(IrElementsKt.transformStatement(statement, new IrElementTransformerVoid((IrBlockBodyBuilder)$this$transformSecondaryConstructorFlat_u24lambda_u2412, thisVar, constructor){
                    final /* synthetic */ IrBlockBodyBuilder $this_irBlockBody;
                    final /* synthetic */ IrVariable $thisVar;
                    final /* synthetic */ IrConstructor $constructor;
                    {
                        this.$this_irBlockBody = $receiver;
                        this.$thisVar = $thisVar;
                        this.$constructor = $constructor;
                    }

                    public IrStatement visitClass(IrClass declaration2) {
                        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                        return declaration2;
                    }

                    public IrExpression visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        this.transformChildrenVoid(expression2);
                        return ExpressionHelpersKt.irSet$default((IrBuilderWithScope)this.$this_irBlockBody, this.$thisVar.getSymbol(), (IrExpression)expression2, null, 4, null);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public IrExpression visitReturn(IrReturn expression2) {
                        void $this$visitReturn_u24lambda_u240;
                        void this_$iv$iv;
                        void endOffset$iv;
                        void startOffset$iv;
                        void $this$irBlock_u24default$iv;
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        this.transformChildrenVoid(expression2);
                        if (!Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol(), (Object)this.$constructor.getSymbol())) {
                            return expression2;
                        }
                        IrBuilderWithScope irBuilderWithScope = this.$this_irBlockBody;
                        int n = expression2.getStartOffset();
                        int n2 = expression2.getEndOffset();
                        IrVariable irVariable = this.$thisVar;
                        IrStatementOrigin origin$iv = null;
                        IrType resultType$iv = null;
                        boolean $i$f$irBlock = false;
                        IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), (int)startOffset$iv, (int)endOffset$iv, origin$iv, resultType$iv, false, 64, null);
                        boolean $i$f$block = false;
                        void var11_11 = this_$iv$iv;
                        IrBuilderWithScope irBuilderWithScope2 = this.$this_irBlockBody;
                        boolean bl = false;
                        $this$visitReturn_u24lambda_u240.unaryPlus(expression2.getValue());
                        $this$visitReturn_u24lambda_u240.unaryPlus(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$visitReturn_u24lambda_u240, irVariable));
                        return ExpressionHelpersKt.irReturn(irBuilderWithScope2, this_$iv$iv.doBuild());
                    }
                }), this), replacement));
            }
        }
        $this$transformSecondaryConstructorFlat_u24lambda_u2412.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$transformSecondaryConstructorFlat_u24lambda_u2412, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$transformSecondaryConstructorFlat_u24lambda_u2412, thisVar)));
        irSimpleFunction.setBody(this_$iv$iv$iv.doBuild());
        return CollectionsKt.listOf((Object)replacement);
    }

    private final void buildReplacement(IrMemberAccessExpression<?> $this$buildReplacement, IrFunction originalFunction, IrMemberAccessExpression<?> original, IrSimpleFunction replacement) {
        IrExpressionsKt.copyTypeArgumentsFrom$default($this$buildReplacement, original, 0, 2, null);
        Map valueParameterMap = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)IrUtilsKt.getExplicitParameters(originalFunction), (Iterable)IrUtilsKt.getExplicitParameters(replacement)));
        for (Pair<IrValueParameter, IrExpression> pair : this.typedArgumentList(originalFunction, original)) {
            IrValueParameter parameter2 = (IrValueParameter)pair.component1();
            IrExpression argument = (IrExpression)pair.component2();
            if (argument == null) continue;
            IrValueParameter newParameter = (IrValueParameter)MapsKt.getValue((Map)valueParameterMap, (Object)parameter2);
            IrExpressionsKt.putArgument($this$buildReplacement, replacement, newParameter, (IrExpression)argument.transform((IrElementTransformer)this, (Object)null));
        }
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrFunctionReferenceImpl irFunctionReferenceImpl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)InlineClassAbi.INSTANCE.getUNMANGLED_FUNCTION_REFERENCE())) {
            return super.visitFunctionReference(expression2);
        }
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrSimpleFunction irSimpleFunction = this.getContext().getInlineClassReplacements().getReplacementFunction(function2);
        if (irSimpleFunction == null) {
            return super.visitFunctionReference(expression2);
        }
        IrSimpleFunction replacement = irSimpleFunction;
        IrFunctionReferenceImpl $this$visitFunctionReference_u24lambda_u2413 = irFunctionReferenceImpl = new IrFunctionReferenceImpl(expression2.getStartOffset(), expression2.getEndOffset(), expression2.getType(), replacement.getSymbol(), function2.getTypeParameters().size(), replacement.getValueParameters().size(), expression2.getReflectionTarget(), expression2.getOrigin());
        boolean bl = false;
        this.buildReplacement($this$visitFunctionReference_u24lambda_u2413, function2, expression2, replacement);
        return (IrExpression)IrDeclarationsKt.copyAttributes((IrAttributeContainer)irFunctionReferenceImpl, expression2);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrCallImpl irCallImpl;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrFunction function2 = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
        IrSimpleFunction irSimpleFunction = this.getContext().getInlineClassReplacements().getReplacementFunction(function2);
        if (irSimpleFunction == null) {
            return super.visitFunctionAccess(expression2);
        }
        IrSimpleFunction replacement = irSimpleFunction;
        IrCall irCall = expression2 instanceof IrCall ? (IrCall)expression2 : null;
        IrCallImpl $this$visitFunctionAccess_u24lambda_u2414 = irCallImpl = new IrCallImpl(expression2.getStartOffset(), expression2.getEndOffset(), ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.substitute(function2.getReturnType(), IrUtilsKt.getTypeSubstitutionMap(expression2)), replacement.getSymbol(), replacement.getTypeParameters().size(), replacement.getValueParameters().size(), expression2.getOrigin(), irCall != null ? irCall.getSuperQualifierSymbol() : null);
        boolean bl = false;
        this.buildReplacement($this$visitFunctionAccess_u24lambda_u2414, function2, expression2, replacement);
        return irCallImpl;
    }

    private final IrExpression coerceInlineClasses(IrExpression argument, IrType from2, IrType to, boolean skipCast) {
        IrSimpleType underlyingType;
        IrCallImpl irCallImpl;
        IrCallImpl $this$coerceInlineClasses_u24lambda_u2415 = irCallImpl = IrCallImpl.Companion.fromSymbolOwner$default(IrCallImpl.Companion, -1, -1, to, this.getContext().getIr().getSymbols().getUnsafeCoerceIntrinsic(), 0, 0, null, null, 240, null);
        boolean bl = false;
        InlineClassRepresentation<IrSimpleType> inlineClassRepresentation = IrDeclarationsKt.getInlineClassRepresentation(JvmIrTypeUtilsKt.getErasedUpperBound(from2));
        IrSimpleType irSimpleType = underlyingType = inlineClassRepresentation != null ? inlineClassRepresentation.getUnderlyingType() : null;
        boolean bl2 = irSimpleType != null ? ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isTypeParameter(irSimpleType) : false;
        if (bl2 && !skipCast) {
            $this$coerceInlineClasses_u24lambda_u2415.putTypeArgument(0, from2);
            $this$coerceInlineClasses_u24lambda_u2415.putTypeArgument(1, underlyingType);
            $this$coerceInlineClasses_u24lambda_u2415.putValueArgument(0, BuildersKt.IrTypeOperatorCallImpl(-1, -1, to, IrTypeOperator.IMPLICIT_CAST, underlyingType, argument));
        } else {
            $this$coerceInlineClasses_u24lambda_u2415.putTypeArgument(0, from2);
            $this$coerceInlineClasses_u24lambda_u2415.putTypeArgument(1, to);
            $this$coerceInlineClasses_u24lambda_u2415.putValueArgument(0, argument);
        }
        return irCallImpl;
    }

    static /* synthetic */ IrExpression coerceInlineClasses$default(JvmInlineClassLowering jvmInlineClassLowering, IrExpression irExpression, IrType irType, IrType irType2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return jvmInlineClassLowering.coerceInlineClasses(irExpression, irType, irType2, bl);
    }

    private final IrExpression coerceToUnboxed(IrExpression $this$coerceToUnboxed) {
        return JvmInlineClassLowering.coerceInlineClasses$default(this, $this$coerceToUnboxed, $this$coerceToUnboxed.getType(), InlineClassAbiKt.unboxInlineClass($this$coerceToUnboxed.getType()), false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression specializeEqualsCall(IrBuilderWithScope $this$specializeEqualsCall, IrExpression left, IrExpression right) {
        IrExpression irExpression;
        boolean rightNullCheck;
        boolean rightIsUnboxed;
        if (IrUtilsKt.isNullConst(left) || IrUtilsKt.isNullConst(right)) {
            return null;
        }
        boolean leftIsUnboxed = !Intrinsics.areEqual((Object)InlineClassAbiKt.unboxInlineClass(left.getType()), (Object)left.getType());
        boolean bl = rightIsUnboxed = !Intrinsics.areEqual((Object)InlineClassAbiKt.unboxInlineClass(right.getType()), (Object)right.getType());
        if (!leftIsUnboxed && !rightIsUnboxed) {
            return null;
        }
        boolean leftNullCheck = IrTypeUtilsKt.isNullable(left.getType());
        boolean bl2 = rightNullCheck = rightIsUnboxed && IrTypeUtilsKt.isNullable(right.getType());
        if (leftNullCheck || rightNullCheck) {
            IrExpression equalsRight;
            void this_$iv$iv;
            IrBuilderWithScope $this$irBlock_u24default$iv = $this$specializeEqualsCall;
            int startOffset$iv = $this$irBlock_u24default$iv.getStartOffset();
            int endOffset$iv = $this$irBlock_u24default$iv.getEndOffset();
            IrStatementOrigin origin$iv = null;
            IrType resultType$iv = null;
            boolean $i$f$irBlock = false;
            IrBlockBuilder irBlockBuilder = new IrBlockBuilder($this$irBlock_u24default$iv.getContext(), $this$irBlock_u24default$iv.getScope(), startOffset$iv, endOffset$iv, origin$iv, resultType$iv, false, 64, null);
            boolean $i$f$block = false;
            void $this$specializeEqualsCall_u24lambda_u2418 = this_$iv$iv;
            boolean bl3 = false;
            IrValueDeclaration leftVal = left instanceof IrGetValue ? ((IrGetValue)left).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$specializeEqualsCall_u24lambda_u2418, left, null, null, false, null, 30, null);
            IrValueDeclaration rightVal = right instanceof IrGetValue ? ((IrGetValue)right).getSymbol().getOwner() : (IrValueDeclaration)ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$specializeEqualsCall_u24lambda_u2418, right, null, null, false, null, 30, null);
            IrExpression equalsCall = JvmInlineClassLowering.specializeEqualsCall$equals(rightIsUnboxed, $this$specializeEqualsCall, this, leftNullCheck ? (IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, leftVal), IrTypesKt.makeNotNull(left.getType())) : (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, leftVal), rightNullCheck ? (IrExpression)ExpressionHelpersKt.irImplicitCast((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, rightVal), IrTypesKt.makeNotNull(right.getType())) : (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, rightVal));
            IrExpression irExpression2 = equalsRight = rightNullCheck ? (IrExpression)ExpressionHelpersKt.irIfNull((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, $this$specializeEqualsCall_u24lambda_u2418.getContext().getIrBuiltIns().getBooleanType(), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, rightVal), ExpressionHelpersKt.irFalse((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418), equalsCall) : equalsCall;
            if (leftNullCheck) {
                $this$specializeEqualsCall_u24lambda_u2418.unaryPlus(ExpressionHelpersKt.irIfNull((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, $this$specializeEqualsCall_u24lambda_u2418.getContext().getIrBuiltIns().getBooleanType(), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, leftVal), ExpressionHelpersKt.irEqualsNull((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$specializeEqualsCall_u24lambda_u2418, rightVal)), equalsRight));
            } else {
                $this$specializeEqualsCall_u24lambda_u2418.unaryPlus(equalsRight);
            }
            irExpression = this_$iv$iv.doBuild();
        } else {
            irExpression = JvmInlineClassLowering.specializeEqualsCall$equals(rightIsUnboxed, $this$specializeEqualsCall, this, left, right);
        }
        return irExpression;
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (InlineClassAbiKt.isInlineClassFieldGetter(expression2.getSymbol().getOwner())) {
            IrExpression irExpression2 = expression2.getDispatchReceiver();
            Intrinsics.checkNotNull((Object)irExpression2);
            IrElement arg = irExpression2.transform((IrElementTransformer)this, (Object)null);
            IrValueParameter irValueParameter = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            irExpression = JvmInlineClassLowering.coerceInlineClasses$default(this, (IrExpression)arg, irValueParameter.getType(), expression2.getType(), false, 8, null);
        } else if (this.isEqEqCallOnInlineClass(expression2) || this.isEqualsMethodCallOnInlineClass(expression2)) {
            this.transformChildrenVoid(expression2);
            IrExpression leftOp = null;
            IrExpression rightOp = null;
            if (this.isEqEqCallOnInlineClass(expression2)) {
                IrExpression irExpression3 = expression2.getValueArgument(0);
                Intrinsics.checkNotNull((Object)irExpression3);
                leftOp = irExpression3;
                IrExpression irExpression4 = expression2.getValueArgument(1);
                Intrinsics.checkNotNull((Object)irExpression4);
                rightOp = irExpression4;
            } else {
                IrExpression irExpression5 = expression2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)irExpression5);
                leftOp = irExpression5;
                IrExpression irExpression6 = expression2.getValueArgument(0);
                Intrinsics.checkNotNull((Object)irExpression6);
                rightOp = irExpression6;
            }
            BackendContext backendContext = this.getContext();
            ScopeWithIr scopeWithIr = this.getCurrentScope();
            Intrinsics.checkNotNull((Object)scopeWithIr);
            irExpression = this.specializeEqualsCall(LowerUtilsKt.createIrBuilder(backendContext, scopeWithIr.getScope().getScopeOwnerSymbol(), expression2.getStartOffset(), expression2.getEndOffset()), leftOp, rightOp);
            if (irExpression == null) {
                irExpression = expression2;
            }
        } else {
            irExpression = super.visitCall(expression2);
        }
        return irExpression;
    }

    private final boolean isEqualsMethodCallOnInlineClass(IrCall $this$isEqualsMethodCallOnInlineClass) {
        IrClass receiverClass;
        if (!IrUtilsKt.isEquals($this$isEqualsMethodCallOnInlineClass.getSymbol().getOwner())) {
            return false;
        }
        Object object = $this$isEqualsMethodCallOnInlineClass.getDispatchReceiver();
        IrClass irClass = receiverClass = object != null && (object = ((IrExpression)object).getType()) != null && (object = IrTypesKt.getClassOrNull((IrType)object)) != null ? (IrClass)object.getOwner() : null;
        return irClass != null ? this.getCanUseSpecializedEqMethod(irClass) : false;
    }

    private final boolean isEqEqCallOnInlineClass(IrCall $this$isEqEqCallOnInlineClass) {
        IrClass leftOperandClass;
        if (!Intrinsics.areEqual((Object)$this$isEqEqCallOnInlineClass.getSymbol(), (Object)this.getContext().getIrBuiltIns().getEqeqSymbol())) {
            return false;
        }
        Object object = $this$isEqEqCallOnInlineClass.getValueArgument(0);
        IrClass irClass = leftOperandClass = object != null && (object = ((IrExpression)object).getType()) != null && (object = IrTypesKt.getClassOrNull((IrType)object)) != null ? (IrClass)object.getOwner() : null;
        return irClass != null ? this.getCanUseSpecializedEqMethod(irClass) : false;
    }

    private final boolean getCanUseSpecializedEqMethod(IrClass $this$canUseSpecializedEqMethod) {
        if (!IrDeclarationsKt.isSingleFieldValueClass($this$canUseSpecializedEqMethod)) {
            return false;
        }
        return !IrTypePredicatesKt.isClassWithFqName($this$canUseSpecializedEqMethod, StandardNames.RESULT_FQ_NAME) || this.getContext().getConfig().getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_4) >= 0;
    }

    @Override
    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrDeclarationParent parent2 = field.getParent();
        if (Intrinsics.areEqual((Object)field.getOrigin(), (Object)IrDeclarationOrigin.Companion.getPROPERTY_BACKING_FIELD()) && parent2 instanceof IrClass && IrDeclarationsKt.isSingleFieldValueClass((IrClass)parent2) && Intrinsics.areEqual((Object)field.getName(), (Object)InlineClassAbiKt.getInlineClassFieldName((IrClass)parent2))) {
            IrExpression irExpression = expression2.getReceiver();
            Intrinsics.checkNotNull((Object)irExpression);
            IrElement receiver = irExpression.transform((IrElementTransformer)this, (Object)null);
            return JvmInlineClassLowering.coerceInlineClasses$default(this, (IrExpression)receiver, IrTypesKt.makeNotNull(((IrExpression)receiver).getType()), field.getType(), false, 8, null);
        }
        return super.visitGetField(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrValueDeclaration irValueDeclaration = this.valueMap.get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration it = irValueDeclaration;
            boolean bl = false;
            return BuildersKt.IrGetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), expression2.getOrigin());
        }
        return super.visitGetValue(expression2);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrValueDeclaration irValueDeclaration = this.valueMap.get(expression2.getSymbol());
        if (irValueDeclaration != null) {
            IrValueDeclaration it = irValueDeclaration;
            boolean bl = false;
            return BuildersKt.IrSetValueImpl(expression2.getStartOffset(), expression2.getEndOffset(), it.getType(), it.getSymbol(), (IrExpression)expression2.getValue().transform((IrElementTransformer)this, (Object)null), expression2.getOrigin());
        }
        return super.visitSetValue(expression2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildPrimaryInlineClassConstructor(IrClass valueClass, IrConstructor irConstructor) {
        void $this$buildPrimaryInlineClassConstructor_u24lambda_u2427;
        void this_$iv$iv;
        Iterator $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$buildPrimaryInlineClassConstructor_u24lambda_u2424_u24lambda_u2423;
        void this_$iv$iv$iv;
        void startOffset$iv$iv;
        void $this$irBlockBody$iv$iv;
        Iterator $this$addConstructor$iv = valueClass;
        boolean $i$f$addConstructor = false;
        Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv$iv22 = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2425$iv = $this$buildConstructor_u24lambda_u2424$iv$iv;
        boolean bl = false;
        IrFunctionBuilder $this$buildPrimaryInlineClassConstructor_u24lambda_u2421 = $this$addConstructor_u24lambda_u2425$iv;
        boolean $i$a$-addConstructor-JvmInlineClassLowering$buildPrimaryInlineClassConstructor$22 = false;
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2421.updateFrom(irConstructor);
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2421.setVisibility(DescriptorVisibilities.PRIVATE);
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2421.setOrigin(JvmLoweredDeclarationOrigin.INSTANCE.getSYNTHETIC_INLINE_CLASS_MEMBER());
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2421.setReturnType(irConstructor.getReturnType());
        $this$addConstructor_u24lambda_u2425$iv.setReturnType(IrUtilsKt.getDefaultType((IrClass)((Object)$this$addConstructor$iv)));
        Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2424$iv$iv);
        boolean bl2 = false;
        $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
        ((IrDeclarationBase)constructor$iv).setParent((IrDeclarationParent)((Object)$this$addConstructor$iv));
        Iterator $this$buildPrimaryInlineClassConstructor_u24lambda_u2424 = $this$addConstructor$iv = $this$buildConstructor$iv$iv;
        boolean bl3 = false;
        Iterable $this$forEach$iv = irConstructor.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrValueParameter it = (IrValueParameter)element$iv;
            boolean bl4 = false;
            it.setDefaultValue(null);
        }
        IrUtilsKt.copyParameterDeclarationsFrom((IrFunction)((Object)$this$buildPrimaryInlineClassConstructor_u24lambda_u2424), irConstructor);
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2424.setAnnotations(irConstructor.getAnnotations());
        IrGeneratorWithScope $this$irBlockBody$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)((IrConstructor)((Object)$this$buildPrimaryInlineClassConstructor_u24lambda_u2424)).getSymbol(), 0, 0, 6, null);
        boolean $i$f$irBlockBody22 = false;
        IrGeneratorWithScope $i$a$-run-DeclarationBuildersKt$buildConstructor$2$iv$iv22 = $this$irBlockBody$iv;
        int element$iv = ((IrElement)((Object)$this$buildPrimaryInlineClassConstructor_u24lambda_u2424)).getStartOffset();
        int endOffset$iv$iv22 = ((IrElement)((Object)$this$buildPrimaryInlineClassConstructor_u24lambda_u2424)).getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder $i$a$-addConstructor-JvmInlineClassLowering$buildPrimaryInlineClassConstructor$22 = new IrBlockBodyBuilder($this$irBlockBody$iv$iv.getContext(), $this$irBlockBody$iv$iv.getScope(), (int)startOffset$iv$iv, endOffset$iv$iv22);
        boolean $i$f$blockBody = false;
        void var14_39 = this_$iv$iv$iv;
        Iterator iterator2 = $this$buildPrimaryInlineClassConstructor_u24lambda_u2424;
        boolean bl5 = false;
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2424_u24lambda_u2423.unaryPlus(ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2424_u24lambda_u2423, (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors((IrClass)$this$buildPrimaryInlineClassConstructor_u24lambda_u2424_u24lambda_u2423.getContext().getIrBuiltIns().getAnyClass().getOwner()))));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2424_u24lambda_u2423;
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2424_u24lambda_u2423;
        IrValueParameter irValueParameter = valueClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2424_u24lambda_u2423.unaryPlus(ExpressionHelpersKt.irSetField$default(irBuilderWithScope, ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter), InlineClassesKt.getInlineClassBackingField(valueClass), ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2424_u24lambda_u2423, ((IrFunction)((Object)$this$buildPrimaryInlineClassConstructor_u24lambda_u2424)).getValueParameters().get(0)), null, 8, null));
        ((IrFunction)((Object)iterator2)).setBody(this_$iv$iv$iv.doBuild());
        IrSimpleFunction irSimpleFunction = this.getContext().getInlineClassReplacements().getReplacementFunction(irConstructor);
        Intrinsics.checkNotNull((Object)irSimpleFunction);
        IrSimpleFunction function2 = irSimpleFunction;
        Iterable $this$filterIsInstance$iv = valueClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable $i$f$irBlockBody22 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrAnonymousInitializer)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator endOffset$iv$iv22 = $this$filterNotTo$iv$iv.iterator();
        while (endOffset$iv$iv22.hasNext()) {
            Object element$iv$iv = endOffset$iv$iv22.next();
            IrAnonymousInitializer it = (IrAnonymousInitializer)element$iv$iv;
            boolean bl6 = false;
            if (it.isStatic()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List initBlocks = (List)destination$iv$iv;
        Iterable $this$forEach$iv2 = function2.getValueParameters();
        boolean $i$f$forEach2 = false;
        for (Object element$iv2 : $this$forEach$iv2) {
            IrValueParameter it = (IrValueParameter)element$iv2;
            boolean bl7 = false;
            this.transformChildrenVoid(it);
        }
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody3 = false;
        IrBlockBodyBuilder it = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody2 = false;
        void element$iv$iv = this_$iv$iv;
        IrSimpleFunction irSimpleFunction2 = function2;
        boolean bl8 = false;
        IrValueParameter argument = function2.getValueParameters().get(0);
        IrVariable thisValue = ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)$this$buildPrimaryInlineClassConstructor_u24lambda_u2427, this.coerceInlineClasses(ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2427, argument), argument.getType(), function2.getReturnType(), true), null, null, false, null, 30, null);
        IrValueParameter irValueParameter2 = valueClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter2);
        this.valueMap.put(irValueParameter2.getSymbol(), thisValue);
        for (IrAnonymousInitializer initBlock : initBlocks) {
            for (IrStatement stmt : initBlock.getBody().getStatements()) {
                $this$buildPrimaryInlineClassConstructor_u24lambda_u2427.unaryPlus((IrStatement)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)IrElementsKt.transformStatement(stmt, this), function2));
            }
        }
        $this$buildPrimaryInlineClassConstructor_u24lambda_u2427.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2427, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildPrimaryInlineClassConstructor_u24lambda_u2427, thisValue)));
        irSimpleFunction2.setBody(this_$iv$iv.doBuild());
        valueClass.getDeclarations().removeAll(initBlocks);
        ((Collection)valueClass.getDeclarations()).add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildBoxFunction(IrClass valueClass) {
        void $this$buildBoxFunction_u24lambda_u2429_u24lambda_u2428;
        IrConstructorCall irConstructorCall;
        IrSimpleFunction function2 = (IrSimpleFunction)this.getContext().getInlineClassReplacements().getGetBoxFunction().invoke((Object)valueClass);
        DeclarationIrBuilder $this$buildBoxFunction_u24lambda_u2429 = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
        boolean bl = false;
        IrBuilderWithScope irBuilderWithScope = $this$buildBoxFunction_u24lambda_u2429;
        IrBuilderWithScope irBuilderWithScope2 = $this$buildBoxFunction_u24lambda_u2429;
        IrConstructor irConstructor = IrUtilsKt.getPrimaryConstructor(valueClass);
        Intrinsics.checkNotNull((Object)irConstructor);
        IrConstructorCall irConstructorCall2 = irConstructorCall = ExpressionHelpersKt.irCall(irBuilderWithScope2, irConstructor.getSymbol());
        IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl2 = false;
        IrUtilsKt.passTypeArgumentsFrom$default((IrFunctionAccessExpression)$this$buildBoxFunction_u24lambda_u2429_u24lambda_u2428, function2, 0, 2, null);
        $this$buildBoxFunction_u24lambda_u2429_u24lambda_u2428.putValueArgument(0, ExpressionHelpersKt.irGet($this$buildBoxFunction_u24lambda_u2429, function2.getValueParameters().get(0)));
        Unit unit = Unit.INSTANCE;
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope3, irConstructorCall));
        ((Collection)valueClass.getDeclarations()).add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildUnboxFunction(IrClass irClass) {
        void $this$buildUnboxFunction_u24lambda_u2430;
        void this_$iv$iv;
        IrSimpleFunction function2 = (IrSimpleFunction)this.getContext().getInlineClassReplacements().getGetUnboxFunction().invoke((Object)irClass);
        IrField field = InlineClassesKt.getInlineClassBackingField(irClass);
        IrBuilderWithScope $this$irBlockBody_u24default$iv = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)function2.getSymbol(), 0, 0, 6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var10_10 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl = false;
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildUnboxFunction_u24lambda_u2430;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        IrGetValueImpl thisVal = ExpressionHelpersKt.irGet(irBuilderWithScope, irValueParameter);
        $this$buildUnboxFunction_u24lambda_u2430.unaryPlus(ExpressionHelpersKt.irReturn((IrBuilderWithScope)$this$buildUnboxFunction_u24lambda_u2430, ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)$this$buildUnboxFunction_u24lambda_u2430, thisVal, field, null, 4, null)));
        irSimpleFunction.setBody(this_$iv$iv.doBuild());
        ((Collection)irClass.getDeclarations()).add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildSpecializedEqualsMethodIfNeeded(IrClass valueClass) {
        IrExpression irExpression;
        void $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435;
        IrElementBase it;
        IrSimpleFunction function2 = this.getContext().getInlineClassReplacements().getSpecializedEqualsMethod(valueClass, this.getContext().getIrBuiltIns());
        if (function2.getBody() != null) {
            return;
        }
        IrValueParameter left = function2.getValueParameters().get(0);
        IrValueParameter right = function2.getValueParameters().get(1);
        IrType type2 = InlineClassAbiKt.unboxInlineClass(left.getType());
        Sequence<IrSimpleFunction> $this$single$iv = IrUtilsKt.getFunctions(valueClass);
        boolean $i$f$single22 = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it = (IrSimpleFunction)element$iv;
            boolean bl2 = false;
            if (!IrUtilsKt.isEquals(it)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction untypedEquals = single$iv;
        DeclarationIrBuilder $i$f$single22 = LowerUtilsKt.createIrBuilder$default(this.getContext(), (IrSymbol)valueClass.getSymbol(), 0, 0, 6, null);
        IrSimpleFunction irSimpleFunction = function2;
        boolean bl = false;
        JvmBackendContext context2 = this.getContext();
        IrSimpleType underlyingType = InlineClassesKt.getInlineClassUnderlyingType(valueClass);
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435;
        if (Intrinsics.areEqual((Object)untypedEquals.getOrigin(), (Object)IrDeclarationOrigin.Companion.getDEFINED())) {
            void $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435_u24lambda_u2433;
            IrSimpleFunction boxFunction = (IrSimpleFunction)context2.getInlineClassReplacements().getGetBoxFunction().invoke((Object)valueClass);
            IrElementBase bl2 = it = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435, untypedEquals);
            IrBuilderWithScope irBuilderWithScope2 = irBuilderWithScope;
            boolean bl3 = false;
            $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435_u24lambda_u2433.setDispatchReceiver(JvmInlineClassLowering.buildSpecializedEqualsMethodIfNeeded$lambda$35$irBox((DeclarationIrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435, boxFunction, JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435, left), left.getType(), underlyingType, false, 8, null)));
            $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435_u24lambda_u2433.putValueArgument(0, JvmInlineClassLowering.buildSpecializedEqualsMethodIfNeeded$lambda$35$irBox((DeclarationIrBuilder)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435, boxFunction, JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435, right), right.getType(), underlyingType, false, 8, null)));
            irBuilderWithScope = irBuilderWithScope2;
            irExpression = (IrExpression)it;
        } else {
            IrClass underlyingClass;
            IrClass irClass = underlyingClass = IrTypesKt.getClass(underlyingType);
            boolean bl4 = irClass != null ? IrDeclarationsKt.isSingleFieldValueClass(irClass) : false;
            if (bl4 && !IrTypeUtilsKt.isNullable(underlyingType)) {
                void $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435_u24lambda_u2434;
                IrFunctionAccessExpression irFunctionAccessExpression;
                IrSimpleFunction underlyingClassEq = context2.getInlineClassReplacements().getSpecializedEqualsMethod(underlyingClass, context2.getIrBuiltIns());
                IrFunctionAccessExpression bl3 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435, underlyingClassEq);
                IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope;
                boolean bl5 = false;
                $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435_u24lambda_u2434.putValueArgument(0, JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435, left), left.getType(), underlyingType, false, 8, null));
                $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435_u24lambda_u2434.putValueArgument(1, JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435, right), right.getType(), underlyingType, false, 8, null));
                irBuilderWithScope = irBuilderWithScope3;
                irExpression = irFunctionAccessExpression;
            } else {
                irExpression = ExpressionHelpersKt.irEquals$default((IrBuilderWithScope)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435, JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435, left), left.getType(), type2, false, 8, null), JvmInlineClassLowering.coerceInlineClasses$default(this, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435, right), right.getType(), type2, false, 8, null), null, 4, null);
            }
        }
        irSimpleFunction.setBody(ExpressionHelpersKt.irExprBody(irBuilderWithScope, irExpression));
        ((Collection)valueClass.getDeclarations()).add(function2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List visitClassNew$lambda$5(JvmInlineClassLowering this$0, IrDeclaration memberDeclaration) {
        List<IrDeclaration> list;
        Intrinsics.checkNotNullParameter((Object)memberDeclaration, (String)"memberDeclaration");
        if (memberDeclaration instanceof IrFunction) {
            void this_$iv;
            IrElementTransformerVoidWithContext irElementTransformerVoidWithContext = this$0;
            IrSymbolOwner declaration$iv = memberDeclaration;
            boolean $i$f$withinScope = false;
            IrElementTransformerVoidWithContext.access$unsafeEnterScope((IrElementTransformerVoidWithContext)this_$iv, declaration$iv);
            boolean bl = false;
            List<IrDeclaration> result$iv = this$0.transformFunctionFlat((IrFunction)memberDeclaration);
            IrElementTransformerVoidWithContext.access$unsafeLeaveScope((IrElementTransformerVoidWithContext)this_$iv);
            list = result$iv;
        } else {
            memberDeclaration.accept(this$0, null);
            list = null;
        }
        return list;
    }

    private static final boolean handleSpecificNewClass$lambda$6(IrConstructor $irConstructor, IrDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$irConstructor) || it instanceof IrFunction && InlineClassAbiKt.isInlineClassFieldGetter((IrFunction)it) && !((IrFunction)it).getVisibility().isPublicAPI();
    }

    private static final boolean handleSpecificNewClass$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * Unable to fully structure code
     */
    private static final IrExpression specializeEqualsCall$equals(boolean rightIsUnboxed, IrBuilderWithScope $this_specializeEqualsCall, JvmInlineClassLowering this$0, IrExpression left, IrExpression right) {
        if (ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isUnsigned(left.getType()) && ksp.org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isUnsigned(right.getType()) && rightIsUnboxed) {
            return ExpressionHelpersKt.irEquals$default($this_specializeEqualsCall, this$0.coerceToUnboxed(left), this$0.coerceToUnboxed(right), null, 4, null);
        }
        v0 = IrTypesKt.getClassOrNull(left.getType());
        Intrinsics.checkNotNull((Object)v0);
        leftOperandClass = (IrClass)v0.getOwner();
        if (!rightIsUnboxed) ** GOTO lbl-1000
        v1 = IrTypesKt.getClassOrNull(right.getType());
        Intrinsics.checkNotNull((Object)v1);
        if (Intrinsics.areEqual((Object)leftOperandClass, (Object)v1.getOwner())) {
            v2 = this$0.getContext().getInlineClassReplacements().getSpecializedEqualsMethod(leftOperandClass, $this_specializeEqualsCall.getContext().getIrBuiltIns());
        } else lbl-1000:
        // 2 sources

        {
            $this$single$iv = IrUtilsKt.getFunctions(leftOperandClass);
            $i$f$single = false;
            single$iv = null;
            found$iv = false;
            for (E element$iv : $this$single$iv) {
                it = (IrSimpleFunction)element$iv;
                $i$a$-single-JvmInlineClassLowering$specializeEqualsCall$equals$equalsMethod$equals$1 = false;
                if (!(Intrinsics.areEqual((Object)it.getName().asString(), (Object)"equals") != false && ((Collection)it.getOverriddenSymbols()).isEmpty() == false != false)) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            equals = single$iv;
            v3 = this$0.getContext().getInlineClassReplacements().getReplacementFunction(equals);
            v2 = v3;
            Intrinsics.checkNotNull((Object)v3);
        }
        equalsMethod = v2;
        $this$specializeEqualsCall_u24equals_u24lambda_u2417 = var7_14 = ExpressionHelpersKt.irCall($this_specializeEqualsCall, equalsMethod);
        $i$a$-apply-JvmInlineClassLowering$specializeEqualsCall$equals$1 = false;
        $this$specializeEqualsCall_u24equals_u24lambda_u2417.putValueArgument(0, left);
        $this$specializeEqualsCall_u24equals_u24lambda_u2417.putValueArgument(1, right);
        return var7_14;
    }

    private static final IrFunctionAccessExpression buildSpecializedEqualsMethodIfNeeded$lambda$35$irBox(DeclarationIrBuilder $this_run, IrSimpleFunction boxFunction, IrExpression expr) {
        IrFunctionAccessExpression irFunctionAccessExpression;
        IrFunctionAccessExpression $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435_u24irBox_u24lambda_u2432 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)$this_run, boxFunction);
        boolean bl = false;
        $this$buildSpecializedEqualsMethodIfNeeded_u24lambda_u2435_u24irBox_u24lambda_u2432.putValueArgument(0, expr);
        return irFunctionAccessExpression;
    }
}

