/*
 * Decompiled with CFR 0.152.
 */
package ksp.it.unimi.dsi.fastutil.doubles;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import ksp.it.unimi.dsi.fastutil.doubles.Double2ObjectFunction;
import ksp.it.unimi.dsi.fastutil.doubles.DoubleSet;
import ksp.it.unimi.dsi.fastutil.objects.ObjectCollection;
import ksp.it.unimi.dsi.fastutil.objects.ObjectIterator;
import ksp.it.unimi.dsi.fastutil.objects.ObjectSet;

public interface Double2ObjectMap<V>
extends Double2ObjectFunction<V>,
Map<Double, V> {
    @Override
    public int size();

    @Override
    default public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void defaultReturnValue(V var1);

    @Override
    public V defaultReturnValue();

    public ObjectSet<Entry<V>> double2ObjectEntrySet();

    @Override
    @Deprecated
    default public ObjectSet<Map.Entry<Double, V>> entrySet() {
        return this.double2ObjectEntrySet();
    }

    @Override
    @Deprecated
    default public V put(Double key, V value2) {
        return Double2ObjectFunction.super.put(key, value2);
    }

    @Override
    @Deprecated
    default public V get(Object key) {
        return Double2ObjectFunction.super.get(key);
    }

    @Override
    @Deprecated
    default public V remove(Object key) {
        return Double2ObjectFunction.super.remove(key);
    }

    public DoubleSet keySet();

    @Override
    public ObjectCollection<V> values();

    @Override
    public boolean containsKey(double var1);

    @Override
    @Deprecated
    default public boolean containsKey(Object key) {
        return Double2ObjectFunction.super.containsKey(key);
    }

    @Override
    default public void forEach(BiConsumer<? super Double, ? super V> consumer) {
        ObjectSet<Entry<V>> entrySet = this.double2ObjectEntrySet();
        Consumer<Entry> wrappingConsumer = entry -> consumer.accept((Double)entry.getDoubleKey(), (Object)entry.getValue());
        if (entrySet instanceof FastEntrySet) {
            ((FastEntrySet)entrySet).fastForEach(wrappingConsumer);
        } else {
            entrySet.forEach(wrappingConsumer);
        }
    }

    @Override
    default public V getOrDefault(double key, V defaultValue) {
        Object v = this.get(key);
        return v != this.defaultReturnValue() || this.containsKey(key) ? v : defaultValue;
    }

    @Override
    default public V putIfAbsent(double key, V value2) {
        V drv;
        Object v = this.get(key);
        if (v != (drv = this.defaultReturnValue()) || this.containsKey(key)) {
            return v;
        }
        this.put(key, value2);
        return drv;
    }

    default public boolean remove(double key, Object value2) {
        Object curValue = this.get(key);
        if (!Objects.equals(curValue, value2) || curValue == this.defaultReturnValue() && !this.containsKey(key)) {
            return false;
        }
        this.remove(key);
        return true;
    }

    @Override
    default public boolean replace(double key, V oldValue, V newValue) {
        Object curValue = this.get(key);
        if (!Objects.equals(curValue, oldValue) || curValue == this.defaultReturnValue() && !this.containsKey(key)) {
            return false;
        }
        this.put(key, newValue);
        return true;
    }

    @Override
    default public V replace(double key, V value2) {
        return this.containsKey(key) ? this.put(key, value2) : this.defaultReturnValue();
    }

    default public V computeIfAbsent(double key, DoubleFunction<? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Object v = this.get(key);
        if (v != this.defaultReturnValue() || this.containsKey(key)) {
            return v;
        }
        V newValue = mappingFunction.apply(key);
        this.put(key, newValue);
        return newValue;
    }

    default public V computeIfAbsent(double key, Double2ObjectFunction<? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Object v = this.get(key);
        V drv = this.defaultReturnValue();
        if (v != drv || this.containsKey(key)) {
            return v;
        }
        if (!mappingFunction.containsKey(key)) {
            return drv;
        }
        V newValue = mappingFunction.get(key);
        this.put(key, newValue);
        return newValue;
    }

    @Deprecated
    default public V computeIfAbsentPartial(double key, Double2ObjectFunction<? extends V> mappingFunction) {
        return this.computeIfAbsent(key, mappingFunction);
    }

    @Override
    default public V computeIfPresent(double key, BiFunction<? super Double, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Object oldValue = this.get(key);
        V drv = this.defaultReturnValue();
        if (oldValue == drv && !this.containsKey(key)) {
            return drv;
        }
        V newValue = remappingFunction.apply(key, oldValue);
        if (newValue == null) {
            this.remove(key);
            return drv;
        }
        this.put(key, newValue);
        return newValue;
    }

    @Override
    default public V compute(double key, BiFunction<? super Double, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Object oldValue = this.get(key);
        V drv = this.defaultReturnValue();
        boolean contained = oldValue != drv || this.containsKey(key);
        V newValue = remappingFunction.apply(key, contained ? oldValue : null);
        if (newValue == null) {
            if (contained) {
                this.remove(key);
            }
            return drv;
        }
        this.put(key, newValue);
        return newValue;
    }

    @Override
    default public V merge(double key, V value2, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        V newValue;
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value2);
        Object oldValue = this.get(key);
        V drv = this.defaultReturnValue();
        if (oldValue != drv || this.containsKey(key)) {
            V mergedValue = remappingFunction.apply(oldValue, value2);
            if (mergedValue == null) {
                this.remove(key);
                return drv;
            }
            newValue = mergedValue;
        } else {
            newValue = value2;
        }
        this.put(key, newValue);
        return newValue;
    }

    @Override
    @Deprecated
    default public V getOrDefault(Object key, V defaultValue) {
        return Map.super.getOrDefault(key, defaultValue);
    }

    @Override
    @Deprecated
    default public V putIfAbsent(Double key, V value2) {
        return Map.super.putIfAbsent(key, value2);
    }

    @Override
    @Deprecated
    default public boolean remove(Object key, Object value2) {
        return Map.super.remove(key, value2);
    }

    @Override
    @Deprecated
    default public boolean replace(Double key, V oldValue, V newValue) {
        return Map.super.replace(key, oldValue, newValue);
    }

    @Override
    @Deprecated
    default public V replace(Double key, V value2) {
        return Map.super.replace(key, value2);
    }

    @Override
    @Deprecated
    default public V computeIfAbsent(Double key, Function<? super Double, ? extends V> mappingFunction) {
        return Map.super.computeIfAbsent(key, mappingFunction);
    }

    @Override
    @Deprecated
    default public V computeIfPresent(Double key, BiFunction<? super Double, ? super V, ? extends V> remappingFunction) {
        return Map.super.computeIfPresent(key, remappingFunction);
    }

    @Override
    @Deprecated
    default public V compute(Double key, BiFunction<? super Double, ? super V, ? extends V> remappingFunction) {
        return Map.super.compute(key, remappingFunction);
    }

    @Override
    @Deprecated
    default public V merge(Double key, V value2, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return Map.super.merge(key, value2, remappingFunction);
    }

    public static interface FastEntrySet<V>
    extends ObjectSet<Entry<V>> {
        public ObjectIterator<Entry<V>> fastIterator();

        default public void fastForEach(Consumer<? super Entry<V>> consumer) {
            this.forEach(consumer);
        }
    }

    public static interface Entry<V>
    extends Map.Entry<Double, V> {
        public double getDoubleKey();

        @Override
        @Deprecated
        default public Double getKey() {
            return this.getDoubleKey();
        }
    }
}

