/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectByteBufferPool {
    public static final DirectByteBufferPool DEFAULT_POOL = new DirectByteBufferPool();
    private static final int MIN_SIZE = 2048;
    private static final int MAX_POOL_SIZE = 32;
    private final ConcurrentSkipListMap<Integer, ByteBuffer> pool = new ConcurrentSkipListMap();
    private final AtomicInteger count = new AtomicInteger();

    @NotNull
    public ByteBuffer allocate(int requiredSize) {
        ByteBuffer result2;
        Map.Entry<Integer, ByteBuffer> entry;
        int size = DirectByteBufferPool.roundUpInt(requiredSize, 2048);
        while ((entry = this.pool.ceilingEntry(size)) != null && !this.pool.remove(entry.getKey(), entry.getValue())) {
        }
        if (entry == null) {
            result2 = ByteBuffer.allocateDirect(size);
        } else {
            this.count.decrementAndGet();
            result2 = entry.getValue();
        }
        result2.limit(requiredSize);
        ByteBuffer byteBuffer = result2;
        if (byteBuffer == null) {
            DirectByteBufferPool.$$$reportNull$$$0(0);
        }
        return byteBuffer;
    }

    public void release(@NotNull ByteBuffer buffer) {
        if (buffer == null) {
            DirectByteBufferPool.$$$reportNull$$$0(1);
        }
        if (buffer.isReadOnly()) {
            return;
        }
        buffer.rewind();
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (this.count.get() < 32 && this.pool.putIfAbsent(buffer.capacity(), buffer) == null) {
            this.count.incrementAndGet();
        }
    }

    private static int roundUpInt(int x, int blockSizePowerOf2) {
        return x + blockSizePowerOf2 - 1 & -blockSizePowerOf2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/io/DirectByteBufferPool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "allocate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/io/DirectByteBufferPool";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

