/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import ksp.com.intellij.util.io.ByteBufferUtil;
import ksp.com.intellij.util.io.DirectByteBufferAllocator;
import ksp.com.intellij.util.io.PagedFileStorage;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class DirectBufferWrapper {
    @NotNull
    private static final ByteOrder ourNativeByteOrder = ByteOrder.nativeOrder();
    @NotNull
    private final PagedFileStorage myFile;
    private final long myPosition;
    private final int myLength;
    private final boolean myReadOnly;
    private volatile ByteBuffer myBuffer;
    private volatile boolean myDirty;
    private volatile boolean myReleased;

    /*
     * WARNING - void declaration
     */
    DirectBufferWrapper(@NotNull PagedFileStorage file2, long offset, int length, boolean bl) throws IOException {
        void readOnly;
        if (file2 == null) {
            DirectBufferWrapper.$$$reportNull$$$0(0);
        }
        this.myReleased = false;
        this.myFile = file2;
        this.myPosition = offset;
        this.myLength = length;
        this.myReadOnly = readOnly;
        this.myBuffer = DirectByteBufferAllocator.allocate(() -> this.create());
    }

    private void markDirty() throws IOException {
        if (this.myReadOnly) {
            throw new IOException("Read-only byte buffer can't be modified. File: " + this.myFile);
        }
        if (!this.myDirty) {
            this.myDirty = true;
            this.myFile.markDirty();
        }
    }

    boolean isDirty() {
        return this.myDirty;
    }

    public ByteBuffer copy() {
        try {
            return DirectByteBufferAllocator.allocate(() -> {
                ByteBuffer duplicate = this.myBuffer.duplicate();
                duplicate.order(this.myBuffer.order());
                return duplicate;
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte get(int index) {
        return this.myBuffer.get(index);
    }

    public long getLong(int index) {
        return this.myBuffer.getLong(index);
    }

    public ByteBuffer putLong(int index, long value2) throws IOException {
        this.markDirty();
        return this.myBuffer.putLong(index, value2);
    }

    public int getInt(int index) {
        return this.myBuffer.getInt(index);
    }

    public ByteBuffer putInt(int index, int value2) throws IOException {
        this.markDirty();
        return this.myBuffer.putInt(index, value2);
    }

    public void position(int newPosition) {
        this.myBuffer.position(newPosition);
    }

    public int position() {
        return this.myBuffer.position();
    }

    public void put(ByteBuffer src) throws IOException {
        this.markDirty();
        this.myBuffer.put(src);
    }

    public void put(int index, byte b) throws IOException {
        this.markDirty();
        this.myBuffer.put(index, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readToArray(byte[] dst, int o, int page_offset, int page_len) throws IllegalArgumentException {
        ByteBuffer byteBuffer = this.myBuffer;
        synchronized (byteBuffer) {
            this.myBuffer.position(page_offset);
            this.myBuffer.get(dst, o, page_len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFromArray(byte[] src, int o, int page_offset, int page_len) throws IOException, IllegalArgumentException {
        this.markDirty();
        ByteBuffer byteBuffer = this.myBuffer;
        synchronized (byteBuffer) {
            this.myBuffer.position(page_offset);
            this.myBuffer.put(src, o, page_len);
        }
    }

    private ByteBuffer create() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.myLength);
        return this.myFile.useChannel(ch -> {
            ch.read(buffer, this.myPosition);
            return buffer;
        }, this.myReadOnly);
    }

    void release() throws IOException {
        if (this.isDirty()) {
            this.force();
        }
        if (this.myBuffer != null) {
            ByteBufferUtil.cleanBuffer(this.myBuffer);
            this.myBuffer = null;
            this.myReleased = true;
        }
    }

    boolean isReleased() {
        return this.myReleased;
    }

    void force() throws IOException {
        assert (!this.myReadOnly);
        if (!this.isReleased() && this.isDirty()) {
            ByteBuffer buffer = this.myBuffer;
            buffer.rewind();
            this.myFile.useChannel(ch -> {
                ch.write(buffer, this.myPosition);
                return null;
            }, this.myReadOnly);
            this.myDirty = false;
        }
    }

    int getLength() {
        return this.myLength;
    }

    public String toString() {
        return "Buffer for " + this.myFile + ", offset:" + this.myPosition + ", size: " + this.myLength;
    }

    public void useNativeByteOrder() {
        if (this.myBuffer.order() != ourNativeByteOrder) {
            this.myBuffer.order(ourNativeByteOrder);
        }
    }

    public static DirectBufferWrapper readWriteDirect(PagedFileStorage file2, long offset, int length) throws IOException {
        return new DirectBufferWrapper(file2, offset, length, false);
    }

    public static DirectBufferWrapper readOnlyDirect(PagedFileStorage file2, long offset, int length) throws IOException {
        return new DirectBufferWrapper(file2, offset, length, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "ksp/com/intellij/util/io/DirectBufferWrapper", "<init>"));
    }
}

