/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.expressions.FirCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import ksp.org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import ksp.org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker;", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "<init>", "()V", "isApplicable", "", "subjectType", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "computeMissingCases", "", "whenExpression", "Lksp/org/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "destination", "", "Lksp/org/jetbrains/kotlin/diagnostics/WhenMissingCase;", "isNullBranchMissing", "Flags", "ConditionChecker", "resolve"})
final class WhenOnNullableExhaustivenessChecker
extends WhenExhaustivenessChecker {
    @NotNull
    public static final WhenOnNullableExhaustivenessChecker INSTANCE = new WhenOnNullableExhaustivenessChecker();

    private WhenOnNullableExhaustivenessChecker() {
        super(null);
    }

    @Override
    public boolean isApplicable(@NotNull ConeKotlinType subjectType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return ConeTypeUtilsKt.isNullable(subjectType);
    }

    @Override
    public void computeMissingCases(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session, @NotNull Collection<WhenMissingCase> destination) {
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        if (this.isNullBranchMissing(whenExpression)) {
            destination.add(WhenMissingCase.NullIsMissing.INSTANCE);
        }
    }

    public final boolean isNullBranchMissing(@NotNull FirWhenExpression whenExpression) {
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        Flags flags = new Flags();
        whenExpression.accept(ConditionChecker.INSTANCE, flags);
        return !flags.getContainsNull();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker$ConditionChecker;", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker$AbstractConditionChecker;", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker$Flags;", "<init>", "()V", "visitEqualityOperatorCall", "", "equalityOperatorCall", "Lksp/org/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "data", "visitTypeOperatorCall", "typeOperatorCall", "Lksp/org/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirWhenExhaustivenessTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker$ConditionChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,523:1\n43#2:524\n*S KotlinDebug\n*F\n+ 1 FirWhenExhaustivenessTransformer.kt\norg/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker$ConditionChecker\n*L\n248#1:524\n*E\n"})
    private static final class ConditionChecker
    extends WhenExhaustivenessChecker.AbstractConditionChecker<Flags> {
        @NotNull
        public static final ConditionChecker INSTANCE = new ConditionChecker();

        private ConditionChecker() {
        }

        @Override
        public void visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @NotNull Flags data) {
            Intrinsics.checkNotNullParameter((Object)equalityOperatorCall, (String)"equalityOperatorCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            FirCall $this$arguments$iv = equalityOperatorCall;
            boolean $i$f$getArguments = false;
            FirExpression argument = $this$arguments$iv.getArgumentList().getArguments().get(1);
            if (ConeBuiltinTypeUtilsKt.isNullableNothing(FirTypeUtilsKt.getResolvedType(argument))) {
                data.setContainsNull(true);
            }
        }

        @Override
        public void visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @NotNull Flags data) {
            Intrinsics.checkNotNullParameter((Object)typeOperatorCall, (String)"typeOperatorCall");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            if (ConeTypeUtilsKt.isNullable(FirTypeUtilsKt.getConeType(typeOperatorCall.getConversionTypeRef()))) {
                data.setContainsNull(true);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker$Flags;", "", "<init>", "()V", "containsNull", "", "getContainsNull", "()Z", "setContainsNull", "(Z)V", "resolve"})
    private static final class Flags {
        private boolean containsNull;

        public final boolean getContainsNull() {
            return this.containsNull;
        }

        public final void setContainsNull(boolean bl) {
            this.containsNull = bl;
        }
    }
}

