/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.scopes;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import ksp.org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import ksp.org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import ksp.org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import ksp.org.jetbrains.kotlin.fir.scopes.jvm.JvmMappedScope;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import ksp.org.jetbrains.kotlin.name.ClassId;
import ksp.org.jetbrains.kotlin.name.FqNameUnsafe;
import ksp.org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"wrapScopeWithJvmMapped", "Lksp/org/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "klass", "Lksp/org/jetbrains/kotlin/fir/declarations/FirClass;", "declaredMemberScope", "useSiteSession", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lksp/org/jetbrains/kotlin/fir/resolve/ScopeSession;", "memberRequiredPhase", "Lksp/org/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "java"})
public final class JvmMappedScopesKt {
    @NotNull
    public static final FirContainingNamesAwareScope wrapScopeWithJvmMapped(@NotNull FirClass klass, @NotNull FirContainingNamesAwareScope declaredMemberScope, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession, @Nullable FirResolvePhase memberRequiredPhase) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)declaredMemberScope, (String)"declaredMemberScope");
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        if (!(klass instanceof FirRegularClass)) {
            return declaredMemberScope;
        }
        ClassId classId = FirDeclarationUtilKt.getClassId(klass);
        FqNameUnsafe kotlinUnsafeFqName = classId.asSingleFqName().toUnsafe();
        ClassId classId2 = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(kotlinUnsafeFqName);
        if (classId2 == null) {
            return declaredMemberScope;
        }
        ClassId javaClassId = classId2;
        FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(useSiteSession);
        FirClassLikeSymbol<?> firClassLikeSymbol = symbolProvider.getClassLikeSymbolByClassId(javaClassId);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
        if (firRegularClass == null) {
            return declaredMemberScope;
        }
        FirRegularClass javaClass = firRegularClass;
        if (FunctionalTypeUtilsKt.isSomeFunctionType(((FirRegularClass)klass).getSymbol().toLookupTag(), useSiteSession) || Intrinsics.areEqual((Object)classId, (Object)StandardClassIds.INSTANCE.getAny())) {
            return declaredMemberScope;
        }
        FirTypeScope javaClassUseSiteScope = FirKotlinScopeProviderKt.unsubstitutedScope(javaClass, useSiteSession, scopeSession, false, memberRequiredPhase);
        return new JvmMappedScope(useSiteSession, (FirRegularClass)klass, javaClass, declaredMemberScope, javaClassUseSiteScope);
    }
}

