/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.collectors.components;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0003H\u0016J\u001a\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/collectors/components/AbstractDiagnosticCollectorComponent;", "Lksp/org/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "visitElement", "element", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "data", "checkSettings", "checkAndCommitReportsOn", "context", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticContext;", "checkers"})
public abstract class AbstractDiagnosticCollectorComponent
extends FirVisitor<Unit, CheckerContext> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final DiagnosticReporter reporter;

    public AbstractDiagnosticCollectorComponent(@NotNull FirSession session, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.session = session;
        this.reporter = reporter;
    }

    @NotNull
    protected final FirSession getSession() {
        return this.session;
    }

    @NotNull
    protected final DiagnosticReporter getReporter() {
        return this.reporter;
    }

    @Override
    public void visitElement(@NotNull FirElement element2, @NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
    }

    public void checkSettings(@NotNull CheckerContext data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
    }

    protected final void checkAndCommitReportsOn(@NotNull FirElement element2, @Nullable DiagnosticContext context2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        KtSourceElement ktSourceElement = element2.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        this.reporter.checkAndCommitReportsOn(source, context2);
    }
}

