/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import ksp.org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J4\u0010\r\u001a\u00020\u00072\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u0013*\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0014"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirVisibilityQualifierChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lksp/org/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/expression/FirResolvedQualifierChecker;", "<init>", "()V", "check", "", "expression", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClassLikeSymbol", "symbol", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "isStandalone", "", "toInvisibleCompanion", "Lksp/org/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "checkers"})
public final class FirVisibilityQualifierChecker
extends FirExpressionChecker<FirResolvedQualifier> {
    @NotNull
    public static final FirVisibilityQualifierChecker INSTANCE = new FirVisibilityQualifierChecker();

    private FirVisibilityQualifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirResolvedQualifier expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirClassLikeSymbol<?> firClassLikeSymbol = expression2.getSymbol();
        if (firClassLikeSymbol == null) {
            return;
        }
        this.checkClassLikeSymbol(firClassLikeSymbol, expression2, FirHelpersKt.isStandalone(expression2, context2), context2, reporter);
    }

    private final void checkClassLikeSymbol(FirClassLikeSymbol<?> symbol, FirResolvedQualifier expression2, boolean isStandalone, CheckerContext context2, DiagnosticReporter reporter) {
        block8: {
            Object object;
            FirFile firFile = context2.getContainingFile();
            if (firFile == null) {
                return;
            }
            FirFile firFile2 = firFile;
            KtSourceElement ktSourceElement = expression2.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitReceiver.INSTANCE) && !FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession()).isClassLikeVisible((FirClassLikeDeclaration)FirVisibilityCheckerKt.getFirForVisibilityChecker((FirBasedSymbol)symbol), context2.getSession(), firFile2, context2.getContainingDeclarations())) {
                if (!(expression2 instanceof FirErrorResolvedQualifier) || !(((FirErrorResolvedQualifier)expression2).getDiagnostic() instanceof ConeVisibilityError)) {
                    reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic((FirBasedSymbol)symbol, expression2.getSource()), context2);
                }
                return;
            }
            if (isStandalone) {
                FirRegularClassSymbol invisibleCompanion;
                FirRegularClassSymbol firRegularClassSymbol = expression2.getSymbol();
                FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol != null && (firRegularClassSymbol = DeclarationUtilsKt.fullyExpandedClass(firRegularClassSymbol, context2.getSession())) != null ? this.toInvisibleCompanion(firRegularClassSymbol, context2) : (invisibleCompanion = null);
                if (invisibleCompanion != null) {
                    if (!(expression2 instanceof FirErrorResolvedQualifier) || !(((FirErrorResolvedQualifier)expression2).getDiagnostic() instanceof ConeVisibilityError)) {
                        reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(invisibleCompanion, expression2.getSource()), context2);
                    }
                    return;
                }
            }
            if (symbol instanceof FirTypeAliasSymbol) {
                FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toClassLikeSymbol(((FirTypeAliasSymbol)symbol).getResolvedExpandedTypeRef().getConeType(), context2.getSession());
                if (firClassLikeSymbol != null) {
                    FirClassLikeSymbol<?> it = firClassLikeSymbol;
                    boolean bl = false;
                    INSTANCE.checkClassLikeSymbol(it, expression2, isStandalone, context2, reporter);
                }
            }
            if ((object = FirVisibilityCheckerKt.getOwnerLookupTag((FirBasedSymbol)symbol)) == null || (object = ToSymbolUtilsKt.toSymbol((ConeClassLikeLookupTag)object, context2.getSession())) == null) break block8;
            Object it = object;
            boolean bl = false;
            INSTANCE.checkClassLikeSymbol((FirClassLikeSymbol<?>)it, expression2, false, context2, reporter);
        }
    }

    private final FirRegularClassSymbol toInvisibleCompanion(FirRegularClassSymbol $this$toInvisibleCompanion, CheckerContext context2) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirFile firFile = context2.getContainingFile();
        if (firFile == null) {
            return null;
        }
        FirFile firFile2 = firFile;
        FirRegularClassSymbol firRegularClassSymbol2 = $this$toInvisibleCompanion.getCompanionObjectSymbol();
        if (firRegularClassSymbol2 != null) {
            FirRegularClassSymbol firRegularClassSymbol3;
            FirRegularClassSymbol it = firRegularClassSymbol3 = firRegularClassSymbol2;
            boolean bl = false;
            firRegularClassSymbol = !FirVisibilityCheckerKt.getVisibilityChecker(context2.getSession()).isClassLikeVisible((FirClassLikeDeclaration)FirVisibilityCheckerKt.getFirForVisibilityChecker((FirBasedSymbol)it), context2.getSession(), firFile2, context2.getContainingDeclarations()) ? firRegularClassSymbol3 : null;
        } else {
            firRegularClassSymbol = null;
        }
        return firRegularClassSymbol;
    }
}

