/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import ksp.org.jetbrains.kotlin.fir.types.AbbreviatedTypeAttributeKt;
import ksp.org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import ksp.org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirUserTypeRef;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOuterClassArgumentsRequiredChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkOuterClassArgumentsRequired", "typeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOuterClassArgumentsRequiredChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOuterClassArgumentsRequiredChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOuterClassArgumentsRequiredChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class FirOuterClassArgumentsRequiredChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirOuterClassArgumentsRequiredChecker INSTANCE = new FirOuterClassArgumentsRequiredChecker();

    private FirOuterClassArgumentsRequiredChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        for (FirTypeRef superTypeRef : declaration2.getSuperTypeRefs()) {
            this.checkOuterClassArgumentsRequired(superTypeRef, declaration2, context2, reporter);
        }
    }

    private final void checkOuterClassArgumentsRequired(FirTypeRef typeRef, FirRegularClass declaration2, CheckerContext context2, DiagnosticReporter reporter) {
        FirClassLikeSymbol<?> symbol;
        if (!(typeRef instanceof FirResolvedTypeRef) || typeRef instanceof FirErrorTypeRef) {
            return;
        }
        ConeKotlinType type2 = AbbreviatedTypeAttributeKt.getAbbreviatedTypeOrSelf(((FirResolvedTypeRef)typeRef).getConeType());
        FirTypeRef delegatedTypeRef = ((FirResolvedTypeRef)typeRef).getDelegatedTypeRef();
        if (delegatedTypeRef instanceof FirUserTypeRef && type2 instanceof ConeClassLikeType && (symbol = ToSymbolUtilsKt.toSymbol(((ConeClassLikeType)type2).getLookupTag(), context2.getSession())) instanceof FirRegularClassSymbol) {
            ConeTypeProjection[] typeArguments2 = DeclarationUtilsKt.toTypeProjections(((FirUserTypeRef)delegatedTypeRef).getQualifier());
            List<FirTypeParameterSymbol> typeParameters2 = ((FirRegularClassSymbol)symbol).getTypeParameterSymbols();
            int n = typeParameters2.size();
            for (int index2 = typeArguments2.length; index2 < n; ++index2) {
                FirTypeParameterSymbol typeParameter = typeParameters2.get(index2);
                if (DeclarationUtilsKt.isValidTypeParameterFromOuterDeclaration(typeParameter, declaration2, context2.getSession())) continue;
                FirBasedSymbol<?> firBasedSymbol = typeParameter.getContainingDeclarationSymbol();
                FirRegularClassSymbol firRegularClassSymbol = firBasedSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null;
                if (firRegularClassSymbol == null) break;
                FirRegularClassSymbol outerClass = firRegularClassSymbol;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirResolvedTypeRef)typeRef).getSource(), FirErrors.INSTANCE.getOUTER_CLASS_ARGUMENTS_REQUIRED(), (Object)outerClass, (DiagnosticContext)context2, null, 16, null);
                break;
            }
        }
        List<FirTypeRefSource> list = FirHelpersKt.extractArgumentsTypeRefAndSource(typeRef);
        if (list == null) {
            return;
        }
        List<FirTypeRefSource> typeRefAndSourcesForArguments = list;
        for (FirTypeRefSource firTypeRefSource : typeRefAndSourcesForArguments) {
            FirTypeRef it;
            if (firTypeRefSource.getTypeRef() == null) continue;
            boolean bl = false;
            INSTANCE.checkOuterClassArgumentsRequired(it, declaration2, context2, reporter);
        }
    }
}

