/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.lang;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import ksp.com.intellij.util.lang.CachePoolImpl;
import ksp.com.intellij.util.lang.ClassLoadingLocks;
import ksp.com.intellij.util.lang.ClassPath;
import ksp.com.intellij.util.lang.ClasspathCache;
import ksp.com.intellij.util.lang.Resource;
import ksp.com.intellij.util.lang.ResourceFile;
import ksp.com.intellij.util.lang.UrlUtilRt;
import ksp.org.jetbrains.annotations.ApiStatus;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class UrlClassLoader
extends ClassLoader
implements ClassPath.ClassDataConsumer {
    private static final boolean isClassPathIndexEnabledGlobalValue = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
    private static final boolean mimicJarUrlConnection = Boolean.parseBoolean(System.getProperty("idea.mimic.jar.url.connection", "false"));
    private static final boolean isParallelCapable = UrlClassLoader.registerAsParallelCapable();
    private static final ClassLoader appClassLoader = UrlClassLoader.class.getClassLoader();
    private static final ThreadLocal<Boolean> skipFindingResource = new ThreadLocal();
    protected final ClassPath classPath;
    private final ClassLoadingLocks classLoadingLocks;
    private final boolean isBootstrapResourcesAllowed;
    private final boolean isSystemClassLoader;
    private final boolean enableCoroutineDump;
    @NotNull
    protected final ClassPath.ClassDataConsumer classDataConsumer;
    @ApiStatus.Internal
    @Nullable
    public BiFunction<String, Boolean, String> resolveScopeManager;

    final void appendToClassPathForInstrumentation(@NotNull String jar) {
        if (jar == null) {
            UrlClassLoader.$$$reportNull$$$0(0);
        }
        this.classPath.addFile(Paths.get(jar, new String[0]));
    }

    @ApiStatus.Internal
    @NotNull
    public final ClassPath getClassPath() {
        ClassPath classPath2 = this.classPath;
        if (classPath2 == null) {
            UrlClassLoader.$$$reportNull$$$0(1);
        }
        return classPath2;
    }

    @NotNull
    public final List<Path> getBaseUrls() {
        List<Path> list = this.classPath.getBaseUrls();
        if (list == null) {
            UrlClassLoader.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public final Map<String, Long> getLoadingStats() {
        Map<String, Long> map = ClassPath.getLoadingStats();
        if (map == null) {
            UrlClassLoader.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public static Builder build() {
        return new Builder();
    }

    @Deprecated
    public UrlClassLoader(@NotNull ClassLoader parent2) {
        if (parent2 == null) {
            UrlClassLoader.$$$reportNull$$$0(4);
        }
        this(UrlClassLoader.createDefaultBuilderForJdk(parent2), null, isParallelCapable);
        UrlClassLoader.registerInClassLoaderValueMap(parent2, this);
    }

    protected static void registerInClassLoaderValueMap(@NotNull ClassLoader parent2, @NotNull ClassLoader classLoader) {
        if (parent2 == null) {
            UrlClassLoader.$$$reportNull$$$0(5);
        }
        if (classLoader == null) {
            UrlClassLoader.$$$reportNull$$$0(6);
        }
        try {
            Field f = ClassLoader.class.getDeclaredField("classLoaderValueMap");
            f.setAccessible(true);
            f.set(classLoader, f.get(parent2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NotNull
    protected static Builder createDefaultBuilderForJdk(@NotNull ClassLoader parent2) {
        if (parent2 == null) {
            UrlClassLoader.$$$reportNull$$$0(7);
        }
        Builder configuration2 = new Builder();
        if (parent2 instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)parent2).getURLs();
            LinkedHashSet<Path> files2 = new LinkedHashSet<Path>(urls.length);
            for (URL url : urls) {
                files2.add(Paths.get(url.getPath(), new String[0]));
            }
            configuration2.files = files2;
        } else {
            String[] parts = System.getProperty("java.class.path").split(File.pathSeparator);
            LinkedHashSet<Path> files3 = new LinkedHashSet<Path>(parts.length);
            for (String s : parts) {
                files3.add(Paths.get(s, new String[0]));
            }
            configuration2.files = files3;
        }
        configuration2.isSystemClassLoader = true;
        configuration2.parent = parent2.getParent();
        configuration2.useCache = true;
        configuration2.isClassPathIndexEnabled = isClassPathIndexEnabledGlobalValue;
        configuration2.isBootstrapResourcesAllowed = Boolean.parseBoolean(System.getProperty("idea.allow.bootstrap.resources", "true"));
        Builder builder2 = configuration2;
        if (builder2 == null) {
            UrlClassLoader.$$$reportNull$$$0(8);
        }
        return builder2;
    }

    protected UrlClassLoader(@NotNull Builder builder2, boolean isParallelCapable) {
        if (builder2 == null) {
            UrlClassLoader.$$$reportNull$$$0(9);
        }
        this(builder2, null, isParallelCapable);
    }

    protected UrlClassLoader(@NotNull Builder builder2, @Nullable Function<Path, ResourceFile> resourceFileFactory, boolean isParallelCapable) {
        if (builder2 == null) {
            UrlClassLoader.$$$reportNull$$$0(10);
        }
        super(builder2.parent);
        this.classDataConsumer = ClassPath.recordLoadingTime ? new ClassPath.MeasuringClassDataConsumer(this) : this;
        this.isSystemClassLoader = builder2.isSystemClassLoader;
        this.enableCoroutineDump = Boolean.parseBoolean(System.getProperty("idea.enable.coroutine.dump.using.classloader", "false"));
        this.classPath = new ClassPath(builder2.files, builder2, resourceFileFactory, mimicJarUrlConnection);
        this.isBootstrapResourcesAllowed = builder2.isBootstrapResourcesAllowed;
        this.classLoadingLocks = isParallelCapable ? new ClassLoadingLocks() : null;
    }

    protected UrlClassLoader(@NotNull ClassPath classPath2) {
        if (classPath2 == null) {
            UrlClassLoader.$$$reportNull$$$0(11);
        }
        super(null);
        this.classDataConsumer = ClassPath.recordLoadingTime ? new ClassPath.MeasuringClassDataConsumer(this) : this;
        this.classPath = classPath2;
        this.isBootstrapResourcesAllowed = false;
        this.isSystemClassLoader = false;
        this.classLoadingLocks = new ClassLoadingLocks();
        this.enableCoroutineDump = false;
    }

    @Deprecated
    public final void addURL(@NotNull URL url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(12);
        }
        this.classPath.addFile(Paths.get(url.getPath(), new String[0]));
    }

    @Deprecated
    @ApiStatus.Internal
    public final void addFiles(@NotNull List<Path> files2) {
        if (files2 == null) {
            UrlClassLoader.$$$reportNull$$$0(13);
        }
        this.classPath.addFiles(files2);
    }

    @NotNull
    public final List<URL> getUrls() {
        ArrayList<URL> result2 = new ArrayList<URL>();
        for (Path file2 : this.classPath.getFiles()) {
            try {
                result2.add(file2.toUri().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        ArrayList<URL> arrayList = result2;
        if (arrayList == null) {
            UrlClassLoader.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    public final List<Path> getFiles() {
        List<Path> list = this.classPath.getFiles();
        if (list == null) {
            UrlClassLoader.$$$reportNull$$$0(15);
        }
        return list;
    }

    public boolean hasLoadedClass(String name2) {
        Class<?> aClass = this.findLoadedClass(name2);
        return aClass != null && aClass.getClassLoader() == this;
    }

    @Override
    protected Class<?> findClass(@NotNull String name2) throws ClassNotFoundException {
        Class<?> clazz;
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(16);
        }
        String fileNameWithoutExtension = name2.replace('.', '/');
        String fileName2 = fileNameWithoutExtension + ".class";
        long packageNameHash = ClasspathCache.getPackageNameHash(fileNameWithoutExtension, fileNameWithoutExtension.lastIndexOf(47));
        if (!(!this.isSystemClassLoader || packageNameHash != -9217824570049207139L && packageNameHash != -1976620678582843062L || fileNameWithoutExtension.endsWith("/CompoundRuntimeException") || fileNameWithoutExtension.endsWith("/JavaVersion"))) {
            return appClassLoader.loadClass(name2);
        }
        try {
            if (this.enableCoroutineDump && packageNameHash == -3930079881136890558L && name2.equals("kotlin.coroutines.jvm.internal.DebugProbesKt")) {
                String resourceName = "DebugProbesKt.bin";
                Resource resource = this.classPath.findResource(resourceName);
                if (resource == null) {
                    System.err.println("Cannot find " + resourceName);
                } else {
                    return this.classDataConsumer.consumeClassData(name2, resource.getByteBuffer());
                }
            }
            clazz = this.classPath.findClass(name2, fileName2, packageNameHash, this.classDataConsumer);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name2, e);
        }
        if (clazz == null) {
            throw new ClassNotFoundException(name2);
        }
        return clazz;
    }

    private void definePackageIfNeeded(String name2) {
        int lastDotIndex = name2.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return;
        }
        String packageName2 = name2.substring(0, lastDotIndex);
        if (this.isPackageDefined(packageName2)) {
            return;
        }
        try {
            this.definePackage(packageName2, null, null, null, null, null, null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected boolean isPackageDefined(String packageName2) {
        return this.getPackage(packageName2) != null;
    }

    @Override
    public boolean isByteBufferSupported(@NotNull String name2) {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(17);
        }
        return true;
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name2, byte[] data) throws IOException {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(18);
        }
        this.definePackageIfNeeded(name2);
        return super.defineClass(name2, data, 0, data.length, null);
    }

    @Override
    public Class<?> consumeClassData(@NotNull String name2, ByteBuffer data) {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(19);
        }
        this.definePackageIfNeeded(name2);
        return super.defineClass(name2, data, null);
    }

    @Override
    @Nullable
    public URL findResource(@NotNull String name2) {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(20);
        }
        if (skipFindingResource.get() != null) {
            return null;
        }
        Resource resource = this.doFindResource(name2);
        return resource != null ? resource.getURL() : null;
    }

    public byte @Nullable [] getResourceAsBytes(@NotNull String name2, boolean checkParents) throws IOException {
        Resource resource;
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(21);
        }
        return (resource = this.classPath.findResource(name2)) == null ? null : resource.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public InputStream getResourceAsStream(@NotNull String name2) {
        Resource resource;
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(22);
        }
        if ((resource = this.doFindResource(name2)) != null) {
            try {
                return resource.getInputStream();
            }
            catch (IOException e) {
                this.logError("Cannot load resource " + name2, e);
                return null;
            }
        }
        if (this.isBootstrapResourcesAllowed) {
            skipFindingResource.set(Boolean.TRUE);
            try {
                URL url = super.getResource(name2);
                if (url != null) {
                    try {
                        InputStream inputStream = url.openStream();
                        return inputStream;
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                skipFindingResource.set(null);
            }
        }
        return null;
    }

    @Nullable
    private Resource doFindResource(String name2) {
        String canonicalPath2 = UrlClassLoader.toCanonicalPath(name2);
        Resource resource = this.classPath.findResource(canonicalPath2);
        if (resource == null && canonicalPath2.startsWith("/") && this.classPath.findResource(canonicalPath2.substring(1)) != null) {
            this.logError("Calling `ClassLoader#getResource` with leading slash doesn't work; strip", new IllegalArgumentException(name2));
        }
        return resource;
    }

    public final void processResources(@NotNull String dir, @NotNull Predicate<? super String> fileNameFilter, @NotNull BiConsumer<? super String, ? super InputStream> consumer2) throws IOException {
        if (dir == null) {
            UrlClassLoader.$$$reportNull$$$0(23);
        }
        if (fileNameFilter == null) {
            UrlClassLoader.$$$reportNull$$$0(24);
        }
        if (consumer2 == null) {
            UrlClassLoader.$$$reportNull$$$0(25);
        }
        this.classPath.processResources(dir, fileNameFilter, consumer2);
    }

    @Override
    @NotNull
    public Enumeration<URL> findResources(@NotNull String name2) {
        if (name2 == null) {
            UrlClassLoader.$$$reportNull$$$0(26);
        }
        Enumeration<URL> enumeration = this.classPath.getResources(name2);
        if (enumeration == null) {
            UrlClassLoader.$$$reportNull$$$0(27);
        }
        return enumeration;
    }

    @Override
    @NotNull
    protected final Object getClassLoadingLock(String className) {
        Object object = this.classLoadingLocks == null ? this : this.classLoadingLocks.getOrCreateLock(className);
        if (object == null) {
            UrlClassLoader.$$$reportNull$$$0(28);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Class<?> loadClassInsideSelf(String name2, String fileName2, long packageNameHash, boolean forceLoadFromSubPluginClassloader) throws IOException {
        Object object = this.getClassLoadingLock(name2);
        synchronized (object) {
            Class<?> c = this.findLoadedClass(name2);
            if (c != null) {
                return c;
            }
            if (!forceLoadFromSubPluginClassloader) {
                ClassLoader parent2 = this.getParent();
                if (parent2 != null) {
                    try {
                        c = parent2.loadClass(name2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (c != null) {
                    return c;
                }
            }
            return this.classPath.findClass(name2, fileName2, packageNameHash, this.classDataConsumer);
        }
    }

    @NotNull
    public static CachePool createCachePool() {
        return new CachePoolImpl();
    }

    protected static String toCanonicalPath(@NotNull String path) {
        char next2;
        if (path == null) {
            UrlClassLoader.$$$reportNull$$$0(29);
        }
        if (path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == '.') {
            if (path.length() == 1) {
                return "";
            }
            char c = path.charAt(1);
            if (c == '/') {
                path = path.substring(2);
            }
        }
        int index2 = -1;
        do {
            char c = next2 = (index2 = path.indexOf(47, index2 + 1)) == path.length() - 1 ? (char)'\u0000' : path.charAt(index2 + 1);
        } while (next2 != '.' && next2 != '/' && index2 != -1);
        if (index2 == -1) {
            return path;
        }
        StringBuilder result2 = new StringBuilder(path.length());
        int start = UrlClassLoader.processRoot(path, result2);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (!separator) {
                    UrlClassLoader.processDots(result2, dots, start);
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result2.append('.');
                }
                separator = false;
                continue;
            }
            while (dots > 0) {
                result2.append('.');
                --dots;
            }
            result2.append(c);
            separator = false;
        }
        if (dots > 0) {
            UrlClassLoader.processDots(result2, dots, start);
        }
        return result2.toString();
    }

    private static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        int l2;
        int l1;
        if (text == null) {
            UrlClassLoader.$$$reportNull$$$0(30);
        }
        if (suffix == null) {
            UrlClassLoader.$$$reportNull$$$0(31);
        }
        if ((l1 = text.length()) < (l2 = suffix.length())) {
            return false;
        }
        for (int i = l1 - 1; i >= l1 - l2; --i) {
            if (text.charAt(i) == suffix.charAt(i + l2 - l1)) continue;
            return false;
        }
        return true;
    }

    private static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            UrlClassLoader.$$$reportNull$$$0(32);
        }
        start = Math.max(start, 0);
        for (int i = Math.min(end, s.length()) - 1; i >= start; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private static void processDots(StringBuilder result2, int dots, int start) {
        if (dots == 2) {
            int pos = -1;
            if (!UrlClassLoader.endsWith(result2, "/../") && !"../".contentEquals(result2)) {
                pos = UrlClassLoader.lastIndexOf(result2, '/', start, result2.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result2.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                result2.delete(pos, result2.length());
            } else {
                result2.append("../");
            }
        } else if (dots != 1) {
            for (int i = 0; i < dots; ++i) {
                result2.append('.');
            }
            result2.append('/');
        }
    }

    private static int processRoot(String path, StringBuilder result2) {
        if (!path.isEmpty() && path.charAt(0) == '/') {
            result2.append('/');
            return 1;
        }
        if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
            result2.append(path, 0, 3);
            return 3;
        }
        return 0;
    }

    private void logError(String message, Throwable t) {
        try {
            Class<?> logger2 = this.loadClass("ksp.com.intellij.openapi.diagnostic.Logger");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Object instance2 = lookup.findStatic(logger2, "getInstance", MethodType.methodType(logger2, Class.class)).invoke(this.getClass());
            lookup.findVirtual(logger2, "error", MethodType.methodType(Void.TYPE, String.class, Throwable.class)).bindTo(instance2).invokeExact(message, t);
        }
        catch (Throwable tt) {
            t.addSuppressed(tt);
            System.err.println(this.getClass().getName() + ": " + message);
            t.printStackTrace(System.err);
        }
    }

    @NotNull
    public static String urlToFilePath(@NotNull String url) {
        if (url == null) {
            UrlClassLoader.$$$reportNull$$$0(33);
        }
        int start = url.startsWith("file:") ? "file:".length() : 0;
        int end = url.indexOf("!/");
        if (url.charAt(start) == '/' && url.length() > start + 2 && url.charAt(start + 2) == ':') {
            ++start;
        }
        String string2 = UrlUtilRt.unescapePercentSequences(url, start, end < 0 ? url.length() : end).toString();
        if (string2 == null) {
            UrlClassLoader.$$$reportNull$$$0(34);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 34: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jar";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 12: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNameFilter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/util/lang/UrlClassLoader";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseUrls";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadingStats";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultBuilderForJdk";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findResources";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoadingLock";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "urlToFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendToClassPathForInstrumentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 34: {
                break;
            }
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerInClassLoaderValueMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBuilderForJdk";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addURL";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isByteBufferSupported";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "consumeClassData";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findResource";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsBytes";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processResources";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findResources";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "toCanonicalPath";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "urlToFilePath";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 14: 
            case 15: 
            case 27: 
            case 28: 
            case 34: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder {
        Collection<Path> files = Collections.emptyList();
        ClassLoader parent;
        boolean lockJars = true;
        boolean useCache = true;
        boolean isSystemClassLoader;
        boolean isClassPathIndexEnabled = UrlClassLoader.access$000();
        boolean isBootstrapResourcesAllowed;
        @Nullable
        CachePoolImpl cachePool;
        Predicate<? super Path> cachingCondition;

        Builder() {
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public Builder urls(@NotNull List<URL> urls) {
            if (urls == null) {
                Builder.$$$reportNull$$$0(0);
            }
            ArrayList<Path> files2 = new ArrayList<Path>(urls.size());
            for (URL url : urls) {
                files2.add(Paths.get(UrlClassLoader.urlToFilePath(url.getPath()), new String[0]));
            }
            this.files = files2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(1);
            }
            return builder2;
        }

        @NotNull
        public Builder files(@NotNull List<Path> paths2) {
            if (paths2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.files = paths2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder2;
        }

        @NotNull
        public Builder parent(ClassLoader parent2) {
            this.parent = parent2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder allowLock(boolean lockJars) {
            this.lockJars = lockJars;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(5);
            }
            return builder2;
        }

        @NotNull
        public Builder useCache() {
            this.useCache = true;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder2;
        }

        @NotNull
        public Builder useCache(boolean useCache) {
            this.useCache = useCache;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder2;
        }

        @NotNull
        public Builder usePersistentClasspathIndexForLocalClassDirectories(boolean value2) {
            this.isClassPathIndexEnabled = value2;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder2;
        }

        @NotNull
        public Builder usePersistentClasspathIndexForLocalClassDirectories() {
            this.isClassPathIndexEnabled = isClassPathIndexEnabledGlobalValue;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(9);
            }
            return builder2;
        }

        @NotNull
        public Builder useCache(@NotNull CachePool pool, @NotNull Predicate<? super Path> condition) {
            if (pool == null) {
                Builder.$$$reportNull$$$0(10);
            }
            if (condition == null) {
                Builder.$$$reportNull$$$0(11);
            }
            this.useCache = true;
            this.cachePool = (CachePoolImpl)pool;
            this.cachingCondition = condition;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder2;
        }

        @NotNull
        public Builder noPreload() {
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder2;
        }

        @NotNull
        public Builder allowBootstrapResources() {
            Builder builder2 = this.allowBootstrapResources(true);
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder2;
        }

        @NotNull
        public Builder allowBootstrapResources(boolean allowBootstrapResources) {
            this.isBootstrapResourcesAllowed = allowBootstrapResources;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(15);
            }
            return builder2;
        }

        @NotNull
        public UrlClassLoader get() {
            return new UrlClassLoader(this, null, isParallelCapable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ksp/com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "paths";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pool";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "ksp/com/intellij/util/lang/UrlClassLoader$Builder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "urls";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "files";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parent";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowLock";
                    break;
                }
                case 6: 
                case 7: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "useCache";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "usePersistentClasspathIndexForLocalClassDirectories";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "noPreload";
                    break;
                }
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "allowBootstrapResources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "urls";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "files";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "useCache";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface CachePool {
    }
}

