/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.config.LanguageFeature;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import ksp.org.jetbrains.kotlin.fir.FirSession;
import ksp.org.jetbrains.kotlin.fir.UtilsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import ksp.org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import ksp.org.jetbrains.kotlin.fir.declarations.SealedClassInheritorsKt;
import ksp.org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import ksp.org.jetbrains.kotlin.fir.expressions.FirStatement;
import ksp.org.jetbrains.kotlin.fir.resolve.ScopeSession;
import ksp.org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import ksp.org.jetbrains.kotlin.fir.resolve.transformers.FirGlobalResolveProcessor;
import ksp.org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import ksp.org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import ksp.org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import ksp.org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeRef;
import ksp.org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import ksp.org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import ksp.org.jetbrains.kotlin.fir.visitors.FirTransformer;
import ksp.org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import ksp.org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor;", "Lksp/org/jetbrains/kotlin/fir/resolve/transformers/FirGlobalResolveProcessor;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lksp/org/jetbrains/kotlin/fir/resolve/ScopeSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "process", "", "files", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "InheritorsCollector", "InheritorsTransformer", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirSealedClassInheritorsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n*L\n1#1,133:1\n1863#2:134\n1864#2:139\n1863#2:140\n1864#2:145\n229#3,4:135\n229#3,4:141\n*S KotlinDebug\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor\n*L\n41#1:134\n41#1:139\n46#1:140\n46#1:145\n42#1:135,4\n47#1:141,4\n*E\n"})
public final class FirSealedClassInheritorsProcessor
extends FirGlobalResolveProcessor {
    public FirSealedClassInheritorsProcessor(@NotNull FirSession session, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        super(session, scopeSession, FirResolvePhase.SEALED_CLASS_INHERITORS);
    }

    @Override
    public void process(@NotNull Collection<? extends FirFile> files2) {
        Unit unit;
        boolean $i$f$withFileAnalysisExceptionWrapping;
        FirFile it;
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        Map sealedClassInheritorsMap = new LinkedHashMap();
        InheritorsCollector inheritorsCollector = new InheritorsCollector(this.getSession());
        Iterable $this$forEach$iv = files2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirFile)element$iv;
            boolean bl = false;
            $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl2 = false;
                it.accept(inheritorsCollector, sealedClassInheritorsMap);
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(it.getModuleData().getSession()).handleExceptionOnFileAnalysis(it, throwable$iv);
                throw new KotlinNothingValueException();
            }
        }
        $this$forEach$iv = files2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (FirFile)element$iv;
            boolean bl = false;
            $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl3 = false;
                FirTransformerUtilKt.transformSingle((FirElement)it, new InheritorsTransformer(sealedClassInheritorsMap), null);
                unit = Unit.INSTANCE;
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(it.getModuleData().getSession()).handleExceptionOnFileAnalysis(it, throwable$iv);
                throw new KotlinNothingValueException();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002 \u0012\u0004\u0012\u00020\u0002\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00030\u0001B\u000f\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ*\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00042\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J*\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0003H\u0016J\u001e\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00062\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsCollector;", "Lksp/org/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "Lksp/org/jetbrains/kotlin/name/ClassId;", "session", "Lksp/org/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "visitElement", "element", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "data", "visitFile", "file", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "visitRegularClass", "regularClass", "visitTypeAlias", "typeAlias", "Lksp/org/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "collectInheritorsOfCorrespondingExpectSealedClass", "expectClassId", "inheritors", "extractClassFromTypeRef", "typeRef", "Lksp/org/jetbrains/kotlin/fir/types/FirTypeRef;", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirSealedClassInheritorsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1863#2,2:134\n1863#2,2:136\n11#3:138\n11#3:141\n33#3:142\n11#3:143\n34#3:144\n59#3:145\n227#4:139\n1#5:140\n*S KotlinDebug\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsCollector\n*L\n57#1:134,2\n61#1:136,2\n63#1:138\n68#1:141\n81#1:142\n83#1:143\n90#1:144\n90#1:145\n63#1:139\n*E\n"})
    public static final class InheritorsCollector
    extends FirDefaultVisitor<Unit, Map<FirRegularClass, Set<ClassId>>> {
        @NotNull
        private final FirSession session;

        public InheritorsCollector(@NotNull FirSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        @NotNull
        public final FirSession getSession() {
            return this.session;
        }

        @Override
        public void visitElement(@NotNull FirElement element2, @NotNull Map<FirRegularClass, Set<ClassId>> data) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter(data, (String)"data");
        }

        @Override
        public void visitFile(@NotNull FirFile file2, @NotNull Map<FirRegularClass, Set<ClassId>> data) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Iterable $this$forEach$iv = file2.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                it.accept(this, data);
            }
        }

        @Override
        public void visitRegularClass(@NotNull FirRegularClass regularClass, @NotNull Map<FirRegularClass, Set<ClassId>> data) {
            Set set;
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Iterable $this$forEach$iv = regularClass.getDeclarations();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirDeclaration it = (FirDeclaration)element$iv;
                boolean bl = false;
                it.accept(this, data);
            }
            FirMemberDeclaration $this$modality$iv = regularClass;
            boolean $i$f$getModality = false;
            boolean condition$iv = $this$modality$iv.getStatus().getModality() == Modality.SEALED;
            boolean $i$f$runIf = false;
            if (condition$iv) {
                boolean bl = false;
                set = data.computeIfAbsent(regularClass, arg_0 -> InheritorsCollector.visitRegularClass$lambda$4$lambda$3(InheritorsCollector::visitRegularClass$lambda$4$lambda$2, arg_0));
            } else {
                set = null;
            }
            Set sealedInheritors = set;
            for (FirTypeRef typeRef : regularClass.getSuperTypeRefs()) {
                Set inheritors;
                FirRegularClass parent2;
                Modality modality;
                FirRegularClass firRegularClass;
                FirRegularClass it = firRegularClass = this.extractClassFromTypeRef(typeRef);
                boolean bl = false;
                FirRegularClass firRegularClass2 = it;
                if (firRegularClass2 != null) {
                    FirMemberDeclaration $this$modality$iv2 = firRegularClass2;
                    boolean $i$f$getModality2 = false;
                    modality = $this$modality$iv2.getStatus().getModality();
                } else {
                    modality = null;
                }
                FirRegularClass firRegularClass3 = modality == Modality.SEALED ? firRegularClass : null;
                if (firRegularClass3 == null || !Intrinsics.areEqual((Object)FirDeclarationUtilKt.getClassId(parent2 = firRegularClass3).getPackageFqName(), (Object)FirDeclarationUtilKt.getClassId(regularClass).getPackageFqName())) continue;
                Intrinsics.checkNotNullExpressionValue((Object)data.computeIfAbsent(parent2, arg_0 -> InheritorsCollector.visitRegularClass$lambda$7(InheritorsCollector::visitRegularClass$lambda$6, arg_0)), (String)"computeIfAbsent(...)");
                ((Collection)inheritors).add(regularClass.getSymbol().getClassId());
            }
            if (sealedInheritors != null) {
                this.collectInheritorsOfCorrespondingExpectSealedClass(FirDeclarationUtilKt.getClassId(regularClass), sealedInheritors);
            }
        }

        @Override
        public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull Map<FirRegularClass, Set<ClassId>> data) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkNotNullParameter(data, (String)"data");
            FirMemberDeclaration $this$isActual$iv = typeAlias;
            boolean $i$f$isActual = false;
            if (!$this$isActual$iv.getStatus().isActual()) {
                return;
            }
            Object object = ToSymbolUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType(typeAlias.getExpandedTypeRef()), this.session);
            if (object == null || (object = (FirRegularClass)((FirBasedSymbol)object).getFir()) == null) {
                return;
            }
            Object expansionClass = object;
            FirMemberDeclaration $this$modality$iv = (FirMemberDeclaration)expansionClass;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getStatus().getModality() != Modality.SEALED) {
                return;
            }
            ClassId classId = FirDeclarationUtilKt.getClassId(typeAlias);
            Set set = data.computeIfAbsent((FirRegularClass)expansionClass, arg_0 -> InheritorsCollector.visitTypeAlias$lambda$9(InheritorsCollector::visitTypeAlias$lambda$8, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
            this.collectInheritorsOfCorrespondingExpectSealedClass(classId, set);
        }

        private final void collectInheritorsOfCorrespondingExpectSealedClass(ClassId expectClassId, Set<ClassId> inheritors) {
            if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).supportsFeature(LanguageFeature.MultiPlatformProjects)) {
                return;
            }
            Object object = FirSymbolProviderKt.getRegularClassSymbolByClassIdFromDependencies(this.session, expectClassId);
            if (object == null || (object = (FirRegularClass)((FirBasedSymbol)object).getFir()) == null) {
                return;
            }
            Object correspondingExpectClass = object;
            FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)correspondingExpectClass;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                Object $this$isSealed$iv = correspondingExpectClass;
                boolean $i$f$isSealed = false;
                if (((FirRegularClass)$this$isSealed$iv).getStatus().getModality() == Modality.SEALED) {
                    List<ClassId> commonInheritors = SealedClassInheritorsKt.getSealedClassInheritors((FirRegularClass)correspondingExpectClass, ((FirRegularClass)correspondingExpectClass).getModuleData().getSession());
                    inheritors.addAll((Collection<ClassId>)commonInheritors);
                }
            }
        }

        private final FirRegularClass extractClassFromTypeRef(FirTypeRef typeRef) {
            FirRegularClass firRegularClass;
            ConeClassifierLookupTag coneClassifierLookupTag = ConeTypeUtilsKt.getLookupTagIfAny(FirTypeUtilsKt.getConeType(typeRef));
            if (coneClassifierLookupTag == null) {
                return null;
            }
            ConeClassifierLookupTag lookupTag = coneClassifierLookupTag;
            FirClassifierSymbol<?> firClassifierSymbol = ToSymbolUtilsKt.toSymbol(lookupTag, this.session);
            if (firClassifierSymbol == null) {
                return null;
            }
            FirClassifierSymbol<?> classLikeSymbol = firClassifierSymbol;
            FirClassifierSymbol<?> firClassifierSymbol2 = classLikeSymbol;
            if (firClassifierSymbol2 instanceof FirRegularClassSymbol) {
                firRegularClass = (FirRegularClass)((FirRegularClassSymbol)classLikeSymbol).getFir();
            } else if (firClassifierSymbol2 instanceof FirTypeAliasSymbol) {
                FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)classLikeSymbol, FirResolvePhase.SUPER_TYPES);
                firRegularClass = this.extractClassFromTypeRef(((FirTypeAlias)((FirTypeAliasSymbol)classLikeSymbol).getFir()).getExpandedTypeRef());
            } else {
                firRegularClass = null;
            }
            return firRegularClass;
        }

        private static final Set visitRegularClass$lambda$4$lambda$2(FirRegularClass it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }

        private static final Set visitRegularClass$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
            return (Set)$tmp0.invoke(p0);
        }

        private static final Set visitRegularClass$lambda$6(FirRegularClass it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }

        private static final Set visitRegularClass$lambda$7(Function1 $tmp0, Object p0) {
            return (Set)$tmp0.invoke(p0);
        }

        private static final Set visitTypeAlias$lambda$8(FirRegularClass it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }

        private static final Set visitTypeAlias$lambda$9(Function1 $tmp0, Object p0) {
            return (Set)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B!\u0012\u0018\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u0002H\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0016R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lksp/org/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsTransformer;", "Lksp/org/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "inheritorsMap", "", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "", "Lksp/org/jetbrains/kotlin/name/ClassId;", "<init>", "(Ljava/util/Map;)V", "transformElement", "E", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformRegularClass", "Lksp/org/jetbrains/kotlin/fir/expressions/FirStatement;", "regularClass", "resolve"})
    @SourceDebugExtension(value={"SMAP\nFirSealedClassInheritorsProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsTransformer\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,133:1\n229#2,4:134\n11#3:138\n*S KotlinDebug\n*F\n+ 1 FirSealedClassInheritorsProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirSealedClassInheritorsProcessor$InheritorsTransformer\n*L\n116#1:134,4\n122#1:138\n*E\n"})
    public static final class InheritorsTransformer
    extends FirTransformer<Object> {
        @NotNull
        private final Map<FirRegularClass, Set<ClassId>> inheritorsMap;

        public InheritorsTransformer(@NotNull Map<FirRegularClass, Set<ClassId>> inheritorsMap) {
            Intrinsics.checkNotNullParameter(inheritorsMap, (String)"inheritorsMap");
            this.inheritorsMap = inheritorsMap;
        }

        @Override
        @NotNull
        public <E extends FirElement> E transformElement(@NotNull E element2, @Nullable Object data) {
            Intrinsics.checkNotNullParameter(element2, (String)"element");
            return element2;
        }

        @Override
        @NotNull
        public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data) {
            FirFile firFile;
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            boolean $i$f$withFileAnalysisExceptionWrapping = false;
            try {
                boolean bl = false;
                FirElement firElement = file2.transformChildren(this, data);
                Intrinsics.checkNotNull((Object)firElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
                firFile = (FirFile)firElement;
            }
            catch (Throwable throwable$iv) {
                UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv);
                throw new KotlinNothingValueException();
            }
            return firFile;
        }

        @Override
        @NotNull
        public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data) {
            Set<ClassId> inheritors;
            Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
            FirMemberDeclaration $this$modality$iv = regularClass;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getStatus().getModality() == Modality.SEALED && (inheritors = this.inheritorsMap.remove(regularClass)) != null) {
                SealedClassInheritorsKt.setSealedClassInheritors(regularClass, CollectionsKt.toList((Iterable)inheritors));
            }
            if (this.inheritorsMap.isEmpty()) {
                return regularClass;
            }
            FirElement firElement = regularClass.transformChildren(this, data);
            Intrinsics.checkNotNull((Object)firElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
            return (FirRegularClass)firElement;
        }
    }
}

