/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.AbstractKtSourceElement;
import ksp.org.jetbrains.kotlin.KtRealSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import ksp.org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import ksp.org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousCallsEffectDeclaration;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousConstantReference;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousContractElement;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousIsInstancePredicate;
import ksp.org.jetbrains.kotlin.contracts.description.KtErroneousValueParameterReference;
import ksp.org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import ksp.org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import ksp.org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import ksp.org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import ksp.org.jetbrains.kotlin.descriptors.Modality;
import ksp.org.jetbrains.kotlin.descriptors.Visibilities;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import ksp.org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import ksp.org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import ksp.org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import ksp.org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import ksp.org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import ksp.org.jetbrains.kotlin.fir.contracts.FirContractElementDeclaration;
import ksp.org.jetbrains.kotlin.fir.contracts.FirResolvedContractDescription;
import ksp.org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirContractDescriptionOwner;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFunction;
import ksp.org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import ksp.org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFunction;", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFunctionChecker;", "<init>", "()V", "EMPTY_CONTRACT_MESSAGE", "", "check", "", "declaration", "context", "Lksp/org/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lksp/org/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkUnresolvedEffects", "contractDescription", "Lksp/org/jetbrains/kotlin/fir/contracts/FirResolvedContractDescription;", "checkContractNotAllowed", "", "DiagnosticExtractor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirContractChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,150:1\n12#2,2:151\n37#2:153\n38#2:154\n21#2:155\n*S KotlinDebug\n*F\n+ 1 FirContractChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker\n*L\n68#1:151,2\n68#1:153\n69#1:154\n70#1:155\n*E\n"})
public final class FirContractChecker
extends FirDeclarationChecker<FirFunction> {
    @NotNull
    public static final FirContractChecker INSTANCE = new FirContractChecker();
    @NotNull
    private static final String EMPTY_CONTRACT_MESSAGE = "Empty contract block is not allowed";

    private FirContractChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunction declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (!(declaration2 instanceof FirContractDescriptionOwner)) {
            return;
        }
        FirContractDescription firContractDescription = ((FirContractDescriptionOwner)((Object)declaration2)).getContractDescription();
        FirResolvedContractDescription firResolvedContractDescription = firContractDescription instanceof FirResolvedContractDescription ? (FirResolvedContractDescription)firContractDescription : null;
        if (firResolvedContractDescription == null) {
            return;
        }
        FirResolvedContractDescription contractDescription = firResolvedContractDescription;
        boolean reportedNotAllowed = this.checkContractNotAllowed(declaration2, contractDescription, context2, reporter);
        if (reportedNotAllowed) {
            return;
        }
        this.checkUnresolvedEffects(contractDescription, context2, reporter);
        if (contractDescription.getEffects().isEmpty() && contractDescription.getUnresolvedEffects().isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)contractDescription.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)EMPTY_CONTRACT_MESSAGE, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final void checkUnresolvedEffects(FirResolvedContractDescription contractDescription, CheckerContext context2, DiagnosticReporter reporter) {
        for (FirContractElementDeclaration unresolvedEffect : contractDescription.getUnresolvedEffects()) {
            ConeDiagnostic diagnostic;
            if ((ConeDiagnostic)unresolvedEffect.getEffect().accept(DiagnosticExtractor.INSTANCE, null) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)unresolvedEffect.getSource(), FirErrors.INSTANCE.getERROR_IN_CONTRACT_DESCRIPTION(), (Object)diagnostic.getReason(), (DiagnosticContext)context2, null, 16, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final boolean checkContractNotAllowed(FirFunction declaration2, FirResolvedContractDescription contractDescription, CheckerContext context2, DiagnosticReporter reporter) {
        KtSourceElement source;
        block8: {
            block7: {
                KtSourceElement ktSourceElement = source = contractDescription.getSource();
                if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind)) {
                    return false;
                }
                if (declaration2 instanceof FirPropertyAccessor || declaration2 instanceof FirAnonymousFunction) {
                    FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are only allowed for functions.");
                    return true;
                }
                FirMemberDeclaration $this$isAbstract$iv = declaration2;
                boolean $i$f$isAbstract = false;
                if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) break block7;
                FirMemberDeclaration $this$isOpen$iv = declaration2;
                boolean $i$f$isOpen = false;
                if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) break block7;
                FirMemberDeclaration $this$isOverride$iv = declaration2;
                boolean $i$f$isOverride = false;
                if (!$this$isOverride$iv.getStatus().isOverride()) break block8;
            }
            FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are not allowed for open or override functions.");
            return true;
        }
        FirMemberDeclaration $this$isOperator$iv = declaration2;
        boolean $i$f$isOperator = false;
        if ($this$isOperator$iv.getStatus().isOperator()) {
            FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are not allowed for operator functions.");
            return true;
        }
        if (!declaration2.getSymbol().getCallableId().isLocal()) {
            FirMemberDeclaration $this$visibility$iv = declaration2;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) return false;
        }
        FirContractChecker.checkContractNotAllowed$contractNotAllowed(reporter, source, context2, "Contracts are not allowed for local functions.");
        return true;
    }

    private static final void checkContractNotAllowed$contractNotAllowed(DiagnosticReporter $reporter, KtSourceElement source, CheckerContext $context, String message) {
        KtDiagnosticReportHelpersKt.reportOn$default($reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCONTRACT_NOT_ALLOWED(), (Object)message, (DiagnosticContext)$context, null, 16, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u001e\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J,\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\tj\u0002`\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\f\u001a\u0004\u0018\u00010\u00022\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u000ej\u0002`\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0012j\u0002`\u00132\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0016j\u0002`\u00172\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010\u0018\u001a\u00020\u00022\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u00192\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u001b\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u001cj\u0002`\u001d2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0016\u0010\u001f\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020 j\u0002`!2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\"\u001a\u0004\u0018\u00010\u00022\u0016\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020$j\u0002`%2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010&\u001a\u00020\u00022\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020'2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010(\u001a\u0004\u0018\u00010\u00022\u0016\u0010)\u001a\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020*j\u0002`+2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010,\u001a\u00020\u00022\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020.2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u0010/\u001a\u00020\u00022\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016J&\u00102\u001a\u00020\u00022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002042\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u0016\u00a8\u00065"}, d2={"Lksp/org/jetbrains/kotlin/fir/analysis/checkers/declaration/FirContractChecker$DiagnosticExtractor;", "Lksp/org/jetbrains/kotlin/contracts/description/KtContractDescriptionVisitor;", "Lksp/org/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "<init>", "()V", "visitContractDescriptionElement", "contractDescriptionElement", "Lksp/org/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "data", "visitConditionalEffectDeclaration", "conditionalEffect", "Lksp/org/jetbrains/kotlin/contracts/description/KtConditionalEffectDeclaration;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeConditionalEffectDeclaration;", "visitReturnsEffectDeclaration", "returnsEffect", "Lksp/org/jetbrains/kotlin/contracts/description/KtReturnsEffectDeclaration;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeReturnsEffectDeclaration;", "visitCallsEffectDeclaration", "callsEffect", "Lksp/org/jetbrains/kotlin/contracts/description/KtCallsEffectDeclaration;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeCallsEffectDeclaration;", "visitErroneousCallsEffectDeclaration", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousCallsEffectDeclaration;", "visitLogicalBinaryOperationContractExpression", "binaryLogicExpression", "Lksp/org/jetbrains/kotlin/contracts/description/KtBinaryLogicExpression;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeBinaryLogicExpression;", "visitLogicalNot", "logicalNot", "Lksp/org/jetbrains/kotlin/contracts/description/KtLogicalNot;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeLogicalNot;", "visitIsInstancePredicate", "isInstancePredicate", "Lksp/org/jetbrains/kotlin/contracts/description/KtIsInstancePredicate;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeIsInstancePredicate;", "visitErroneousIsInstancePredicate", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousIsInstancePredicate;", "visitIsNullPredicate", "isNullPredicate", "Lksp/org/jetbrains/kotlin/contracts/description/KtIsNullPredicate;", "Lksp/org/jetbrains/kotlin/fir/contracts/description/ConeIsNullPredicate;", "visitErroneousConstantReference", "erroneousConstantReference", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousConstantReference;", "visitErroneousValueParameterReference", "valueParameterReference", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousValueParameterReference;", "visitErroneousElement", "element", "Lksp/org/jetbrains/kotlin/contracts/description/KtErroneousContractElement;", "checkers"})
    private static final class DiagnosticExtractor
    extends KtContractDescriptionVisitor {
        @NotNull
        public static final DiagnosticExtractor INSTANCE = new DiagnosticExtractor();

        private DiagnosticExtractor() {
        }

        @Nullable
        public ConeDiagnostic visitContractDescriptionElement(@NotNull KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> contractDescriptionElement, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(contractDescriptionElement, (String)"contractDescriptionElement");
            return null;
        }

        @Nullable
        public ConeDiagnostic visitConditionalEffectDeclaration(@NotNull KtConditionalEffectDeclaration<ConeKotlinType, ConeDiagnostic> conditionalEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(conditionalEffect, (String)"conditionalEffect");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)conditionalEffect.getEffect().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)conditionalEffect.getCondition().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitReturnsEffectDeclaration(@NotNull KtReturnsEffectDeclaration<ConeKotlinType, ConeDiagnostic> returnsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(returnsEffect, (String)"returnsEffect");
            return (ConeDiagnostic)returnsEffect.getValue().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitCallsEffectDeclaration(@NotNull KtCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(callsEffect, (String)"callsEffect");
            return (ConeDiagnostic)callsEffect.getValueParameterReference().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousCallsEffectDeclaration(@NotNull KtErroneousCallsEffectDeclaration<ConeKotlinType, ConeDiagnostic> callsEffect, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(callsEffect, (String)"callsEffect");
            return callsEffect.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitLogicalBinaryOperationContractExpression(@NotNull KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> binaryLogicExpression, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(binaryLogicExpression, (String)"binaryLogicExpression");
            ConeDiagnostic coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getLeft().accept(this, null);
            if (coneDiagnostic == null) {
                coneDiagnostic = (ConeDiagnostic)binaryLogicExpression.getRight().accept(this, null);
            }
            return coneDiagnostic;
        }

        @Nullable
        public ConeDiagnostic visitLogicalNot(@NotNull KtLogicalNot<ConeKotlinType, ConeDiagnostic> logicalNot, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(logicalNot, (String)"logicalNot");
            return (ConeDiagnostic)logicalNot.getArg().accept(this, null);
        }

        @Nullable
        public ConeDiagnostic visitIsInstancePredicate(@NotNull KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            return (ConeDiagnostic)isInstancePredicate.getArg().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousIsInstancePredicate(@NotNull KtErroneousIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
            return isInstancePredicate.getDiagnostic();
        }

        @Nullable
        public ConeDiagnostic visitIsNullPredicate(@NotNull KtIsNullPredicate<ConeKotlinType, ConeDiagnostic> isNullPredicate, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(isNullPredicate, (String)"isNullPredicate");
            return (ConeDiagnostic)isNullPredicate.getArg().accept(this, data);
        }

        @NotNull
        public ConeDiagnostic visitErroneousConstantReference(@NotNull KtErroneousConstantReference<ConeKotlinType, ConeDiagnostic> erroneousConstantReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(erroneousConstantReference, (String)"erroneousConstantReference");
            return erroneousConstantReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousValueParameterReference(@NotNull KtErroneousValueParameterReference<ConeKotlinType, ConeDiagnostic> valueParameterReference, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(valueParameterReference, (String)"valueParameterReference");
            return valueParameterReference.getDiagnostic();
        }

        @NotNull
        public ConeDiagnostic visitErroneousElement(@NotNull KtErroneousContractElement<ConeKotlinType, ConeDiagnostic> element2, @Nullable Void data) {
            Intrinsics.checkNotNullParameter(element2, (String)"element");
            return element2.getDiagnostic();
        }
    }
}

