/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.sun.jna;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ksp.com.sun.jna.Function;
import ksp.com.sun.jna.Memory;
import ksp.com.sun.jna.Native;
import ksp.com.sun.jna.NativeString;
import ksp.com.sun.jna.Pointer;
import ksp.com.sun.jna.WString;

public class StringArray
extends Memory
implements Function.PostCallRead {
    private String encoding;
    private List<NativeString> natives = new ArrayList<NativeString>();
    private Object[] original;

    public StringArray(String[] strings2) {
        this(strings2, false);
    }

    public StringArray(String[] strings2, boolean wide) {
        this((Object[])strings2, wide ? "--WIDE-STRING--" : Native.getDefaultStringEncoding());
    }

    public StringArray(String[] strings2, String encoding) {
        this((Object[])strings2, encoding);
    }

    public StringArray(WString[] strings2) {
        this(strings2, "--WIDE-STRING--");
    }

    private StringArray(Object[] strings2, String encoding) {
        super((strings2.length + 1) * Native.POINTER_SIZE);
        this.original = strings2;
        this.encoding = encoding;
        for (int i = 0; i < strings2.length; ++i) {
            Pointer p = null;
            if (strings2[i] != null) {
                NativeString ns = new NativeString(strings2[i].toString(), encoding);
                this.natives.add(ns);
                p = ns.getPointer();
            }
            this.setPointer(Native.POINTER_SIZE * i, p);
        }
        this.setPointer(Native.POINTER_SIZE * strings2.length, null);
    }

    @Override
    public void read() {
        boolean returnWide = this.original instanceof WString[];
        boolean wide = "--WIDE-STRING--".equals(this.encoding);
        for (int si = 0; si < this.original.length; ++si) {
            Pointer p = this.getPointer(si * Native.POINTER_SIZE);
            CharSequence s = null;
            if (p != null) {
                String string2 = s = wide ? p.getWideString(0L) : p.getString(0L, this.encoding);
                if (returnWide) {
                    s = new WString((String)s);
                }
            }
            this.original[si] = s;
        }
    }

    @Override
    public String toString() {
        boolean wide = "--WIDE-STRING--".equals(this.encoding);
        String s = wide ? "const wchar_t*[]" : "const char*[]";
        s = s + Arrays.asList(this.original);
        return s;
    }
}

