/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.fir.renderer;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.builtins.StandardNames;
import ksp.org.jetbrains.kotlin.fir.renderer.ConeAttributeRenderer;
import ksp.org.jetbrains.kotlin.fir.renderer.ConeIdRenderer;
import ksp.org.jetbrains.kotlin.fir.renderer.ConeTypeRenderer;
import ksp.org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import ksp.org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import ksp.org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import ksp.org.jetbrains.kotlin.fir.types.ConeKotlinType;
import ksp.org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import ksp.org.jetbrains.kotlin.renderer.RenderingUtilsKt;
import ksp.org.jetbrains.kotlin.types.model.TypeConstructorMarker;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB;\b\u0016\u0012\n\u0010\u000b\u001a\u00060\rj\u0002`\f\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\f\u0010\u001b\u001a\u00020\u0010*\u00020\u0015H\u0014J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0004H\u0016R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lksp/org/jetbrains/kotlin/fir/renderer/ConeTypeRendererForReadability;", "Lksp/org/jetbrains/kotlin/fir/renderer/ConeTypeRenderer;", "preRenderedConstructors", "", "Lksp/org/jetbrains/kotlin/types/model/TypeConstructorMarker;", "", "idRendererCreator", "Lkotlin/Function0;", "Lksp/org/jetbrains/kotlin/fir/renderer/ConeIdRenderer;", "<init>", "(Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "builder", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "(Ljava/lang/StringBuilder;Ljava/util/Map;Lkotlin/jvm/functions/Function0;)V", "render", "", "flexibleType", "Lksp/org/jetbrains/kotlin/fir/types/ConeFlexibleType;", "renderBound", "bound", "Lksp/org/jetbrains/kotlin/fir/types/ConeKotlinType;", "renderFlexibleTypeCompact", "lowerRendered", "upperRendered", "type", "Lksp/org/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "renderAttributes", "renderConstructor", "constructor", "cones"})
public class ConeTypeRendererForReadability
extends ConeTypeRenderer {
    @Nullable
    private final Map<TypeConstructorMarker, String> preRenderedConstructors;
    @NotNull
    private final Function0<ConeIdRenderer> idRendererCreator;

    public ConeTypeRendererForReadability(@Nullable Map<TypeConstructorMarker, String> preRenderedConstructors, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator) {
        Intrinsics.checkNotNullParameter(idRendererCreator, (String)"idRendererCreator");
        super(ConeAttributeRenderer.ForReadability.INSTANCE);
        this.preRenderedConstructors = preRenderedConstructors;
        this.idRendererCreator = idRendererCreator;
    }

    public /* synthetic */ ConeTypeRendererForReadability(Map map, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map = null;
        }
        this(map, (Function0<? extends ConeIdRenderer>)function0);
    }

    public ConeTypeRendererForReadability(@NotNull StringBuilder builder2, @Nullable Map<TypeConstructorMarker, String> preRenderedConstructors, @NotNull Function0<? extends ConeIdRenderer> idRendererCreator) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(idRendererCreator, (String)"idRendererCreator");
        this(preRenderedConstructors, idRendererCreator);
        this.setBuilder(builder2);
        this.setIdRenderer((ConeIdRenderer)idRendererCreator.invoke());
        this.getIdRenderer().setBuilder(builder2);
    }

    public /* synthetic */ ConeTypeRendererForReadability(StringBuilder stringBuilder, Map map, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            map = null;
        }
        this(stringBuilder, map, (Function0<? extends ConeIdRenderer>)function0);
    }

    @Override
    protected void render(@NotNull ConeFlexibleType flexibleType) {
        Intrinsics.checkNotNullParameter((Object)flexibleType, (String)"flexibleType");
        ConeSimpleKotlinType lower2 = flexibleType.getLowerBound();
        String lowerRendered = this.renderBound(lower2);
        String upperRendered = this.renderBound(flexibleType.getUpperBound());
        String string2 = this.renderFlexibleTypeCompact(lowerRendered, upperRendered);
        if (string2 == null) {
            ConeTypeRendererForReadability $this$render_u24lambda_u240 = this;
            boolean bl = false;
            String string3 = lower2 instanceof ConeDefinitelyNotNullType ? $this$render_u24lambda_u240.renderFlexibleTypeCompact($this$render_u24lambda_u240.renderBound(((ConeDefinitelyNotNullType)lower2).getOriginal()), upperRendered) : null;
            string2 = string3;
            if (string3 == null) {
                string2 = '(' + lowerRendered + ".." + upperRendered + ')';
            }
        }
        String rendered = string2;
        this.getBuilder().append(rendered);
    }

    private final String renderBound(ConeKotlinType bound) {
        ConeTypeRendererForReadability renderer = new ConeTypeRendererForReadability(new StringBuilder(), this.preRenderedConstructors, this.idRendererCreator);
        renderer.render(bound);
        String string2 = renderer.getBuilder().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String renderFlexibleTypeCompact(String lowerRendered, String upperRendered) {
        String array;
        String mutableEntry;
        String simpleCollection;
        if (RenderingUtilsKt.typeStringsDifferOnlyInNullability(lowerRendered, upperRendered)) {
            if (StringsKt.startsWith$default((String)upperRendered, (String)"(", (boolean)false, (int)2, null)) {
                return '(' + lowerRendered + ")!";
            }
            return lowerRendered + '!';
        }
        String kotlinCollectionsPrefix = StandardNames.COLLECTIONS_PACKAGE_FQ_NAME.asString() + '.';
        String mutablePrefix = "Mutable";
        String string2 = simpleCollection = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + mutablePrefix, upperRendered, kotlinCollectionsPrefix, kotlinCollectionsPrefix + '(' + mutablePrefix + ')');
        if (string2 != null) {
            return string2;
        }
        String string3 = mutableEntry = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinCollectionsPrefix + "MutableMap.MutableEntry", upperRendered, kotlinCollectionsPrefix + "Map.Entry", kotlinCollectionsPrefix + "(Mutable)Map.(Mutable)Entry");
        if (string3 != null) {
            return string3;
        }
        String kotlinPrefix = StandardNames.BUILT_INS_PACKAGE_FQ_NAME.asString() + '.';
        String string4 = array = RenderingUtilsKt.replacePrefixesInTypeRepresentations(lowerRendered, kotlinPrefix + "Array<", upperRendered, kotlinPrefix + "Array<out ", kotlinPrefix + "Array<(out) ");
        if (string4 != null) {
            return string4;
        }
        return null;
    }

    @Override
    protected void render(@NotNull ConeIntegerLiteralType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        this.render(ConeIntegerLiteralType.getApproximatedType$default(type2, null, 1, null));
    }

    @Override
    protected void renderAttributes(@NotNull ConeKotlinType $this$renderAttributes) {
        Intrinsics.checkNotNullParameter((Object)$this$renderAttributes, (String)"<this>");
        this.renderNonCompilerAttributes($this$renderAttributes);
    }

    @Override
    public void renderConstructor(@NotNull TypeConstructorMarker constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        Map<TypeConstructorMarker, String> map = this.preRenderedConstructors;
        if (map != null && (map = map.get(constructor)) != null) {
            Map<TypeConstructorMarker, String> it = map;
            boolean bl = false;
            this.getBuilder().append((String)((Object)it));
            return;
        }
        super.renderConstructor(constructor);
    }
}

