/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;
import ksp.org.jetbrains.kotlin.analysis.api.annotations.KaAnnotationValue;
import ksp.org.jetbrains.kotlin.analysis.api.base.KaConstantValue;
import ksp.org.jetbrains.kotlin.analysis.api.components.KaCompileTimeConstantProvider;
import ksp.org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import ksp.org.jetbrains.kotlin.analysis.api.fir.components.KaFirSessionComponent;
import ksp.org.jetbrains.kotlin.analysis.api.fir.evaluate.FirAnnotationValueConverter;
import ksp.org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import ksp.org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import ksp.org.jetbrains.kotlin.fir.FirElement;
import ksp.org.jetbrains.kotlin.fir.expressions.FirExpression;
import ksp.org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import ksp.org.jetbrains.kotlin.fir.references.FirNamedReference;
import ksp.org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0010H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0017"}, d2={"Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KaFirCompileTimeConstantProvider;", "Lksp/org/jetbrains/kotlin/analysis/api/components/KaCompileTimeConstantProvider;", "Lksp/org/jetbrains/kotlin/analysis/api/fir/components/KaFirSessionComponent;", "analysisSession", "Lksp/org/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "token", "Lksp/org/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KaLifetimeToken;", "evaluate", "Lksp/org/jetbrains/kotlin/analysis/api/base/KaConstantValue;", "expression", "Lksp/org/jetbrains/kotlin/psi/KtExpression;", "evaluateAsAnnotationValue", "Lksp/org/jetbrains/kotlin/analysis/api/annotations/KaAnnotationValue;", "evaluateFir", "fir", "Lksp/org/jetbrains/kotlin/fir/FirElement;", "sourcePsi", "analysis-api-fir"})
public final class KaFirCompileTimeConstantProvider
extends KaCompileTimeConstantProvider
implements KaFirSessionComponent {
    @NotNull
    private final KaFirSession analysisSession;
    @NotNull
    private final KaLifetimeToken token;

    public KaFirCompileTimeConstantProvider(@NotNull KaFirSession analysisSession, @NotNull KaLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KaFirSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KaLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public KaConstantValue evaluate(@NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.evaluateFir(LowLevelFirApiFacadeKt.getOrBuildFir(expression2, this.getFirResolveSession()), expression2);
    }

    @Override
    @Nullable
    public KaAnnotationValue evaluateAsAnnotationValue(@NotNull KtExpression expression2) {
        KaAnnotationValue kaAnnotationValue;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        FirElement firElement = LowLevelFirApiFacadeKt.getOrBuildFir(expression2, this.getFirResolveSession());
        FirExpression firExpression = firElement instanceof FirExpression ? (FirExpression)firElement : null;
        if (firExpression != null) {
            FirExpression it = firExpression;
            boolean bl = false;
            kaAnnotationValue = FirAnnotationValueConverter.INSTANCE.toConstantValue(it, this.getAnalysisSession().getFirSymbolBuilder$analysis_api_fir());
        } else {
            kaAnnotationValue = null;
        }
        return kaAnnotationValue;
    }

    private final KaConstantValue evaluateFir(FirElement fir, KtExpression sourcePsi) {
        KaConstantValue kaConstantValue;
        if (fir instanceof FirPropertyAccessExpression || fir instanceof FirExpression || fir instanceof FirNamedReference) {
            KaConstantValue kaConstantValue2;
            try {
                kaConstantValue2 = FirCompileTimeConstantEvaluator.INSTANCE.evaluateAsKtConstantValue(fir);
            }
            catch (ArithmeticException e) {
                String string2 = e.getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLocalizedMessage(...)");
                kaConstantValue2 = new KaConstantValue.KaErrorConstantValue(string2, sourcePsi);
            }
            kaConstantValue = kaConstantValue2;
        } else {
            kaConstantValue = null;
        }
        return kaConstantValue;
    }
}

