/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jdom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.util.ArrayUtilRt;
import ksp.org.jdom.Attribute;
import ksp.org.jdom.AttributeType;
import ksp.org.jdom.ImmutableAttribute;
import ksp.org.jdom.ImmutableElement;
import ksp.org.jdom.JDOMInterner;
import ksp.org.jdom.Namespace;
import ksp.org.jetbrains.annotations.NotNull;

final class ImmutableSameTypeAttributeList
implements List<Attribute> {
    private static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    private final String[] myNameValues;
    private final AttributeType myType;
    private final Namespace myNs;

    ImmutableSameTypeAttributeList(String @NotNull [] nameValues, AttributeType type2, @NotNull Namespace ns) {
        if (ns == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(0);
        }
        if (nameValues == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(1);
        }
        this.myNameValues = nameValues.length == 0 ? EMPTY_STRING_ARRAY : nameValues;
        this.myType = type2;
        this.myNs = ns;
    }

    @Override
    public Attribute get(int index) {
        return new ImmutableAttribute(this.myNameValues[index * 2], this.myNameValues[index * 2 + 1], this.myType, this.myNs);
    }

    Attribute get(String name2, Namespace namespace) {
        if (!this.myNs.equals(namespace)) {
            return null;
        }
        for (int i = 0; i < this.myNameValues.length; i += 2) {
            String aname = this.myNameValues[i];
            if (!aname.equals(name2)) continue;
            return this.get(i / 2);
        }
        return null;
    }

    String getValue(String name2, Namespace namespace, String def) {
        if (!this.myNs.equals(namespace)) {
            return def;
        }
        for (int i = 0; i < this.myNameValues.length; i += 2) {
            String aname = this.myNameValues[i];
            if (!aname.equals(name2)) continue;
            return this.myNameValues[i + 1];
        }
        return def;
    }

    @Override
    public int size() {
        return this.myNameValues.length / 2;
    }

    public String toString() {
        return this.toList().toString();
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!Comparing.equal(0, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!Comparing.equal(0, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    public Iterator<Attribute> iterator() {
        if (this.isEmpty()) {
            Iterator<Attribute> iterator2 = Collections.emptyIterator();
            if (iterator2 == null) {
                ImmutableSameTypeAttributeList.$$$reportNull$$$0(2);
            }
            return iterator2;
        }
        return new Iterator<Attribute>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < ImmutableSameTypeAttributeList.this.size();
            }

            @Override
            public Attribute next() {
                return ImmutableSameTypeAttributeList.this.get(this.i++);
            }

            @Override
            public void remove() {
                throw ImmutableElement.immutableError(ImmutableSameTypeAttributeList.this);
            }
        };
    }

    @Override
    @NotNull
    public List<Attribute> subList(int fromIndex, int toIndex) {
        List<Attribute> list = this.toList().subList(fromIndex, toIndex);
        if (list == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(3);
        }
        return list;
    }

    private List<Attribute> toList() {
        ArrayList<Attribute> list = new ArrayList<Attribute>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List) || this.size() != ((List)o).size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (o instanceof ImmutableSameTypeAttributeList) {
            ImmutableSameTypeAttributeList io = (ImmutableSameTypeAttributeList)o;
            return this.myType == io.myType && this.myNs.equals(io.myNs) && Arrays.equals(this.myNameValues, io.myNameValues);
        }
        List l = (List)o;
        for (int i = 0; i < this.myNameValues.length; i += 2) {
            String name2 = this.myNameValues[i];
            String value2 = this.myNameValues[i + 1];
            Attribute a2 = (Attribute)l.get(i / 2);
            if (Objects.equals(name2, a2.getName()) && Objects.equals(value2, a2.getValue()) && Comparing.equal(this.myType, a2.getAttributeType()) && Comparing.equal(this.myNs, a2.getNamespace())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (int i = 0; i < this.myNameValues.length; i += 2) {
            String name2 = this.myNameValues[i];
            String value2 = this.myNameValues[i + 1];
            result2 = result2 * 31 + JDOMInterner.computeAttributeHashCode(name2, value2);
        }
        return result2;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Object @NotNull [] toArray() {
        Object[] objectArray = this.toList().toArray(new Attribute[0]);
        if (objectArray == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    @Override
    public <T> T @NotNull [] toArray(T @NotNull [] a) {
        if (a == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(5);
        }
        Object[] objectArray = this.toArray();
        if (objectArray == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(6);
        }
        return objectArray;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(7);
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(Attribute obj) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public void add(int index, Attribute obj) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Attribute> collection) {
        if (collection == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(8);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends Attribute> collection) {
        if (collection == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(9);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public void clear() {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Attribute remove(int index) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Attribute set(int index, Attribute obj) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    @NotNull
    public ListIterator<Attribute> listIterator() {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    @NotNull
    public ListIterator<Attribute> listIterator(int index) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean remove(Object o) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(10);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (c == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(11);
        }
        throw ImmutableElement.immutableError(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameValues";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/org/jdom/ImmutableSameTypeAttributeList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/org/jdom/ImmutableSameTypeAttributeList";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

