/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.fasterxml.aalto.impl;

import ksp.org.codehaus.stax2.XMLStreamLocation2;

public class LocationImpl
implements XMLStreamLocation2 {
    private static final LocationImpl EMPTY = new LocationImpl("", "", -1, -1, -1);
    protected final String _publicId;
    protected final String _systemId;
    protected final int _charOffset;
    protected final int _col;
    protected final int _row;
    protected transient String _desc = null;

    public LocationImpl(String pubId, String sysId, int charOffset, int row, int col) {
        this._publicId = pubId;
        this._systemId = sysId;
        this._charOffset = charOffset < 0 ? Integer.MAX_VALUE : charOffset;
        this._col = col;
        this._row = row;
    }

    public static LocationImpl fromZeroBased(String pubId, String sysId, long rawOffset, int rawRow, int rawCol) {
        int offset = (int)rawOffset;
        return new LocationImpl(pubId, sysId, offset, rawRow + 1, rawCol + 1);
    }

    public static LocationImpl getEmptyLocation() {
        return EMPTY;
    }

    @Override
    public int getCharacterOffset() {
        return this._charOffset;
    }

    @Override
    public int getColumnNumber() {
        return this._col;
    }

    @Override
    public int getLineNumber() {
        return this._row;
    }

    @Override
    public String getPublicId() {
        return this._publicId;
    }

    @Override
    public String getSystemId() {
        return this._systemId;
    }

    @Override
    public XMLStreamLocation2 getContext() {
        return null;
    }

    public String toString() {
        if (this._desc == null) {
            StringBuffer sb = new StringBuffer(100);
            this.appendDesc(sb);
            this._desc = sb.toString();
        }
        return this._desc;
    }

    private void appendDesc(StringBuffer sb) {
        String srcId;
        if (this._systemId != null) {
            sb.append("[row,col,system-id]: ");
            srcId = this._systemId;
        } else if (this._publicId != null) {
            sb.append("[row,col,public-id]: ");
            srcId = this._publicId;
        } else {
            sb.append("[row,col {unknown-source}]: ");
            srcId = null;
        }
        sb.append('[');
        sb.append(this._row);
        sb.append(',');
        sb.append(this._col);
        if (srcId != null) {
            sb.append(',');
            sb.append('\"');
            sb.append(srcId);
            sb.append('\"');
        }
        sb.append(']');
    }
}

